/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.data;

import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.math.ChunkDimPos;
import com.feed_the_beast.ftbutilities.FTBUtilitiesConfig;
import com.feed_the_beast.ftbutilities.FTBUtilitiesNotifications;
import com.feed_the_beast.ftbutilities.FTBUtilitiesPermissions;
import com.feed_the_beast.ftbutilities.data.ClaimResult;
import com.feed_the_beast.ftbutilities.data.ClaimedChunk;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesLoadedChunkManager;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesPlayerData;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesTeamData;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesUniverseData;
import com.feed_the_beast.ftbutilities.events.chunks.ChunkModifiedEvent;
import com.feed_the_beast.ftbutilities.net.MessageClaimedChunksUpdate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.server.permission.PermissionAPI;

public class ClaimedChunks {
    public static ClaimedChunks instance;
    public final Universe universe;
    private final Collection<ClaimedChunk> pendingChunks = new HashSet<ClaimedChunk>();
    private final Map<ChunkDimPos, ClaimedChunk> map = new HashMap<ChunkDimPos, ClaimedChunk>();
    public long nextChunkloaderUpdate;
    private boolean isDirty = true;

    public static boolean isActive() {
        return instance != null && FTBUtilitiesConfig.world.chunk_claiming;
    }

    public ClaimedChunks(Universe u) {
        this.universe = u;
    }

    @Nullable
    public ForgeTeam getChunkTeam(ChunkDimPos pos) {
        ClaimedChunk chunk = this.getChunk(pos);
        return chunk == null ? null : chunk.getTeam();
    }

    public void markDirty() {
        this.isDirty = true;
    }

    public void clear() {
        this.pendingChunks.clear();
        this.map.clear();
        this.nextChunkloaderUpdate = 0L;
        this.isDirty = true;
    }

    public void processQueue() {
        if (!this.pendingChunks.isEmpty()) {
            for (ClaimedChunk chunk : this.pendingChunks) {
                ClaimedChunk prevChunk = this.map.put(chunk.getPos(), chunk);
                if (prevChunk != null && prevChunk != chunk) {
                    prevChunk.setInvalid();
                }
                this.markDirty();
            }
            this.pendingChunks.clear();
        }
        Iterator<ClaimedChunk> iterator = this.map.values().iterator();
        while (iterator.hasNext()) {
            ClaimedChunk chunk;
            chunk = iterator.next();
            if (!chunk.isInvalid()) continue;
            FTBUtilitiesLoadedChunkManager.INSTANCE.unforceChunk(chunk);
            iterator.remove();
        }
    }

    public void update(Universe universe, long now) {
        if (this.nextChunkloaderUpdate <= now) {
            this.nextChunkloaderUpdate = now + 60000L;
            this.markDirty();
        }
        if (this.isDirty) {
            this.processQueue();
            if (FTBUtilitiesConfig.world.chunk_loading) {
                for (ForgeTeam team : universe.getTeams()) {
                    FTBUtilitiesTeamData.get((ForgeTeam)team).canForceChunks = FTBUtilitiesLoadedChunkManager.INSTANCE.canForceChunks(team);
                }
                for (ClaimedChunk chunk : this.getAllChunks()) {
                    boolean force;
                    boolean bl = force = chunk.getData().canForceChunks && chunk.isLoaded();
                    if (chunk.forced != null && chunk.forced == force) continue;
                    if (force) {
                        FTBUtilitiesLoadedChunkManager.INSTANCE.forceChunk(universe.server, chunk);
                        continue;
                    }
                    FTBUtilitiesLoadedChunkManager.INSTANCE.unforceChunk(chunk);
                }
            }
            for (EntityPlayerMP player : universe.server.func_184103_al().func_181057_v()) {
                ChunkDimPos playerPos = new ChunkDimPos((Entity)player);
                int startX = playerPos.posX - 7;
                int startZ = playerPos.posZ - 7;
                new MessageClaimedChunksUpdate(startX, startZ, (EntityPlayer)player).sendTo(player);
                FTBUtilitiesNotifications.updateChunkMessage(player, playerPos);
            }
            this.isDirty = false;
        }
    }

    @Nullable
    public ClaimedChunk getChunk(ChunkDimPos pos) {
        if (FTBUtilitiesConfig.world.blockDimension(pos.dim)) {
            return null;
        }
        ClaimedChunk chunk = this.map.get(pos);
        return chunk == null || chunk.isInvalid() ? null : chunk;
    }

    public void removeChunk(ChunkDimPos pos) {
        ClaimedChunk prevChunk = this.map.get(pos);
        if (prevChunk != null) {
            prevChunk.setInvalid();
            this.markDirty();
        }
    }

    public void addChunk(ClaimedChunk chunk) {
        this.pendingChunks.add(chunk);
        chunk.getTeam().markDirty();
        this.markDirty();
    }

    public Collection<ClaimedChunk> getAllChunks() {
        return this.map.isEmpty() ? Collections.emptyList() : this.map.values();
    }

    public Set<ClaimedChunk> getTeamChunks(@Nullable ForgeTeam team, OptionalInt dimension, boolean includePending) {
        if (team == null) {
            return Collections.emptySet();
        }
        HashSet<ClaimedChunk> set = new HashSet<ClaimedChunk>();
        for (ClaimedChunk chunk : this.map.values()) {
            if (chunk.isInvalid() || !team.equalsTeam(chunk.getTeam()) || dimension.isPresent() && dimension.getAsInt() != chunk.getPos().dim) continue;
            set.add(chunk);
        }
        if (includePending) {
            for (ClaimedChunk chunk : this.pendingChunks) {
                if (!team.equalsTeam(chunk.getTeam()) || dimension.isPresent() && dimension.getAsInt() != chunk.getPos().dim) continue;
                set.add(chunk);
            }
        }
        return set;
    }

    public Set<ClaimedChunk> getTeamChunks(@Nullable ForgeTeam team, OptionalInt dimension) {
        return this.getTeamChunks(team, dimension, false);
    }

    public static boolean canAttackEntity(EntityPlayer player, Entity target) {
        if (!ClaimedChunks.isActive() || player.field_70170_p == null || !(player instanceof EntityPlayerMP)) {
            return true;
        }
        if (target instanceof EntityPlayer) {
            if (FTBUtilitiesConfig.world.safe_spawn && player.field_70170_p.field_73011_w.getDimension() == 0 && FTBUtilitiesUniverseData.isInSpawn(ClaimedChunks.instance.universe.server, new ChunkDimPos(target))) {
                return false;
            }
            if (FTBUtilitiesConfig.world.enable_pvp.isDefault()) {
                return FTBUtilitiesPlayerData.get(ClaimedChunks.instance.universe.getPlayer((ICommandSender)player)).enablePVP() && FTBUtilitiesPlayerData.get(ClaimedChunks.instance.universe.getPlayer((ICommandSender)target)).enablePVP();
            }
            return FTBUtilitiesConfig.world.enable_pvp.isTrue();
        }
        if (!(target instanceof IMob)) {
            ClaimedChunk chunk = instance.getChunk(new ChunkDimPos(target));
            return chunk == null || PermissionAPI.hasPermission((EntityPlayer)player, (String)"ftbutilities.claims.attack_animals") || chunk.getTeam().hasStatus(ClaimedChunks.instance.universe.getPlayer((ICommandSender)player), chunk.getData().getAttackEntitiesStatus());
        }
        return true;
    }

    public static boolean blockBlockEditing(EntityPlayer player, BlockPos pos, @Nullable IBlockState state) {
        ClaimedChunk chunk;
        if (!ClaimedChunks.isActive() || player.field_70170_p == null || !(player instanceof EntityPlayerMP)) {
            return false;
        }
        if (state == null) {
            state = player.field_70170_p.func_180495_p(pos);
        }
        return (chunk = instance.getChunk(new ChunkDimPos(pos, player.field_71093_bK))) != null && !FTBUtilitiesPermissions.hasBlockEditingPermission(player, state.func_177230_c()) && !chunk.getTeam().hasStatus(ClaimedChunks.instance.universe.getPlayer((ICommandSender)player), chunk.getData().getEditBlocksStatus());
    }

    public static boolean blockBlockInteractions(EntityPlayer player, BlockPos pos, @Nullable IBlockState state) {
        ClaimedChunk chunk;
        if (!ClaimedChunks.isActive() || player.field_70170_p == null || !(player instanceof EntityPlayerMP)) {
            return false;
        }
        if (state == null) {
            state = player.field_70170_p.func_180495_p(pos);
        }
        return (chunk = instance.getChunk(new ChunkDimPos(pos, player.field_71093_bK))) != null && !FTBUtilitiesPermissions.hasBlockInteractionPermission(player, state.func_177230_c()) && !chunk.getTeam().hasStatus(ClaimedChunks.instance.universe.getPlayer((ICommandSender)player), chunk.getData().getInteractWithBlocksStatus());
    }

    public static boolean blockItemUse(EntityPlayer player, EnumHand hand, BlockPos pos) {
        if (!ClaimedChunks.isActive() || player.field_70170_p == null || !(player instanceof EntityPlayerMP) || player.func_184586_b(hand).func_190926_b()) {
            return false;
        }
        ClaimedChunk chunk = instance.getChunk(new ChunkDimPos(pos, player.field_71093_bK));
        return chunk != null && !FTBUtilitiesPermissions.hasItemUsePermission(player, player.func_184586_b(hand).func_77973_b()) && !chunk.getTeam().hasStatus(ClaimedChunks.instance.universe.getPlayer((ICommandSender)player), chunk.getData().getUseItemsStatus());
    }

    public boolean canPlayerModify(ForgePlayer player, ChunkDimPos pos, String perm) {
        ClaimedChunk chunk = this.getChunk(pos);
        if (chunk == null) {
            return true;
        }
        if (FTBUtilitiesConfig.world.blockDimension(pos.dim)) {
            return false;
        }
        return player.hasTeam() && chunk.getTeam().equalsTeam(player.team) || perm.isEmpty() || player.hasPermission(perm);
    }

    public ClaimResult claimChunk(ForgePlayer player, ChunkDimPos pos) {
        int max;
        if (!player.hasTeam()) {
            return ClaimResult.NO_TEAM;
        }
        if (FTBUtilitiesConfig.world.blockDimension(pos.dim)) {
            return ClaimResult.DIMENSION_BLOCKED;
        }
        FTBUtilitiesTeamData data = FTBUtilitiesTeamData.get(player.team);
        if (!(player.hasPermission("ftbutilities.claims.bypass_limits") || (max = data.getMaxClaimChunks()) != 0 && this.getTeamChunks(data.team, OptionalInt.empty(), true).size() < max)) {
            return ClaimResult.NO_POWER;
        }
        ClaimedChunk chunk = this.getChunk(pos);
        if (chunk != null) {
            return ClaimResult.ALREADY_CLAIMED;
        }
        if (new ChunkModifiedEvent.Claim(pos, player).post()) {
            return ClaimResult.BLOCKED;
        }
        chunk = new ClaimedChunk(pos, data);
        this.addChunk(chunk);
        new ChunkModifiedEvent.Claimed(chunk).post();
        return ClaimResult.SUCCESS;
    }

    public boolean unclaimChunk(ChunkDimPos pos) {
        ClaimedChunk chunk = this.map.get(pos);
        if (chunk != null && !chunk.isInvalid()) {
            if (chunk.isLoaded()) {
                new ChunkModifiedEvent.Unloaded(chunk).post();
            }
            chunk.setLoaded(false);
            new ChunkModifiedEvent.Unclaimed(chunk).post();
            this.removeChunk(pos);
            return true;
        }
        return false;
    }

    public void unclaimAllChunks(ForgeTeam team, OptionalInt dim) {
        for (ClaimedChunk chunk : this.getTeamChunks(team, dim)) {
            ChunkDimPos pos = chunk.getPos();
            if (chunk.isLoaded()) {
                new ChunkModifiedEvent.Unloaded(chunk).post();
            }
            chunk.setLoaded(false);
            new ChunkModifiedEvent.Unclaimed(chunk).post();
            this.removeChunk(pos);
        }
    }

    public boolean loadChunk(ForgeTeam team, ChunkDimPos pos) {
        ClaimedChunk chunk = this.getChunk(pos);
        if (chunk == null || chunk.isLoaded()) {
            return false;
        }
        int max = FTBUtilitiesTeamData.get(team).getMaxChunkloaderChunks();
        if (max == 0) {
            return false;
        }
        int loadedChunks = 0;
        for (ClaimedChunk c : this.getTeamChunks(team, OptionalInt.empty())) {
            if (!c.isLoaded() || ++loadedChunks < max) continue;
            return false;
        }
        if (chunk.setLoaded(true)) {
            new ChunkModifiedEvent.Loaded(chunk).post();
        }
        return true;
    }

    public boolean unloadChunk(ChunkDimPos pos) {
        ClaimedChunk chunk = this.getChunk(pos);
        if (chunk == null || !chunk.isLoaded()) {
            return false;
        }
        new ChunkModifiedEvent.Unloaded(chunk).post();
        chunk.setLoaded(false);
        return true;
    }
}

