/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.config;

import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.ConfigValueInstance;
import com.feed_the_beast.ftblib.lib.config.IIteratingConfig;
import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.SimpleTextButton;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiButtonListBase;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftblib.lib.util.misc.NameMap;
import com.google.gson.JsonElement;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class ConfigEnum<E>
extends ConfigValue
implements IIteratingConfig {
    public static final String ID = "enum";
    public static final Color4I COLOR = Color4I.rgb(38143);
    private final NameMap<E> nameMap;
    private E value;

    public ConfigEnum(NameMap<E> nm) {
        this.nameMap = nm;
        this.value = nm.defaultValue;
    }

    @Override
    public String getID() {
        return ID;
    }

    public NameMap<E> getNameMap() {
        return this.nameMap;
    }

    public E getValue() {
        return this.value;
    }

    public void setValue(E e) {
        this.value = e;
    }

    public void setValue(String value) {
        this.setValue(this.getNameMap().get(value));
    }

    @Override
    public String getString() {
        return this.getNameMap().getName(this.getValue());
    }

    @Override
    public ITextComponent getStringForGUI() {
        return this.getNameMap().getDisplayName(null, this.getValue());
    }

    @Override
    public boolean getBoolean() {
        return !this.isDefault();
    }

    @Override
    public int getInt() {
        return this.getNameMap().getIndex(this.getValue());
    }

    @Override
    public ConfigEnum<E> copy() {
        return new ConfigEnum<E>(this.getNameMap().withDefault(this.getNameMap().get(this.getInt())));
    }

    @Override
    public Color4I getColor() {
        Color4I col = this.getNameMap().getColor(this.getValue());
        return col.isEmpty() ? COLOR : col;
    }

    @Override
    public void addInfo(ConfigValueInstance inst, List<String> list) {
        NameMap<E> nameMap = this.getNameMap();
        if (inst.getCanEdit() && !inst.getDefaultValue().isNull()) {
            list.add(TextFormatting.AQUA + "Default: " + TextFormatting.RESET + nameMap.getDisplayName(null, nameMap.get(inst.getDefaultValue().getString())).func_150254_d());
        }
        list.add("");
        for (E v : nameMap) {
            list.add((v == this.getValue() ? TextFormatting.AQUA + "+ " : TextFormatting.DARK_GRAY + "- ") + nameMap.getDisplayName(null, v).func_150260_c());
        }
    }

    @Override
    public void onClicked(final IOpenableGui gui, ConfigValueInstance inst, MouseButton button, final Runnable callback) {
        if (this.getNameMap().values.size() > 16 || GuiBase.isCtrlKeyDown()) {
            GuiButtonListBase g = new GuiButtonListBase(){

                @Override
                public void addButtons(Panel panel) {
                    for (final Object v : ConfigEnum.this.getNameMap()) {
                        panel.add(new SimpleTextButton(panel, ConfigEnum.this.getNameMap().getDisplayName((ICommandSender)Minecraft.func_71410_x().field_71439_g, v).func_150260_c(), Icon.EMPTY){

                            @Override
                            public void onClicked(MouseButton button) {
                                GuiHelper.playClickSound();
                                ConfigEnum.this.setValue(v);
                                gui.openGui();
                                callback.run();
                            }
                        });
                    }
                }
            };
            g.setHasSearchBox(true);
            g.openGui();
            return;
        }
        super.onClicked(gui, inst, button, callback);
    }

    @Override
    public List<String> getVariants() {
        return this.getNameMap().keys;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String key) {
        nbt.func_74778_a(key, this.getString());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String key) {
        this.setValue(nbt.func_74779_i(key));
    }

    @Override
    public void writeData(DataOut data) {
        NameMap nameMap = this.getNameMap();
        data.writeVarInt(nameMap.size());
        for (Map.Entry entry : nameMap.map.entrySet()) {
            data.writeString(entry.getKey());
            data.writeTextComponent(nameMap.getDisplayName(null, entry.getValue()));
            data.writeInt(nameMap.getColor(entry.getValue()).rgba());
        }
        data.writeString(this.getString());
    }

    @Override
    public void readData(DataIn data) {
        throw new IllegalStateException("Can't read Abstract Enum property!");
    }

    @Override
    public ConfigValue getIteration(boolean next) {
        ConfigValue c = this.copy();
        ((ConfigEnum)c).setValue(next ? this.getNameMap().getNext(this.getValue()) : this.getNameMap().getPrevious(this.getValue()));
        return c;
    }

    @Override
    public boolean setValueFromString(@Nullable ICommandSender sender, String string, boolean simulate) {
        E val = this.getNameMap().getNullable(string);
        if (val != null) {
            if (!simulate) {
                this.setValue(val);
            }
            return true;
        }
        return false;
    }

    @Override
    public void setValueFromOtherValue(ConfigValue value) {
        this.setValue(value.getString());
    }

    @Override
    public void setValueFromJson(JsonElement json) {
        if (json.isJsonPrimitive()) {
            this.setValue(json.getAsString());
        }
    }

    public boolean isDefault() {
        return this.getValue() == this.getNameMap().defaultValue;
    }

    public static class SimpleEnum<T>
    extends ConfigEnum<T> {
        private final Supplier<T> get;
        private final Consumer<T> set;

        public SimpleEnum(NameMap<T> nm, Supplier<T> g, Consumer<T> s) {
            super(nm);
            this.get = g;
            this.set = s;
        }

        @Override
        public T getValue() {
            return this.get.get();
        }

        @Override
        public void setValue(T e) {
            this.set.accept(e);
        }
    }
}

