/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.common.AutomaticEventSubscriber;
import net.minecraftforge.fml.common.CertificateHelper;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ILanguageAdapter;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.MetadataCollection;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModClassLoader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.ProxyInjector;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLEvent;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.common.versioning.DependencyParser;
import net.minecraftforge.fml.common.versioning.VersionParser;
import net.minecraftforge.fml.common.versioning.VersionRange;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.message.FormattedMessage;

public class FMLModContainer
implements ModContainer {
    private Object modInstance;
    private File source;
    private ModMetadata modMetadata;
    private String className;
    private Map<String, Object> descriptor;
    private boolean enabled = true;
    private String internalVersion;
    private boolean overridesMetadata;
    private EventBus eventBus;
    private LoadController controller;
    private DefaultArtifactVersion processedVersion;
    private String annotationDependencies;
    private VersionRange minecraftAccepted;
    private boolean fingerprintNotPresent;
    private Set<String> sourceFingerprints;
    private Certificate certificate;
    private String modLanguage;
    private ILanguageAdapter languageAdapter;
    private ModContainer.Disableable disableability;
    private ListMultimap<Class<? extends FMLEvent>, Method> eventMethods;
    private Map<String, String> customModProperties;
    private ModCandidate candidate;
    private URL updateJSONUrl;
    private int classVersion;

    public FMLModContainer(String className, ModCandidate container, Map<String, Object> modDescriptor) {
        this.className = className;
        this.source = container.getModContainer();
        this.candidate = container;
        this.descriptor = modDescriptor;
        this.eventMethods = ArrayListMultimap.create();
        this.modLanguage = (String)modDescriptor.get("modLanguage");
        String languageAdapterType = (String)modDescriptor.get("modLanguageAdapter");
        if (Strings.isNullOrEmpty((String)languageAdapterType)) {
            this.languageAdapter = "scala".equals(this.modLanguage) ? new ILanguageAdapter.ScalaAdapter() : new ILanguageAdapter.JavaAdapter();
        } else {
            this.languageAdapter = null;
            FMLLog.log.trace("Using custom language adapter {} for {} (modid: {})", (Object)languageAdapterType, (Object)this.className, (Object)this.getModId());
        }
        this.sanityCheckModId();
    }

    private void sanityCheckModId() {
        String modid = (String)this.descriptor.get("modid");
        if (Strings.isNullOrEmpty((String)modid)) {
            throw new IllegalArgumentException("The modId is null or empty");
        }
        if (modid.length() > 64) {
            throw new IllegalArgumentException(String.format("The modId %s is longer than the maximum of 64 characters.", modid));
        }
        if (!modid.equals(modid.toLowerCase(Locale.ENGLISH))) {
            throw new IllegalArgumentException(String.format("The modId %s must be all lowercase.", modid));
        }
    }

    private ILanguageAdapter getLanguageAdapter() {
        if (this.languageAdapter == null) {
            try {
                this.languageAdapter = (ILanguageAdapter)Class.forName((String)this.descriptor.get("modLanguageAdapter"), true, Loader.instance().getModClassLoader()).newInstance();
            }
            catch (Exception ex2) {
                FMLLog.log.error("Error constructing custom mod language adapter referenced by {} (modid: {})", (Object)this.getModId(), (Object)ex2);
                throw new RuntimeException(ex2);
            }
        }
        return this.languageAdapter;
    }

    @Override
    public String getModId() {
        return (String)this.descriptor.get("modid");
    }

    @Override
    public String getName() {
        return this.modMetadata.name;
    }

    @Override
    public String getVersion() {
        return this.internalVersion;
    }

    @Override
    public File getSource() {
        return this.source;
    }

    @Override
    public ModMetadata getMetadata() {
        return this.modMetadata;
    }

    @Override
    public void bindMetadata(MetadataCollection mc) {
        String mcVersionString;
        Properties versionProps;
        this.modMetadata = mc.getMetadataForId(this.getModId(), this.descriptor);
        if (this.descriptor.containsKey("useMetadata")) {
            boolean bl = this.overridesMetadata = (Boolean)this.descriptor.get("useMetadata") == false;
        }
        if (this.overridesMetadata || !this.modMetadata.useDependencyInformation) {
            this.annotationDependencies = (String)this.descriptor.get("dependencies");
            DependencyParser dependencyParser = new DependencyParser(this.getModId(), FMLCommonHandler.instance().getSide());
            DependencyParser.DependencyInfo info = dependencyParser.parseDependencies(this.annotationDependencies);
            info.dependants.addAll(Loader.instance().getInjectedBefore(this.getModId()));
            info.dependencies.addAll(Loader.instance().getInjectedAfter(this.getModId()));
            this.modMetadata.requiredMods = info.requirements;
            this.modMetadata.dependencies = info.dependencies;
            this.modMetadata.dependants = info.dependants;
            FMLLog.log.trace("Parsed dependency info for {}: Requirements: {} After:{} Before:{}", (Object)this.getModId(), info.requirements, info.dependencies, info.dependants);
        } else {
            FMLLog.log.trace("Using mcmod dependency info for {}: {} {} {}", (Object)this.getModId(), this.modMetadata.requiredMods, this.modMetadata.dependencies, this.modMetadata.dependants);
        }
        if (Strings.isNullOrEmpty((String)this.modMetadata.name)) {
            FMLLog.log.info("Mod {} is missing the required element 'name'. Substituting {}", (Object)this.getModId(), (Object)this.getModId());
            this.modMetadata.name = this.getModId();
        }
        this.internalVersion = (String)this.descriptor.get("version");
        if (Strings.isNullOrEmpty((String)this.internalVersion) && (versionProps = this.searchForVersionProperties()) != null) {
            this.internalVersion = versionProps.getProperty(this.getModId() + ".version");
            FMLLog.log.debug("Found version {} for mod {} in version.properties, using", (Object)this.internalVersion, (Object)this.getModId());
        }
        if (Strings.isNullOrEmpty((String)this.internalVersion) && !Strings.isNullOrEmpty((String)this.modMetadata.version)) {
            FMLLog.log.warn("Mod {} is missing the required element 'version' and a version.properties file could not be found. Falling back to metadata version {}", (Object)this.getModId(), (Object)this.modMetadata.version);
            this.internalVersion = this.modMetadata.version;
        }
        if (Strings.isNullOrEmpty((String)this.internalVersion)) {
            FMLLog.log.warn("Mod {} is missing the required element 'version' and no fallback can be found. Substituting '1.0'.", (Object)this.getModId());
            this.internalVersion = "1.0";
            this.modMetadata.version = "1.0";
        }
        if ("[1.12]".equals(mcVersionString = (String)this.descriptor.get("acceptedMinecraftVersions"))) {
            mcVersionString = "[1.12,1.12.2]";
        }
        if ("[1.12.1]".equals(mcVersionString) || "[1.12,1.12.1]".equals(mcVersionString)) {
            mcVersionString = "[1.12,1.12.2]";
        }
        this.minecraftAccepted = !Strings.isNullOrEmpty((String)mcVersionString) ? VersionParser.parseRange(mcVersionString) : Loader.instance().getMinecraftModContainer().getStaticVersionRange();
        String jsonURL = (String)this.descriptor.get("updateJSON");
        if (!Strings.isNullOrEmpty((String)jsonURL)) {
            try {
                this.updateJSONUrl = new URL(jsonURL);
            }
            catch (MalformedURLException e) {
                FMLLog.log.debug("Specified json URL for mod '{}' is invalid: {}", (Object)this.getModId(), (Object)jsonURL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Properties searchForVersionProperties() {
        try {
            File propsFile;
            FMLLog.log.debug("Attempting to load the file version.properties from {} to locate a version number for mod {}", (Object)this.getSource().getName(), (Object)this.getModId());
            Properties version = null;
            if (this.getSource().isFile()) {
                ZipFile source = new ZipFile(this.getSource());
                ZipEntry versionFile = source.getEntry("version.properties");
                if (versionFile != null) {
                    version = new Properties();
                    InputStream sourceInputStream = source.getInputStream(versionFile);
                    try {
                        version.load(sourceInputStream);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)sourceInputStream);
                    }
                }
                source.close();
            } else if (this.getSource().isDirectory() && (propsFile = new File(this.getSource(), "version.properties")).exists() && propsFile.isFile()) {
                version = new Properties();
                try (FileInputStream fis = new FileInputStream(propsFile);){
                    version.load(fis);
                }
            }
            return version;
        }
        catch (IOException e) {
            FMLLog.log.trace("Failed to find a usable version.properties file for mod {}", (Object)this.getModId());
            return null;
        }
    }

    @Override
    public void setEnabledState(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public Set<ArtifactVersion> getRequirements() {
        return this.modMetadata.requiredMods;
    }

    @Override
    public List<ArtifactVersion> getDependencies() {
        return this.modMetadata.dependencies;
    }

    @Override
    public List<ArtifactVersion> getDependants() {
        return this.modMetadata.dependants;
    }

    @Override
    public String getSortingRules() {
        return this.overridesMetadata || !this.modMetadata.useDependencyInformation ? Strings.nullToEmpty((String)this.annotationDependencies) : this.modMetadata.printableSortingRules();
    }

    @Override
    public boolean matches(Object mod) {
        return mod == this.modInstance;
    }

    @Override
    public Object getMod() {
        return this.modInstance;
    }

    @Override
    public boolean registerBus(EventBus bus2, LoadController controller) {
        if (this.enabled) {
            FMLLog.log.debug("Enabling mod {}", (Object)this.getModId());
            this.eventBus = bus2;
            this.controller = controller;
            this.eventBus.register((Object)this);
            return true;
        }
        return false;
    }

    @Nullable
    private Method gatherAnnotations(Class<?> clazz) {
        Method factoryMethod = null;
        for (Method m : clazz.getDeclaredMethods()) {
            for (Annotation a2 : m.getAnnotations()) {
                if (a2.annotationType().equals(Mod.EventHandler.class)) {
                    if (m.getParameterTypes().length == 1 && FMLEvent.class.isAssignableFrom(m.getParameterTypes()[0])) {
                        m.setAccessible(true);
                        Class<?> parameterType = m.getParameterTypes()[0];
                        this.eventMethods.put(parameterType, (Object)m);
                        continue;
                    }
                    FMLLog.log.error("The mod {} appears to have an invalid event annotation {}. This annotation can only apply to methods with recognized event arguments - it will not be called", (Object)this.getModId(), (Object)a2.annotationType().getSimpleName());
                    continue;
                }
                if (!a2.annotationType().equals(Mod.InstanceFactory.class)) continue;
                if (Modifier.isStatic(m.getModifiers()) && m.getParameterTypes().length == 0 && factoryMethod == null) {
                    m.setAccessible(true);
                    factoryMethod = m;
                    continue;
                }
                if (!Modifier.isStatic(m.getModifiers()) || m.getParameterTypes().length != 0) {
                    FMLLog.log.error("The InstanceFactory annotation can only apply to a static method, taking zero arguments - it will be ignored on {}({}) for mod {}", (Object)m.getName(), Arrays.asList(m.getParameterTypes()), (Object)this.getModId());
                    continue;
                }
                if (factoryMethod == null) continue;
                FMLLog.log.error("The InstanceFactory annotation can only be used once, the application to {}({}) will be ignored for mod {}", (Object)m.getName(), Arrays.asList(m.getParameterTypes()), (Object)this.getModId());
            }
        }
        return factoryMethod;
    }

    private void processFieldAnnotations(ASMDataTable asmDataTable) throws IllegalAccessException {
        SetMultimap<String, ASMDataTable.ASMData> annotations = asmDataTable.getAnnotationsFor(this);
        this.parseSimpleFieldAnnotation(annotations, Mod.Instance.class.getName(), ModContainer::getMod);
        this.parseSimpleFieldAnnotation(annotations, Mod.Metadata.class.getName(), ModContainer::getMetadata);
    }

    private void parseSimpleFieldAnnotation(SetMultimap<String, ASMDataTable.ASMData> annotations, String annotationClassName, Function<ModContainer, Object> retriever) throws IllegalAccessException {
        Set mods = annotations.get((Object)Mod.class.getName());
        String[] annName = annotationClassName.split("\\.");
        String annotationName = annName[annName.length - 1];
        for (ASMDataTable.ASMData targets : annotations.get((Object)annotationClassName)) {
            String targetMod = (String)targets.getAnnotationInfo().get("value");
            String owner = (String)targets.getAnnotationInfo().get("owner");
            if (Strings.isNullOrEmpty((String)owner) && Strings.isNullOrEmpty((String)(owner = ASMDataTable.getOwnerModID(mods, targets)))) {
                FMLLog.bigWarning("Could not determine owning mod for @{} on {} for mod {}", annotationClassName, targets.getClassName(), this.getModId());
                continue;
            }
            if (!this.getModId().equals(owner)) {
                FMLLog.log.debug("Skipping @{} injection for {}.{} since it is not for mod {}", (Object)annotationClassName, (Object)targets.getClassName(), (Object)targets.getObjectName(), (Object)this.getModId());
                continue;
            }
            Field f = null;
            Object injectedMod = null;
            ModContainer mc = this;
            boolean isStatic = false;
            Class<?> clz = this.modInstance.getClass();
            if (!Strings.isNullOrEmpty((String)targetMod)) {
                mc = Loader.isModLoaded(targetMod) ? Loader.instance().getIndexedModList().get(targetMod) : null;
            }
            if (mc != null) {
                try {
                    clz = Class.forName(targets.getClassName(), true, Loader.instance().getModClassLoader());
                    f = clz.getDeclaredField(targets.getObjectName());
                    f.setAccessible(true);
                    isStatic = Modifier.isStatic(f.getModifiers());
                    injectedMod = retriever.apply(mc);
                }
                catch (ReflectiveOperationException e) {
                    FMLLog.log.warn("Attempting to load @{} in class {} for {} and failing", (Object)annotationName, (Object)targets.getClassName(), (Object)mc.getModId(), (Object)e);
                }
            }
            if (f == null) continue;
            Object target = null;
            if (!isStatic) {
                target = this.modInstance;
                if (!this.modInstance.getClass().equals(clz)) {
                    FMLLog.log.warn("Unable to inject @{} in non-static field {}.{} for {} as it is NOT the primary mod instance", (Object)annotationName, (Object)targets.getClassName(), (Object)targets.getObjectName(), (Object)mc.getModId());
                    continue;
                }
            }
            f.set(target, injectedMod);
        }
    }

    @Subscribe
    public void constructMod(FMLConstructionEvent event) {
        boolean hasReverseDepends;
        List props;
        Class<?> clazz;
        ModClassLoader modClassLoader = event.getModClassLoader();
        try {
            modClassLoader.addFile(this.source);
        }
        catch (MalformedURLException e) {
            FormattedMessage message = new FormattedMessage("{} Failed to add file to classloader: {}", (Object)this.getModId(), (Object)this.source);
            throw new LoaderException(message.getFormattedMessage(), e);
        }
        modClassLoader.clearNegativeCacheFor(this.candidate.getClassList());
        MinecraftForge.preloadCrashClasses(event.getASMHarvestedData(), this.getModId(), this.candidate.getClassList());
        try {
            clazz = Class.forName(this.className, true, modClassLoader);
        }
        catch (ClassNotFoundException e) {
            FormattedMessage message = new FormattedMessage("{} Failed load class: {}", (Object)this.getModId(), (Object)this.className);
            throw new LoaderException(message.getFormattedMessage(), e);
        }
        Certificate[] certificates = clazz.getProtectionDomain().getCodeSource().getCertificates();
        ImmutableList<String> certList = CertificateHelper.getFingerprints(certificates);
        this.sourceFingerprints = ImmutableSet.copyOf(certList);
        String expectedFingerprint = (String)this.descriptor.get("certificateFingerprint");
        this.fingerprintNotPresent = true;
        if (expectedFingerprint != null && !expectedFingerprint.isEmpty()) {
            if (!this.sourceFingerprints.contains(expectedFingerprint)) {
                Level warnLevel = this.source.isDirectory() ? Level.TRACE : Level.ERROR;
                FMLLog.log.log(warnLevel, "The mod {} is expecting signature {} for source {}, however there is no signature matching that description", (Object)this.getModId(), (Object)expectedFingerprint, (Object)this.source.getName());
            } else {
                this.certificate = certificates[certList.indexOf((Object)expectedFingerprint)];
                this.fingerprintNotPresent = false;
            }
        }
        if ((props = (List)this.descriptor.get("customProperties")) != null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map p2 : props) {
                builder.put(p2.get("k"), p2.get("v"));
            }
            this.customModProperties = builder.build();
        } else {
            this.customModProperties = EMPTY_PROPERTIES;
        }
        Boolean hasDisableableFlag = (Boolean)this.descriptor.get("canBeDeactivated");
        boolean bl = hasReverseDepends = !event.getReverseDependencies().get((Object)this.getModId()).isEmpty();
        this.disableability = hasDisableableFlag != null && hasDisableableFlag != false ? (hasReverseDepends ? ModContainer.Disableable.DEPENDENCIES : ModContainer.Disableable.YES) : (hasReverseDepends ? ModContainer.Disableable.DEPENDENCIES : ModContainer.Disableable.RESTART);
        Method factoryMethod = this.gatherAnnotations(clazz);
        ILanguageAdapter languageAdapter = this.getLanguageAdapter();
        try {
            this.modInstance = languageAdapter.getNewInstance(this, clazz, modClassLoader, factoryMethod);
        }
        catch (Exception e) {
            FormattedMessage message = new FormattedMessage("{} Failed to load new mod instance.", (Object)this.getModId());
            throw new LoaderException(message.getFormattedMessage(), e);
        }
        NetworkRegistry.INSTANCE.register(this, clazz, this.descriptor.getOrDefault("acceptableRemoteVersions", null), event.getASMHarvestedData());
        if (this.fingerprintNotPresent) {
            this.eventBus.post((Object)new FMLFingerprintViolationEvent(this.source.isDirectory(), this.source, (ImmutableSet<String>)ImmutableSet.copyOf(this.sourceFingerprints), expectedFingerprint));
        }
        ProxyInjector.inject(this, event.getASMHarvestedData(), FMLCommonHandler.instance().getSide(), languageAdapter);
        AutomaticEventSubscriber.inject(this, event.getASMHarvestedData(), FMLCommonHandler.instance().getSide());
        ConfigManager.sync(this.getModId(), Config.Type.INSTANCE);
        try {
            this.processFieldAnnotations(event.getASMHarvestedData());
        }
        catch (IllegalAccessException e) {
            FormattedMessage message = new FormattedMessage("{} Failed to process field annotations.", (Object)this.getModId());
            throw new LoaderException(message.getFormattedMessage(), e);
        }
    }

    @Subscribe
    public void handleModStateEvent(FMLEvent event) {
        if (!this.eventMethods.containsKey(event.getClass())) {
            return;
        }
        try {
            for (Method m : this.eventMethods.get(event.getClass())) {
                m.invoke(this.modInstance, event);
            }
        }
        catch (Throwable t) {
            this.controller.errorOccurred(this, t);
        }
    }

    @Override
    public ArtifactVersion getProcessedVersion() {
        if (this.processedVersion == null) {
            this.processedVersion = new DefaultArtifactVersion(this.getModId(), this.getVersion());
        }
        return this.processedVersion;
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public String getDisplayVersion() {
        return this.modMetadata.version;
    }

    @Override
    public VersionRange acceptableMinecraftVersionRange() {
        return this.minecraftAccepted;
    }

    @Override
    public Certificate getSigningCertificate() {
        return this.certificate;
    }

    public String toString() {
        return "FMLMod:" + this.getModId() + "{" + this.getVersion() + "}";
    }

    @Override
    public Map<String, String> getCustomModProperties() {
        return this.customModProperties;
    }

    @Override
    public Class<?> getCustomResourcePackClass() {
        try {
            return this.getSource().isDirectory() ? Class.forName("net.minecraftforge.fml.client.FMLFolderResourcePack", true, this.getClass().getClassLoader()) : Class.forName("net.minecraftforge.fml.client.FMLFileResourcePack", true, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public Map<String, String> getSharedModDescriptor() {
        HashMap descriptor = Maps.newHashMap();
        descriptor.put("modsystem", "FML");
        descriptor.put("id", this.getModId());
        descriptor.put("version", this.getDisplayVersion());
        descriptor.put("name", this.getName());
        descriptor.put("url", this.modMetadata.url);
        descriptor.put("authors", this.modMetadata.getAuthorList());
        descriptor.put("description", this.modMetadata.description);
        return descriptor;
    }

    @Override
    public ModContainer.Disableable canBeDisabled() {
        return this.disableability;
    }

    @Override
    public String getGuiClassName() {
        return (String)this.descriptor.get("guiFactory");
    }

    @Override
    public List<String> getOwnedPackages() {
        return this.candidate.getContainedPackages();
    }

    private boolean isTrue(Boolean value) {
        if (value == null) {
            return false;
        }
        return value;
    }

    @Override
    public boolean shouldLoadInEnvironment() {
        boolean clientSideOnly = this.isTrue((Boolean)this.descriptor.get("clientSideOnly"));
        boolean serverSideOnly = this.isTrue((Boolean)this.descriptor.get("serverSideOnly"));
        if (clientSideOnly && serverSideOnly) {
            throw new RuntimeException("Mod annotation claims to be both client and server side only!");
        }
        Side side = FMLCommonHandler.instance().getSide();
        if (clientSideOnly && side != Side.CLIENT) {
            FMLLog.log.info("Disabling mod {} it is client side only.", (Object)this.getModId());
            return false;
        }
        if (serverSideOnly && side != Side.SERVER) {
            FMLLog.log.info("Disabling mod {} it is server side only.", (Object)this.getModId());
            return false;
        }
        return true;
    }

    @Override
    public URL getUpdateUrl() {
        return this.updateJSONUrl;
    }

    @Override
    public void setClassVersion(int classVersion) {
        this.classVersion = classVersion;
    }

    @Override
    public int getClassVersion() {
        return this.classVersion;
    }
}

