/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.config;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.FieldWrapper;
import net.minecraftforge.common.config.IFieldWrapper;
import net.minecraftforge.common.config.ITypeAdapter;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.common.config.TypeAdapters;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.ModClassLoader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.asm.ModAnnotation;
import org.apache.commons.lang3.StringUtils;

public class ConfigManager {
    private static Map<String, Multimap<Config.Type, ASMDataTable.ASMData>> asm_data = Maps.newHashMap();
    static Map<Class<?>, ITypeAdapter> ADAPTERS = Maps.newHashMap();
    static Map<Class<?>, Class<?>> ARRAY_REMAP = Maps.newHashMap();
    private static Map<String, Configuration> CONFIGS = Maps.newHashMap();
    private static Map<String, Set<Class<?>>> MOD_CONFIG_CLASSES = Maps.newHashMap();
    static final Joiner NEW_LINE;
    static final Joiner PIPE;

    private static void register(Class<?> cls, ITypeAdapter adpt) {
        ADAPTERS.put(cls, adpt);
    }

    public static void loadData(ASMDataTable data) {
        FMLLog.log.debug("Loading @Config anotation data");
        for (ASMDataTable.ASMData target : data.getAll(Config.class.getName())) {
            String modid = (String)target.getAnnotationInfo().get("modid");
            Multimap map = asm_data.computeIfAbsent(modid, k -> ArrayListMultimap.create());
            ModAnnotation.EnumHolder tholder = (ModAnnotation.EnumHolder)target.getAnnotationInfo().get("type");
            Config.Type type = tholder == null ? Config.Type.INSTANCE : Config.Type.valueOf(tholder.getValue());
            map.put((Object)type, (Object)target);
        }
    }

    public static void load(String modid, Config.Type type) {
        ConfigManager.sync(modid, type);
    }

    public static void sync(String modid, Config.Type type) {
        FMLLog.log.debug("Attempting to inject @Config classes into {} for type {}", (Object)modid, (Object)type);
        ModClassLoader mcl = Loader.instance().getModClassLoader();
        File configDir = Loader.instance().getConfigDir();
        Multimap<Config.Type, ASMDataTable.ASMData> map = asm_data.get(modid);
        if (map == null) {
            return;
        }
        for (ASMDataTable.ASMData targ : map.get((Object)type)) {
            try {
                String category;
                Class<?> cls = Class.forName(targ.getClassName(), true, mcl);
                Set modConfigClasses = MOD_CONFIG_CLASSES.computeIfAbsent(modid, k -> Sets.newHashSet());
                modConfigClasses.add(cls);
                String name = (String)targ.getAnnotationInfo().get("name");
                if (name == null) {
                    name = modid;
                }
                if ((category = (String)targ.getAnnotationInfo().get("category")) == null) {
                    category = "general";
                }
                File file = new File(configDir, name + ".cfg");
                boolean loading = false;
                Configuration cfg2 = CONFIGS.get(file.getAbsolutePath());
                if (cfg2 == null) {
                    cfg2 = new Configuration(file);
                    cfg2.load();
                    CONFIGS.put(file.getAbsolutePath(), cfg2);
                    loading = true;
                }
                ConfigManager.sync(cfg2, cls, modid, category, loading, null);
                cfg2.save();
            }
            catch (Exception e) {
                FMLLog.log.error("An error occurred trying to load a config for {} into {}", (Object)targ.getClassName(), (Object)e);
                throw new LoaderException(e);
            }
        }
    }

    public static Class<?>[] getModConfigClasses(String modid) {
        return MOD_CONFIG_CLASSES.containsKey(modid) ? MOD_CONFIG_CLASSES.get(modid).toArray(new Class[0]) : new Class[]{};
    }

    public static boolean hasConfigForMod(String modid) {
        return asm_data.containsKey(modid);
    }

    static Configuration getConfiguration(String modid, String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            name = modid;
        }
        File configDir = Loader.instance().getConfigDir();
        File configFile = new File(configDir, name + ".cfg");
        return CONFIGS.get(configFile.getAbsolutePath());
    }

    private static void sync(Configuration cfg2, Class<?> cls, String modid, String category, boolean loading, Object instance) {
        for (Field f : cls.getDeclaredFields()) {
            if (!Modifier.isPublic(f.getModifiers()) || Modifier.isStatic(f.getModifiers()) != (instance == null) || f.isAnnotationPresent(Config.Ignore.class)) continue;
            String comment = null;
            Config.Comment ca = f.getAnnotation(Config.Comment.class);
            if (ca != null) {
                comment = NEW_LINE.join((Object[])ca.value());
            }
            String langKey = modid + "." + (category.isEmpty() ? "" : category + ".") + f.getName().toLowerCase(Locale.ENGLISH);
            Config.LangKey la = f.getAnnotation(Config.LangKey.class);
            if (la != null) {
                langKey = la.value();
            }
            boolean requiresMcRestart = f.isAnnotationPresent(Config.RequiresMcRestart.class);
            boolean requiresWorldRestart = f.isAnnotationPresent(Config.RequiresWorldRestart.class);
            if (FieldWrapper.hasWrapperFor(f)) {
                if (Strings.isNullOrEmpty((String)category)) {
                    throw new RuntimeException("An empty category may not contain anything but objects representing categories!");
                }
                try {
                    IFieldWrapper wrapper = FieldWrapper.get(instance, f, category);
                    ITypeAdapter adapt = wrapper.getTypeAdapter();
                    Property.Type propType = adapt.getType();
                    for (String key : wrapper.getKeys()) {
                        Object mapVal;
                        Object propVal;
                        Property property;
                        String suffix = StringUtils.replaceOnce((String)key, (String)(wrapper.getCategory() + "."), (String)"");
                        boolean existed = ConfigManager.exists(cfg2, wrapper.getCategory(), suffix);
                        if (!existed || loading) {
                            property = ConfigManager.property(cfg2, wrapper.getCategory(), suffix, propType, adapt.isArrayAdapter());
                            adapt.setDefaultValue(property, wrapper.getValue(key));
                            if (!existed) {
                                adapt.setValue(property, wrapper.getValue(key));
                                continue;
                            }
                            wrapper.setValue(key, adapt.getValue(property));
                            continue;
                        }
                        property = ConfigManager.property(cfg2, wrapper.getCategory(), suffix, propType, adapt.isArrayAdapter());
                        if (ConfigManager.shouldReadFromVar(property, propVal = adapt.getValue(property), mapVal = wrapper.getValue(key))) {
                            adapt.setValue(property, mapVal);
                            continue;
                        }
                        wrapper.setValue(key, propVal);
                    }
                    ConfigCategory confCat = cfg2.getCategory(wrapper.getCategory());
                    for (Property property : confCat.getOrderedValues()) {
                        String key;
                        key = confCat.getQualifiedName() + "." + property.getName();
                        if (!wrapper.handlesKey(key) || !loading && wrapper.hasKey(key)) continue;
                        Object value = wrapper.getTypeAdapter().getValue(property);
                        wrapper.setValue(key, value);
                    }
                    if (!loading) continue;
                    wrapper.setupConfiguration(cfg2, comment, langKey, requiresMcRestart, requiresWorldRestart);
                    continue;
                }
                catch (Exception e) {
                    String format = "Error syncing field '%s' of class '%s'!";
                    String error = String.format(format, f.getName(), cls.getName());
                    throw new RuntimeException(error, e);
                }
            }
            if (f.getType().getSuperclass() != null && f.getType().getSuperclass().equals(Object.class)) {
                Object newInstance = null;
                try {
                    newInstance = f.get(instance);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                String sub = (category.isEmpty() ? "" : category + ".") + ConfigManager.getName(f).toLowerCase(Locale.ENGLISH);
                ConfigCategory confCat = cfg2.getCategory(sub);
                confCat.setComment(comment);
                confCat.setLanguageKey(langKey);
                confCat.setRequiresMcRestart(requiresMcRestart);
                confCat.setRequiresWorldRestart(requiresWorldRestart);
                ConfigManager.sync(cfg2, f.getType(), modid, sub, loading, newInstance);
                continue;
            }
            String format = "Can't handle field '%s' of class '%s': Unknown type.";
            String error = String.format(format, f.getName(), cls.getCanonicalName());
            throw new RuntimeException(error);
        }
    }

    private static Property property(Configuration cfg2, String category, String property, Property.Type type, boolean isList) {
        Property prop = cfg2.getCategory(category).get(property);
        if (prop == null) {
            prop = isList ? new Property(property, new String[0], type) : new Property(property, (String)null, type);
            cfg2.getCategory(category).put(property, prop);
        }
        return prop;
    }

    private static boolean exists(Configuration cfg2, String category, String property) {
        return cfg2.hasCategory(category) && cfg2.getCategory(category).containsKey(property);
    }

    private static boolean shouldReadFromVar(Property property, Object propValue, Object fieldValue) {
        if (!propValue.equals(fieldValue)) {
            return !property.hasChanged();
        }
        return false;
    }

    private static String getName(Field f) {
        if (f.isAnnotationPresent(Config.Name.class)) {
            return f.getAnnotation(Config.Name.class).value();
        }
        return f.getName();
    }

    static {
        ConfigManager.register(Boolean.TYPE, TypeAdapters.bool);
        ConfigManager.register(boolean[].class, TypeAdapters.boolA);
        ConfigManager.register(Boolean.class, TypeAdapters.Bool);
        ConfigManager.register(Boolean[].class, TypeAdapters.BoolA);
        ConfigManager.register(Float.TYPE, TypeAdapters.flt);
        ConfigManager.register(float[].class, TypeAdapters.fltA);
        ConfigManager.register(Float.class, TypeAdapters.Flt);
        ConfigManager.register(Float[].class, TypeAdapters.FltA);
        ConfigManager.register(Double.TYPE, TypeAdapters.dbl);
        ConfigManager.register(double[].class, TypeAdapters.dblA);
        ConfigManager.register(Double.class, TypeAdapters.Dbl);
        ConfigManager.register(Double[].class, TypeAdapters.DblA);
        ConfigManager.register(Byte.TYPE, TypeAdapters.byt);
        ConfigManager.register(byte[].class, TypeAdapters.bytA);
        ConfigManager.register(Byte.class, TypeAdapters.Byt);
        ConfigManager.register(Byte[].class, TypeAdapters.BytA);
        ConfigManager.register(Character.TYPE, TypeAdapters.chr);
        ConfigManager.register(char[].class, TypeAdapters.chrA);
        ConfigManager.register(Character.class, TypeAdapters.Chr);
        ConfigManager.register(Character[].class, TypeAdapters.ChrA);
        ConfigManager.register(Short.TYPE, TypeAdapters.shrt);
        ConfigManager.register(short[].class, TypeAdapters.shrtA);
        ConfigManager.register(Short.class, TypeAdapters.Shrt);
        ConfigManager.register(Short[].class, TypeAdapters.ShrtA);
        ConfigManager.register(Integer.TYPE, TypeAdapters.int_);
        ConfigManager.register(int[].class, TypeAdapters.intA);
        ConfigManager.register(Integer.class, TypeAdapters.Int);
        ConfigManager.register(Integer[].class, TypeAdapters.IntA);
        ConfigManager.register(String.class, TypeAdapters.Str);
        ConfigManager.register(String[].class, TypeAdapters.StrA);
        ARRAY_REMAP.put(Boolean.class, Boolean[].class);
        ARRAY_REMAP.put(Float.class, Float[].class);
        ARRAY_REMAP.put(Double.class, Double[].class);
        ARRAY_REMAP.put(Byte.class, Byte[].class);
        ARRAY_REMAP.put(Character.class, Character[].class);
        ARRAY_REMAP.put(Short.class, Short[].class);
        ARRAY_REMAP.put(Integer.class, Integer[].class);
        ARRAY_REMAP.put(String.class, String[].class);
        NEW_LINE = Joiner.on((char)'\n');
        PIPE = Joiner.on((char)'|');
    }
}

