/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.config;

import com.google.common.collect.Maps;
import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.config.PlayerConfigSetting;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;

public class ConfigManager {
    public static final Map<UUID, Map<String, PlayerConfigSetting<?>>> serverPlayerConfigSettings = Maps.newHashMap();
    private static final String LANG_PREFIX = "storagedrawers.config.";
    private final Configuration config;
    public final ConfigCache cache;
    public final List<ConfigSection> sections = new ArrayList<ConfigSection>();
    public final ConfigSection sectionGeneral = new ConfigSection(this.sections, "general", "general");
    public final ConfigSection sectionIntegration = new ConfigSection(this.sections, "integration", "integration");
    public final ConfigSection sectionBlocks = new ConfigSection(this.sections, "blocks", "blocks");
    public final ConfigSection sectionUpgrades = new ConfigSection(this.sections, "upgrades", "upgrades");
    public final ConfigSection sectionRegistries = new ConfigSection(this.sections, "registries", "registries");
    public final List<ConfigSection> blockSections = new ArrayList<ConfigSection>();
    public final ConfigSection sectionBlocksFullDrawers1x1 = new ConfigSection(this.blockSections, this.sectionBlocks, "fulldrawers1", "blocks.fullDrawers1");
    public final ConfigSection sectionBlocksFullDrawers1x2 = new ConfigSection(this.blockSections, this.sectionBlocks, "fulldrawers2", "blocks.fullDrawers2");
    public final ConfigSection sectionBlocksFullDrawers2x2 = new ConfigSection(this.blockSections, this.sectionBlocks, "fulldrawers4", "blocks.fullDrawers4");
    public final ConfigSection sectionBlocksHalfDrawers1x2 = new ConfigSection(this.blockSections, this.sectionBlocks, "halfdrawers2", "blocks.halfDrawers2");
    public final ConfigSection sectionBlocksHalfDrawers2x2 = new ConfigSection(this.blockSections, this.sectionBlocks, "halfdrawers4", "blocks.halfDrawers4");
    public final ConfigSection sectionBlocksCompDrawers = new ConfigSection(this.blockSections, this.sectionBlocks, "compdrawers", "blocks.compDrawers");
    public final ConfigSection sectionBlocksController = new ConfigSection(this.blockSections, this.sectionBlocks, "controller", "blocks.controller");
    public final ConfigSection sectionBlocksTrim = new ConfigSection(this.blockSections, this.sectionBlocks, "trim", "blocks.trim");
    public final ConfigSection sectionBlocksSlave = new ConfigSection(this.blockSections, this.sectionBlocks, "controllerslave", "blocks.controllerSlave");
    public Map<String, ConfigSection> blockSectionsMap = new HashMap<String, ConfigSection>();

    public ConfigManager(File file) {
        this.config = new Configuration(file);
        this.cache = new ConfigCache();
        for (ConfigSection section : this.sections) {
            section.getCategory();
        }
        for (ConfigSection section : this.blockSections) {
            section.getCategory();
            this.blockSectionsMap.put(section.name, section);
        }
        this.syncConfig();
    }

    public void syncConfig() {
        this.cache.enableIndicatorUpgrades = this.config.get("general", "enableIndicatorUpgrades", true).setLanguageKey("storagedrawers.config.prop.enableIndicatorUpgrades").setRequiresMcRestart(true).getBoolean();
        this.cache.enableStorageUpgrades = this.config.get("general", "enableStorageUpgrades", true).setLanguageKey("storagedrawers.config.prop.enableStorageUpgrades").setRequiresMcRestart(true).getBoolean();
        this.cache.enableLockUpgrades = this.config.get("general", "enableLockUpgrades", true).setLanguageKey("storagedrawers.config.prop.enableLockUpgrades").setRequiresMcRestart(true).getBoolean();
        this.cache.enableVoidUpgrades = this.config.get("general", "enableVoidUpgrades", true).setLanguageKey("storagedrawers.config.prop.enableVoidUpgrades").setRequiresMcRestart(true).getBoolean();
        this.cache.enableCreativeUpgrades = this.config.get("general", "enableCreativeUpgrades", true).setLanguageKey("storagedrawers.config.prop.enableCreativeUpgrades").setRequiresMcRestart(true).getBoolean();
        this.cache.enableShroudUpgrades = this.config.get("general", "enableShroudUpgrades", true).setLanguageKey("storagedrawers.config.prop.enableShroudUpgrades").setRequiresMcRestart(true).getBoolean();
        this.cache.enableQuantifiableUpgrades = this.config.get("general", "enableQuantifiableUpgrades", true).setLanguageKey("storagedrawers.config.prop.enableQuantifiableUpgrades").setRequiresMcRestart(true).getBoolean();
        this.cache.enablePersonalUpgrades = this.config.get("general", "enablePersonalUpgrades", true).setLanguageKey("storagedrawers.config.prop.enablePersonalUpgrades").setRequiresMcRestart(true).getBoolean();
        this.cache.enableRedstoneUpgrades = this.config.get("general", "enableRedstoneUpgrades", true).setLanguageKey("storagedrawers.config.prop.enableRedstoneUpgrades").setRequiresMcRestart(true).getBoolean();
        this.cache.enableTape = this.config.get("general", "enableTape", true).setLanguageKey("storagedrawers.config.prop.enableTape").setRequiresMcRestart(true).getBoolean();
        this.cache.creativeTabVanillaWoods = this.config.get("general", "creativeTabVanillaWoods", true).setLanguageKey("storagedrawers.config.prop.creativeTabVanillaWoods").getBoolean();
        this.cache.enableDrawerUI = this.config.get("general", "enableDrawerUI", true).setLanguageKey("storagedrawers.config.prop.enableDrawerUI").getBoolean();
        this.cache.enableSidedInput = this.config.get("general", "enableSidedInput", true).setLanguageKey("storagedrawers.config.prop.enableSidedInput").getBoolean();
        this.cache.enableSidedOutput = this.config.get("general", "enableSidedOutput", true).setLanguageKey("storagedrawers.config.prop.enableSidedOutput").getBoolean();
        this.cache.enableItemConversion = this.config.get("general", "enableItemConversion", true).setLanguageKey("storagedrawers.config.prop.enableItemConversion").getBoolean();
        this.cache.enableFallbackRecipes = this.config.get("general", "enableFallbackRecipes", true).setLanguageKey("storagedrawers.config.prop.enableFallbackRecipes").setRequiresMcRestart(true).getBoolean();
        this.cache.enableFramedDrawers = this.config.get("general", "enableFramedDrawers", true).setLanguageKey("storagedrawers.config.prop.enableFramedDrawers").setRequiresMcRestart(true).getBoolean();
        this.cache.stackRemainderWaila = !this.config.get("general", "wailaStackRemainder", "stack + remainder", null, new String[]{"exact", "stack + remainder"}).setLanguageKey("storagedrawers.config.prop.wailaStackRemainder").getString().equals("exact");
        this.cache.invertShift = this.config.get("general", "invertShift", false, "Inverts how shift works with drawers. If this is true, shifting will only give one item, where regular clicks will give a full stack. Leave false for default behavior.").setLanguageKey("storagedrawers.config.prop.invertShift").getBoolean();
        this.cache.debugTrace = this.config.get("general", "enableDebugLogging", false, "Writes additional log messages while using the mod.  Mainly for debug purposes.  Should be kept disabled unless instructed otherwise.").setLanguageKey("storagedrawers.config.prop.enableDebugLogging").getBoolean();
        this.cache.defaultQuantify = this.config.get("general", "defaultQuantify", false).setLanguageKey("storagedrawers.config.prop.defaultQuantify").getBoolean();
        this.cache.enableWailaIntegration = this.config.get(this.sectionIntegration.getQualifiedName(), "enableWaila", true).setLanguageKey("storagedrawers.config.integration.enableWaila").setRequiresMcRestart(true).getBoolean();
        this.cache.enableMineTweakerIntegration = this.config.get(this.sectionIntegration.getQualifiedName(), "enableMineTweaker", true).setLanguageKey("storagedrawers.config.integration.enableMineTweaker").setRequiresMcRestart(true).getBoolean();
        this.cache.compRules = this.config.getStringList("compactingRules", this.sectionRegistries.getQualifiedName(), new String[]{"minecraft:clay, minecraft:clay_ball, 4"}, "Items should be in form domain:item or domain:item:meta.", null, "storagedrawers.config.registries.compRules");
        if (StorageDrawers.compRegistry != null) {
            for (String rule : this.cache.compRules) {
                StorageDrawers.compRegistry.register(rule);
            }
        }
        this.cache.oreBlacklist = this.config.getStringList("oreBlacklist", this.sectionRegistries.getQualifiedName(), new String[0], "List of ore dictionary names to blacklist for substitution.", null, "storagedrawers.config.registries.oreBlacklist");
        if (StorageDrawers.oreDictRegistry != null) {
            for (String item : this.cache.oreBlacklist) {
                StorageDrawers.oreDictRegistry.removeWhitelist(item);
                StorageDrawers.oreDictRegistry.addBlacklist(item);
            }
        }
        this.cache.oreWhitelist = this.config.getStringList("oreWhitelist", this.sectionRegistries.getQualifiedName(), new String[0], "List of ore dictionary names to whitelist for substitution.", null, "storagedrawers.config.registries.oreWhitelist");
        if (StorageDrawers.oreDictRegistry != null) {
            for (String item : this.cache.oreWhitelist) {
                StorageDrawers.oreDictRegistry.removeBlacklist(item);
                StorageDrawers.oreDictRegistry.addWhitelist(item);
            }
        }
        this.cache.registerExtraCompRules = this.config.get(this.sectionRegistries.getQualifiedName(), "registerExtraCompactingRules", true).setLanguageKey("storagedrawers.config.registries.registerExtraCompRules").setRequiresWorldRestart(true).getBoolean();
        this.config.get(this.sectionBlocksFullDrawers1x1.getQualifiedName(), "enabled", true).setLanguageKey("storagedrawers.config.prop.enabled").setRequiresMcRestart(true);
        this.config.get(this.sectionBlocksFullDrawers1x1.getQualifiedName(), "baseStorage", 32).setLanguageKey("storagedrawers.config.prop.baseStorage").setRequiresWorldRestart(true);
        this.config.get(this.sectionBlocksFullDrawers1x1.getQualifiedName(), "recipeOutput", 1).setLanguageKey("storagedrawers.config.prop.recipeOutput").setRequiresMcRestart(true);
        this.config.get(this.sectionBlocksFullDrawers1x2.getQualifiedName(), "enabled", true).setLanguageKey("storagedrawers.config.prop.enabled").setRequiresMcRestart(true);
        this.config.get(this.sectionBlocksFullDrawers1x2.getQualifiedName(), "baseStorage", 16).setLanguageKey("storagedrawers.config.prop.baseStorage").setRequiresWorldRestart(true);
        this.config.get(this.sectionBlocksFullDrawers1x2.getQualifiedName(), "recipeOutput", 2).setLanguageKey("storagedrawers.config.prop.recipeOutput").setRequiresMcRestart(true);
        this.config.get(this.sectionBlocksFullDrawers2x2.getQualifiedName(), "enabled", true).setLanguageKey("storagedrawers.config.prop.enabled").setRequiresMcRestart(true);
        this.config.get(this.sectionBlocksFullDrawers2x2.getQualifiedName(), "baseStorage", 8).setLanguageKey("storagedrawers.config.prop.baseStorage").setRequiresWorldRestart(true);
        this.config.get(this.sectionBlocksFullDrawers2x2.getQualifiedName(), "recipeOutput", 4).setLanguageKey("storagedrawers.config.prop.recipeOutput").setRequiresMcRestart(true);
        this.config.get(this.sectionBlocksHalfDrawers1x2.getQualifiedName(), "enabled", true).setLanguageKey("storagedrawers.config.prop.enabled").setRequiresMcRestart(true);
        this.config.get(this.sectionBlocksHalfDrawers1x2.getQualifiedName(), "baseStorage", 8).setLanguageKey("storagedrawers.config.prop.baseStorage").setRequiresWorldRestart(true);
        this.config.get(this.sectionBlocksHalfDrawers1x2.getQualifiedName(), "recipeOutput", 2).setLanguageKey("storagedrawers.config.prop.recipeOutput").setRequiresMcRestart(true);
        this.config.get(this.sectionBlocksHalfDrawers2x2.getQualifiedName(), "enabled", true).setLanguageKey("storagedrawers.config.prop.enabled").setRequiresMcRestart(true);
        this.config.get(this.sectionBlocksHalfDrawers2x2.getQualifiedName(), "baseStorage", 4).setLanguageKey("storagedrawers.config.prop.baseStorage").setRequiresWorldRestart(true);
        this.config.get(this.sectionBlocksHalfDrawers2x2.getQualifiedName(), "recipeOutput", 4).setLanguageKey("storagedrawers.config.prop.recipeOutput").setRequiresMcRestart(true);
        this.config.get(this.sectionBlocksCompDrawers.getQualifiedName(), "enabled", true).setLanguageKey("storagedrawers.config.prop.enabled").setRequiresMcRestart(true);
        this.config.get(this.sectionBlocksCompDrawers.getQualifiedName(), "baseStorage", 16).setLanguageKey("storagedrawers.config.prop.baseStorage").setRequiresWorldRestart(true);
        this.config.get(this.sectionBlocksCompDrawers.getQualifiedName(), "recipeOutput", 1).setLanguageKey("storagedrawers.config.prop.recipeOutput").setRequiresMcRestart(true);
        this.config.get(this.sectionBlocksController.getQualifiedName(), "enabled", true).setLanguageKey("storagedrawers.config.prop.enabled").setRequiresMcRestart(true);
        this.config.get(this.sectionBlocksController.getQualifiedName(), "range", 12).setLanguageKey("storagedrawers.config.prop.controllerRange");
        this.config.get(this.sectionBlocksTrim.getQualifiedName(), "enabled", true).setLanguageKey("storagedrawers.config.prop.enabled").setRequiresMcRestart(true);
        this.config.get(this.sectionBlocksTrim.getQualifiedName(), "recipeOutput", 4).setLanguageKey("storagedrawers.config.prop.recipeOutput").setRequiresMcRestart(true);
        this.config.get(this.sectionBlocksSlave.getQualifiedName(), "enabled", true).setLanguageKey("storagedrawers.config.prop.enabled").setRequiresMcRestart(true);
        this.cache.level2Mult = this.config.get(this.sectionUpgrades.getQualifiedName(), "level2Mult", 2).setLanguageKey("storagedrawers.config.upgrades.level2Mult").setRequiresWorldRestart(true).getInt();
        this.cache.level3Mult = this.config.get(this.sectionUpgrades.getQualifiedName(), "level3Mult", 4).setLanguageKey("storagedrawers.config.upgrades.level3Mult").setRequiresWorldRestart(true).getInt();
        this.cache.level4Mult = this.config.get(this.sectionUpgrades.getQualifiedName(), "level4Mult", 8).setLanguageKey("storagedrawers.config.upgrades.level4Mult").setRequiresWorldRestart(true).getInt();
        this.cache.level5Mult = this.config.get(this.sectionUpgrades.getQualifiedName(), "level5Mult", 16).setLanguageKey("storagedrawers.config.upgrades.level5Mult").setRequiresWorldRestart(true).getInt();
        this.cache.level6Mult = this.config.get(this.sectionUpgrades.getQualifiedName(), "level6Mult", 32).setLanguageKey("storagedrawers.config.upgrades.level6Mult").setRequiresWorldRestart(true).getInt();
        this.getControllerRange();
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public String getPath() {
        return this.config.toString();
    }

    public boolean isBlockEnabled(String blockName) {
        if (!this.blockSectionsMap.containsKey(blockName = blockName.toLowerCase())) {
            return false;
        }
        ConfigSection section = this.blockSectionsMap.get(blockName);
        return section.getCategory().get("enabled").getBoolean();
    }

    public int getBlockBaseStorage(String blockName) {
        if (!this.blockSectionsMap.containsKey(blockName)) {
            return 0;
        }
        ConfigSection section = this.blockSectionsMap.get(blockName);
        return section.getCategory().get("baseStorage").getInt();
    }

    public int getBlockRecipeOutput(String blockName) {
        if (!this.blockSectionsMap.containsKey(blockName)) {
            return 0;
        }
        ConfigSection section = this.blockSectionsMap.get(blockName);
        return section.getCategory().get("recipeOutput").getInt();
    }

    public int getControllerRange() {
        ConfigSection section = this.blockSectionsMap.get("controller");
        return section.getCategory().get("range").getInt();
    }

    public int getStorageUpgradeMultiplier(int level) {
        switch (level) {
            case 2: {
                return this.cache.level2Mult;
            }
            case 3: {
                return this.cache.level3Mult;
            }
            case 4: {
                return this.cache.level4Mult;
            }
            case 5: {
                return this.cache.level5Mult;
            }
            case 6: {
                return this.cache.level6Mult;
            }
        }
        return 1;
    }

    public class ConfigCache {
        public boolean enableIndicatorUpgrades;
        public boolean enableStorageUpgrades;
        public boolean enableLockUpgrades;
        public boolean enableVoidUpgrades;
        public boolean enableCreativeUpgrades;
        public boolean enableShroudUpgrades;
        public boolean enableQuantifiableUpgrades;
        public boolean enablePersonalUpgrades;
        public boolean enableRedstoneUpgrades;
        public boolean renderStorageUpgrades;
        public boolean enableDrawerUI;
        public boolean creativeTabVanillaWoods;
        public boolean enableSidedInput;
        public boolean enableSidedOutput;
        public boolean enableItemConversion;
        public boolean enableWailaIntegration;
        public boolean enableMineTweakerIntegration;
        public boolean enableTape;
        public boolean enableFallbackRecipes;
        public boolean enableFramedDrawers;
        public boolean invertShift;
        public boolean debugTrace;
        public boolean stackRemainderWaila;
        public boolean registerExtraCompRules;
        public boolean defaultQuantify;
        public String[] compRules;
        public String[] oreWhitelist;
        public String[] oreBlacklist;
        public int level2Mult;
        public int level3Mult;
        public int level4Mult;
        public int level5Mult;
        public int level6Mult;
    }

    public class ConfigSection {
        public final ConfigSection parent;
        public final String name;
        public final String lang;
        private ConfigCategory category;

        public ConfigSection(List<ConfigSection> list, ConfigSection parent, String name, String lang) {
            this.parent = parent;
            this.name = name;
            this.lang = lang;
            list.add(this);
        }

        public ConfigSection(List<ConfigSection> list, String name, String lang) {
            this(list, null, name, lang);
        }

        public ConfigCategory getCategory() {
            if (this.category != null) {
                return this.category;
            }
            this.category = this.parent != null ? ConfigManager.this.config.getCategory(this.parent.getCategory().getQualifiedName() + "." + this.name.toLowerCase()) : ConfigManager.this.config.getCategory(this.name.toLowerCase());
            this.category.setLanguageKey(ConfigManager.LANG_PREFIX + this.lang);
            return this.category;
        }

        public String getQualifiedName() {
            return this.getCategory().getQualifiedName();
        }
    }
}

