/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.powertools.machine.gauge;

import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.powertools.machine.gauge.TileGauge;
import io.netty.buffer.ByteBuf;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketGaugeEnergyResponse
extends MessageTileEntity<TileGauge> {
    Map<EnumFacing, Float> data;

    public PacketGaugeEnergyResponse() {
    }

    public PacketGaugeEnergyResponse(@Nonnull TileGauge gauge) {
        super((TileEntity)gauge);
        gauge.collectData();
        this.data = gauge.data;
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        if (this.data != null) {
            for (Map.Entry<EnumFacing, Float> entry : this.data.entrySet()) {
                EnumFacing face = entry.getKey();
                Float value = entry.getValue();
                if (face == null || value == null) continue;
                buf.writeByte(face.ordinal());
                buf.writeFloat(value.floatValue());
            }
            buf.writeByte(42);
        } else {
            buf.writeByte(87);
        }
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.data = new EnumMap<EnumFacing, Float>(EnumFacing.class);
        while (true) {
            byte b;
            if ((b = buf.readByte()) > 5) {
                if (b == 87) {
                    this.data = null;
                }
                return;
            }
            EnumFacing face = EnumFacing.values()[b];
            float value = buf.readFloat();
            this.data.put(face, Float.valueOf(value));
        }
    }

    public static class Handler
    implements IMessageHandler<PacketGaugeEnergyResponse, IMessage> {
        public IMessage onMessage(PacketGaugeEnergyResponse message, MessageContext ctx) {
            TileGauge gauge = (TileGauge)message.getTileEntity(message.getWorld(ctx));
            if (gauge != null) {
                gauge.data = message.data;
            }
            return null;
        }
    }
}

