/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.reservoir;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.fluid.SmartTank;
import com.enderio.core.common.util.NNList;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

class ReservoirTankWrapper
implements ITankAccess {
    @Nonnull
    private final ITankAccess owner;
    @Nonnull
    private final NNList<ITankAccess> parents = new NNList();
    private SmartTank tank;
    @Nonnull
    private final World world;
    @Nonnull
    private final BlockPos pos;
    private final boolean allowFluidVoiding;

    ReservoirTankWrapper(@Nonnull ITankAccess parent, @Nonnull World world, @Nonnull BlockPos pos, boolean allowFluidVoiding) {
        this.owner = parent;
        this.world = world;
        this.pos = pos;
        this.allowFluidVoiding = allowFluidVoiding;
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        FluidStack fluid;
        FluidTank ownerTank = this.owner.getInputTank(forFluidType);
        if (ownerTank == null) {
            return null;
        }
        this.parents.clear();
        int free = ownerTank.getCapacity() - ownerTank.getFluidAmount();
        if (free > 0) {
            this.parents.add((Object)this.owner);
        }
        NNList.NNIterator itr = NNList.FACING.fastIterator();
        while (itr.hasNext()) {
            FluidTank tank2;
            TileEntity neighbor = this.world.func_175625_s(this.pos.func_177972_a((EnumFacing)itr.next()));
            if (!(neighbor instanceof ITankAccess) || (tank2 = ((ITankAccess)neighbor).getInputTank(forFluidType)) == null) continue;
            free += tank2.getCapacity() - tank2.getFluidAmount();
            this.parents.add((Object)((ITankAccess)neighbor));
        }
        if (this.allowFluidVoiding && free < 1000) {
            free = 1000;
        }
        this.tank = new SmartTank((fluid = ownerTank.getFluid()) != null ? fluid.getFluid() : null, free);
        return this.tank;
    }

    @Nonnull
    public FluidTank[] getOutputTanks() {
        return this.owner.getOutputTanks();
    }

    public void setTanksDirty() {
        if (this.tank != null) {
            FluidStack stack = this.tank.getFluid();
            if (stack != null && stack.amount > 0) {
                for (ITankAccess parent : this.parents) {
                    FluidTank ptank = parent.getInputTank(stack);
                    if (ptank == null) continue;
                    stack.amount -= ptank.fill(stack, true);
                    parent.setTanksDirty();
                    if (stack.amount > 0) continue;
                    return;
                }
            }
            this.tank.setCapacity(0);
            this.parents.clear();
        }
    }
}

