/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.integration.forestry.upgrades;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.base.handler.darksteel.AbstractUpgrade;
import crazypants.enderio.base.item.darksteel.ItemDarkSteelArmor;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.integration.forestry.config.ForestryConfig;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;

public class ApiaristArmorUpgrade
extends AbstractUpgrade {
    @Nonnull
    private static final String UPGRADE_NAME = "apiarist_armor_";
    @Nonnull
    public static final ApiaristArmorUpgrade HELMET = new ApiaristArmorUpgrade(EntityEquipmentSlot.HEAD);
    @Nonnull
    public static final ApiaristArmorUpgrade CHEST = new ApiaristArmorUpgrade(EntityEquipmentSlot.CHEST);
    @Nonnull
    public static final ApiaristArmorUpgrade LEGS = new ApiaristArmorUpgrade(EntityEquipmentSlot.LEGS);
    @Nonnull
    public static final ApiaristArmorUpgrade BOOTS = new ApiaristArmorUpgrade(EntityEquipmentSlot.FEET);
    @Nonnull
    private final EntityEquipmentSlot slot;

    protected ApiaristArmorUpgrade(@Nonnull EntityEquipmentSlot slot) {
        super("enderiointegrationforestry", UPGRADE_NAME + slot.func_188450_d(), "enderio.darksteel.upgrade.apiarist_armor." + slot.func_188450_d(), ForestryConfig.apiaristArmorCost);
        this.slot = slot;
    }

    @Override
    public boolean canAddToItem(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
        return item.isForSlot(this.slot) && (item instanceof ItemDarkSteelArmor || item.hasUpgradeCallbacks(this)) && !this.hasUpgrade(stack, item);
    }

    @Override
    @Nonnull
    public List<Supplier<String>> getItemClassesForTooltip() {
        switch (this.slot) {
            case FEET: {
                Object[] objectArray = new Supplier[1];
                objectArray[0] = Lang.DSU_CLASS_ARMOR_FEET::get;
                return new NNList(objectArray);
            }
            case LEGS: {
                Object[] objectArray = new Supplier[1];
                objectArray[0] = Lang.DSU_CLASS_ARMOR_LEGS::get;
                return new NNList(objectArray);
            }
            case CHEST: {
                Object[] objectArray = new Supplier[1];
                objectArray[0] = Lang.DSU_CLASS_ARMOR_CHEST::get;
                return new NNList(objectArray);
            }
            case HEAD: {
                Object[] objectArray = new Supplier[1];
                objectArray[0] = Lang.DSU_CLASS_ARMOR_HEAD::get;
                return new NNList(objectArray);
            }
        }
        Object[] objectArray = new Supplier[1];
        objectArray[0] = Lang.DSU_CLASS_ARMOR::get;
        return new NNList(objectArray);
    }
}

