/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.integration.forestry.filters;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.CycleButton;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.gui.IconEIO;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum SpeciesMode {
    BOTH,
    PRIMARY,
    SECONDARY;


    public SpeciesMode next() {
        SpeciesMode[] values = SpeciesMode.values();
        return values[(this.ordinal() + 1) % values.length];
    }

    @SideOnly(value=Side.CLIENT)
    public static enum IconHolder implements CycleButton.ICycleEnum
    {
        BOTH_ICON(BOTH, IconEIO.FILTER_SPECIES_BOTH),
        PRIMARY_ICON(PRIMARY, IconEIO.FILTER_SPECIES_PRIMARY),
        SECONDARY_ICON(SECONDARY, IconEIO.FILTER_SPECIES_SECONDARY);

        @Nonnull
        private final SpeciesMode mode;
        @Nonnull
        private final IWidgetIcon icon;

        private IconHolder(SpeciesMode mode, IWidgetIcon icon) {
            this.mode = mode;
            this.icon = icon;
        }

        @Nonnull
        public IWidgetIcon getIcon() {
            return this.icon;
        }

        @Nonnull
        public List<String> getTooltipLines() {
            return Collections.singletonList(EnderIO.lang.localize("gui.conduit.item.species.".concat(this.name().toLowerCase(Locale.US))));
        }

        @Nonnull
        public SpeciesMode getMode() {
            return this.mode;
        }

        @Nonnull
        public static IconHolder getFromMode(SpeciesMode mode) {
            for (IconHolder holder : IconHolder.values()) {
                if (holder.mode != mode) continue;
                return holder;
            }
            return BOTH_ICON;
        }
    }
}

