/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.teleport;

import crazypants.enderio.base.sound.SoundRegistry;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class RandomTeleportUtil {
    private static final Random rand = new Random();

    private RandomTeleportUtil() {
    }

    public static void teleportSpawnItem(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ItemStack stack) {
        EntityItem entity = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
        entity.func_174869_p();
        double origX = entity.field_70165_t;
        double origY = MathHelper.func_151237_a((double)entity.field_70163_u, (double)1.0, (double)255.0);
        double origZ = entity.field_70161_v;
        for (int i = 0; i < 5; ++i) {
            double targetX = origX + rand.nextGaussian() * 16.0;
            double targetY = -1.0;
            while (targetY < 1.1) {
                targetY = origY + rand.nextGaussian() * 8.0;
            }
            double targetZ = origZ + rand.nextGaussian() * 16.0;
            if (!RandomTeleportUtil.isClear(world, (Entity)entity, targetX, targetY, targetZ) || !RandomTeleportUtil.doTeleport(world, (Entity)entity, targetX, targetY, targetZ)) continue;
            world.func_72838_d((Entity)entity);
            entity.field_71088_bW = 5;
            return;
        }
        world.func_72838_d((Entity)entity);
    }

    public static void teleportEntity(@Nonnull World world, @Nonnull Entity entity, boolean isItem, boolean dropToGround, float range) {
        if (entity instanceof FakePlayer) {
            return;
        }
        double origX = entity.field_70165_t;
        double origY = MathHelper.func_151237_a((double)entity.field_70163_u, (double)1.0, (double)255.0);
        double origZ = entity.field_70161_v;
        for (int i = 0; i < 15; ++i) {
            double targetX = origX + rand.nextGaussian() * (double)range;
            double targetY = -1.0;
            while (targetY < 1.1) {
                targetY = origY + rand.nextGaussian() * (double)(range / 2.0f);
            }
            double targetZ = origZ + rand.nextGaussian() * (double)range;
            if (dropToGround) {
                for (targetY = (double)MathHelper.func_76128_c((double)targetY) + 0.05; !(!(targetY >= 2.0) || RandomTeleportUtil.hasGround(world, targetX, targetY, targetZ) && RandomTeleportUtil.isClear(world, entity, targetX, targetY, targetZ)); targetY -= 1.0) {
                }
            }
            if (!(targetY >= 2.0) || !RandomTeleportUtil.isClear(world, entity, targetX, targetY, targetZ) || !RandomTeleportUtil.doTeleport(world, entity, targetX, targetY, targetZ)) continue;
            SoundRegistry sound = isItem ? SoundRegistry.TRAVEL_SOURCE_ITEM : SoundRegistry.TRAVEL_SOURCE_BLOCK;
            world.func_184148_a(null, origX, origY, origZ, sound.getSoundEvent(), sound.getSoundCategory(), 1.0f, 1.0f);
            world.func_184148_a(null, targetX, targetY, targetZ, sound.getSoundEvent(), sound.getSoundCategory(), 1.0f, 1.0f);
            entity.field_71088_bW = 5;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isClear(@Nonnull World world, @Nonnull Entity entity, double targetX, double targetY, double targetZ) {
        double origX = entity.field_70165_t;
        double origY = entity.field_70163_u;
        double origZ = entity.field_70161_v;
        try {
            boolean result;
            entity.func_70107_b(targetX, targetY, targetZ);
            boolean bl = result = world.func_72917_a(entity.func_174813_aQ(), entity) && world.func_184144_a(entity, entity.func_174813_aQ()).isEmpty() && !world.func_72953_d(entity.func_174813_aQ());
            return bl;
        }
        finally {
            entity.func_70107_b(origX, origY, origZ);
        }
    }

    private static boolean hasGround(@Nonnull World world, double targetX, double targetY, double targetZ) {
        int xInt = MathHelper.func_76128_c((double)targetX);
        int yInt = MathHelper.func_76128_c((double)targetY);
        int zInt = MathHelper.func_76128_c((double)targetZ);
        return yInt > 1 && world.func_180495_p(new BlockPos(xInt, yInt - 1, zInt)).func_185904_a().func_76230_c();
    }

    private static boolean doTeleport(@Nonnull World world, @Nonnull Entity entity, double targetX, double targetY, double targetZ) {
        if (entity instanceof EntityLivingBase) {
            return RandomTeleportUtil.doTeleport(world, (EntityLivingBase)entity, targetX, targetY, targetZ);
        }
        if (entity.func_184218_aH()) {
            entity.func_184210_p();
        }
        if (entity.func_184207_aI()) {
            entity.func_184226_ay();
        }
        entity.func_70080_a(targetX, targetY, targetZ, entity.field_70177_z, entity.field_70125_A);
        return true;
    }

    private static boolean doTeleport(@Nonnull World world, @Nonnull EntityLivingBase entity, double targetX, double targetY, double targetZ) {
        EnderTeleportEvent event;
        float damage = 5.0f;
        if (entity.func_110138_aP() < 10.0f) {
            damage = 1.0f;
        }
        if (!MinecraftForge.EVENT_BUS.post((Event)(event = new EnderTeleportEvent(entity, targetX, targetY, targetZ, damage)))) {
            if (rand.nextFloat() < 0.15f && world.func_82736_K().func_82766_b("doMobSpawning") && !(entity instanceof EntityEndermite)) {
                EntityEndermite entityendermite = new EntityEndermite(world);
                entityendermite.func_175496_a(true);
                entityendermite.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
                world.func_72838_d((Entity)entityendermite);
            }
            if (entity.func_184218_aH()) {
                entity.func_184210_p();
            }
            if (entity.func_184207_aI()) {
                entity.func_184226_ay();
            }
            if (entity instanceof EntityPlayerMP) {
                ((EntityPlayerMP)entity).field_71135_a.func_147364_a(event.getTargetX(), event.getTargetY(), event.getTargetZ(), entity.field_70177_z, entity.field_70125_A);
            } else {
                entity.func_70634_a(event.getTargetX(), event.getTargetY(), event.getTargetZ());
            }
            entity.field_70143_R = 0.0f;
            entity.func_70097_a(DamageSource.field_76379_h, event.getAttackDamage());
            return true;
        }
        return false;
    }
}

