/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe.painter;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.paint.PaintUtil;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.painter.AbstractPainterTemplate;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class BasicPainterTemplate<T extends Block>
extends AbstractPainterTemplate<T> {
    @Nullable
    protected final T resultBlock;
    @Nonnull
    protected final Block[] validTargets;
    protected final boolean allowEasyConversion;

    public BasicPainterTemplate(boolean allowEasyConversion, @Nullable T resultBlock, Block ... validTargetBlocks) {
        this.resultBlock = resultBlock;
        this.validTargets = validTargetBlocks;
        this.allowEasyConversion = allowEasyConversion;
        PaintUtil.registerPaintable(validTargetBlocks);
    }

    public BasicPainterTemplate(@Nullable T resultBlock, Block ... validTargetBlocks) {
        this(true, resultBlock, validTargetBlocks);
    }

    @Override
    public boolean isRecipe(@Nonnull ItemStack paintSource, @Nonnull ItemStack target) {
        return this.isValidTarget(target) && Prep.isValid(paintSource) && PaintUtil.isValid(paintSource, this.getTargetBlock(target));
    }

    @Override
    public boolean isPartialRecipe(@Nonnull ItemStack paintSource, @Nonnull ItemStack target) {
        if (Prep.isInvalid(paintSource)) {
            return this.isValidTarget(target);
        }
        if (Prep.isInvalid(target)) {
            return PaintUtil.isValid(paintSource, this.getTargetBlock(Prep.getEmpty()));
        }
        return this.isValidTarget(target) && PaintUtil.isValid(paintSource, this.getTargetBlock(target));
    }

    @Override
    @Nonnull
    public IMachineRecipe.ResultStack[] produceCompletedResult(@Nonnull ItemStack paintSource, @Nonnull ItemStack inputStack) {
        T outputBlock = this.getTargetBlock(inputStack);
        if (Prep.isInvalid(inputStack) || Prep.isInvalid(paintSource) || outputBlock == null) {
            return new IMachineRecipe.ResultStack[0];
        }
        Block paintBlock = PaintUtil.getBlockFromItem(paintSource);
        if (paintBlock == null) {
            return new IMachineRecipe.ResultStack[0];
        }
        IBlockState paintState = PaintUtil.Block$getBlockFromItem_stack$getItem___$getStateFromMeta_stack$getMetadata___(paintSource, paintBlock);
        if (paintState == null) {
            return new IMachineRecipe.ResultStack[0];
        }
        ItemStack outputStack = this.isUnpaintingOp(paintSource, inputStack);
        if (Prep.isInvalid(outputStack)) {
            outputStack = this.mkItemStack(inputStack, (Block)outputBlock);
            if (outputBlock == Block.func_149634_a((Item)inputStack.func_77973_b()) && inputStack.func_77942_o()) {
                outputStack.func_77982_d(((NBTTagCompound)NullHelper.notnullM((Object)inputStack.func_77978_p(), (String)"ItemStack.getTagCompound() after .hasTagCompound()")).func_74737_b());
            }
            ((IPaintable)outputBlock).setPaintSource((Block)outputBlock, outputStack, paintState);
        } else if (outputStack.func_77973_b() == inputStack.func_77973_b() && inputStack.func_77942_o()) {
            outputStack.func_77982_d(((NBTTagCompound)NullHelper.notnullM((Object)inputStack.func_77978_p(), (String)"ItemStack.getTagCompound() after .hasTagCompound()")).func_74737_b());
            Block realresult = PaintUtil.getBlockFromItem(outputStack);
            if (realresult instanceof IPaintable) {
                ((IPaintable)realresult).setPaintSource(realresult, outputStack, null);
            } else {
                PaintUtil.setSourceBlock(outputStack, null);
            }
        }
        return new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(outputStack)};
    }

    @Nonnull
    protected ItemStack mkItemStack(@Nonnull ItemStack target, @Nonnull Block targetBlock) {
        Item itemFromBlock = Item.func_150898_a((Block)targetBlock);
        if (itemFromBlock.func_77645_m() || itemFromBlock.func_77614_k()) {
            return new ItemStack(targetBlock, 1, target.func_77952_i());
        }
        return new ItemStack(targetBlock, 1, 0);
    }

    @Override
    public boolean isValidInput(@Nonnull MachineRecipeInput input) {
        if (input.slotNumber == 0) {
            return this.isValidTarget(input.item);
        }
        if (input.slotNumber == 1) {
            return PaintUtil.isValid(input.item, this.resultBlock);
        }
        return false;
    }

    @Nullable
    protected T getTargetBlock(@Nonnull ItemStack target) {
        return this.resultBlock;
    }

    @Nonnull
    public ItemStack isUnpaintingOp(@Nonnull ItemStack paintSource, @Nonnull ItemStack target) {
        if (Prep.isInvalid(paintSource) || Prep.isInvalid(target)) {
            return Prep.getEmpty();
        }
        Block paintBlock = PaintUtil.getBlockFromItem(paintSource);
        Block targetBlock = Block.func_149634_a((Item)target.func_77973_b());
        if (paintBlock == null || targetBlock == Blocks.field_150350_a) {
            return Prep.getEmpty();
        }
        if (paintBlock == this.resultBlock) {
            return this.mkItemStack(target, targetBlock);
        }
        if (paintBlock == targetBlock && this.allowEasyConversion) {
            return this.mkItemStack(paintSource, targetBlock);
        }
        if (targetBlock == this.resultBlock && this.allowEasyConversion) {
            for (Block validTarget : this.validTargets) {
                if (paintBlock != validTarget) continue;
                return this.mkItemStack(paintSource, paintBlock);
            }
        }
        return Prep.getEmpty();
    }

    @Override
    public boolean isValidTarget(@Nonnull ItemStack target) {
        if (Prep.isInvalid(target)) {
            return false;
        }
        Block blk = Block.func_149634_a((Item)target.func_77973_b());
        if (blk == Blocks.field_150350_a) {
            return false;
        }
        if (blk == this.resultBlock) {
            return true;
        }
        for (int i = 0; i < this.validTargets.length; ++i) {
            if (this.validTargets[i] != blk) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void registerTargetsWithTooltipProvider() {
    }
}

