/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.interfaces.IOverlayRenderAware;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.OreDictionaryHelper;
import com.google.common.collect.Multimap;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.api.teleport.IItemOfTravel;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.api.upgrades.IEquipmentData;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.capacitor.CapacitorKey;
import crazypants.enderio.base.config.config.DarkSteelConfig;
import crazypants.enderio.base.config.config.TeleportConfig;
import crazypants.enderio.base.handler.darksteel.DarkSteelRecipeManager;
import crazypants.enderio.base.item.darksteel.attributes.DarkSteelAttributeModifiers;
import crazypants.enderio.base.item.darksteel.attributes.EquipmentData;
import crazypants.enderio.base.item.darksteel.upgrade.direct.DirectUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import crazypants.enderio.base.item.darksteel.upgrade.travel.TravelUpgrade;
import crazypants.enderio.base.render.itemoverlay.PowerBarOverlayRenderHelper;
import crazypants.enderio.base.teleport.TravelController;
import info.loenwind.autoconfig.factory.IValue;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class ItemDarkSteelSword
extends ItemSword
implements IAdvancedTooltipProvider,
IDarkSteelItem,
IItemOfTravel,
IOverlayRenderAware {
    private long lastBlickTick = -1L;
    @Nonnull
    private final IEquipmentData data;

    public static ItemDarkSteelSword createEndSteel(@Nonnull IModObject modObject, @Nullable Block block) {
        ItemDarkSteelSword res = new ItemDarkSteelSword(modObject, EquipmentData.END_STEEL);
        return res;
    }

    public static ItemDarkSteelSword createDarkSteel(@Nonnull IModObject modObject, @Nullable Block block) {
        ItemDarkSteelSword res = new ItemDarkSteelSword(modObject, EquipmentData.DARK_STEEL);
        return res;
    }

    public static ItemDarkSteelSword createStellarAlloy(@Nonnull IModObject modObject, @Nullable Block block) {
        ItemDarkSteelSword res = new ItemDarkSteelSword(modObject, EquipmentData.STELLAR_ALLOY);
        return res;
    }

    public ItemDarkSteelSword(@Nonnull IModObject modObject, @Nonnull IEquipmentData data) {
        super(data.getToolMaterial());
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        modObject.apply(this);
        this.data = data;
    }

    protected int getPowerPerDamagePoint(@Nonnull ItemStack stack) {
        EnergyUpgrade.EnergyUpgradeHolder eu = EnergyUpgradeManager.loadFromItem(stack);
        if (eu != null) {
            return eu.getCapacity() / this.data.getToolMaterial().func_77997_a();
        }
        return 1;
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            ItemStack is = new ItemStack((Item)this);
            list.add((Object)is);
            is = new ItemStack((Item)this);
            ((EnergyUpgrade)EnergyUpgrade.UPGRADES.get(3)).addToItem(is, this);
            if (((EnergyUpgrade)EnergyUpgrade.UPGRADES.get(4)).canAddToItem(is, this)) {
                ((EnergyUpgrade)EnergyUpgrade.UPGRADES.get(4)).addToItem(is, this);
            }
            EnergyUpgradeManager.setPowerFull(is, this);
            TravelUpgrade.INSTANCE.addToItem(is, this);
            DirectUpgrade.INSTANCE.addToItem(is, this);
            list.add((Object)is);
        }
    }

    @Override
    public int getIngotsRequiredForFullRepair() {
        return 3;
    }

    @Override
    public boolean isItemForRepair(@Nonnull ItemStack right) {
        return OreDictionaryHelper.hasName((ItemStack)right, (String)this.data.getRepairIngotOredict());
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EntityEquipmentSlot equipmentSlot, @Nonnull ItemStack stack) {
        Multimap res = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND && ((Integer)DarkSteelConfig.darkSteelSwordPowerUsePerHit.get() <= 0 || EnergyUpgradeManager.getEnergyStored(stack) >= (Integer)DarkSteelConfig.darkSteelSwordPowerUsePerHit.get())) {
            EnergyUpgrade energyUpgrade = EnergyUpgrade.loadAnyFromItem(stack);
            int level = energyUpgrade.getLevel();
            res.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)DarkSteelAttributeModifiers.getAttackDamage(level));
            res.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)DarkSteelAttributeModifiers.getAttackSpeed(level));
        }
        return res;
    }

    public boolean func_77644_a(@Nonnull ItemStack stack, @Nonnull EntityLivingBase entity, @Nonnull EntityLivingBase playerEntity) {
        if (playerEntity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)playerEntity;
            EnergyUpgrade.EnergyUpgradeHolder eu = EnergyUpgradeManager.loadFromItem(stack);
            if (eu != null && eu.isAbsorbDamageWithPower() && eu.getEnergy() > 0) {
                eu.extractEnergy(this.getPowerPerDamagePoint(stack), false);
            } else {
                super.func_77644_a(stack, entity, playerEntity);
            }
            if (eu != null) {
                eu.writeToItem();
                if (eu.getEnergy() >= (Integer)DarkSteelConfig.darkSteelSwordPowerUsePerHit.get()) {
                    this.extractInternal(player.func_184614_ca(), DarkSteelConfig.darkSteelSwordPowerUsePerHit);
                    entity.getEntityData().func_74757_a("hitByDarkSteelSword", true);
                }
            }
        }
        return true;
    }

    @Override
    public int getEnergyStored(@Nonnull ItemStack container) {
        return EnergyUpgradeManager.getEnergyStored(container);
    }

    public boolean func_82789_a(@Nonnull ItemStack i1, @Nonnull ItemStack i2) {
        return false;
    }

    public void addCommonEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        DarkSteelRecipeManager.addCommonTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addBasicEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        DarkSteelRecipeManager.addBasicTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        String str;
        if (!SpecialTooltipHandler.showDurability((boolean)flag)) {
            list.add(ItemUtil.getDurabilityString((ItemStack)itemstack));
        }
        if ((str = EnergyUpgradeManager.getStoredEnergyString(itemstack)) != null) {
            list.add(str);
        }
        DarkSteelRecipeManager.addAdvancedTooltipEntries(itemstack, entityplayer, list, flag);
    }

    @Override
    public boolean isActive(@Nonnull EntityPlayer ep, @Nonnull ItemStack equipped) {
        return this.isTravelUpgradeActive(ep, equipped);
    }

    @Override
    public void extractInternal(@Nonnull ItemStack equipped, int power) {
        EnergyUpgradeManager.extractEnergy(equipped, (IDarkSteelItem)this, power, false);
    }

    private boolean isTravelUpgradeActive(@Nonnull EntityPlayer ep, @Nonnull ItemStack equipped) {
        return ep.func_70093_af() && TravelUpgrade.INSTANCE.hasUpgrade(equipped);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack;
        if (hand == EnumHand.MAIN_HAND && this.isTravelUpgradeActive(player, stack = player.func_184586_b(hand))) {
            if (world.field_72995_K && TravelController.activateTravelAccessable(stack, hand, world, player, TravelSource.STAFF)) {
                player.func_184609_a(hand);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            long ticksSinceBlink = EnderIO.proxy.getTickCount() - this.lastBlickTick;
            if (ticksSinceBlink < 0L) {
                this.lastBlickTick = -1L;
            }
            if (((Boolean)TeleportConfig.enableBlink.get()).booleanValue() && world.field_72995_K && ticksSinceBlink >= (long)((Integer)TeleportConfig.blinkDelay.get()).intValue() && TravelController.doBlink(stack, hand, player)) {
                player.func_184609_a(hand);
                this.lastBlickTick = EnderIO.proxy.getTickCount();
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public void renderItemOverlayIntoGUI(@Nonnull ItemStack stack, int xPosition, int yPosition) {
        PowerBarOverlayRenderHelper.instance_upgradeable.render(stack, xPosition, yPosition);
    }

    public boolean shouldCauseReequipAnimation(@Nonnull ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.func_77973_b() != newStack.func_77973_b();
    }

    @Override
    public boolean isForSlot(@Nonnull EntityEquipmentSlot slot) {
        return slot == EntityEquipmentSlot.MAINHAND;
    }

    @Override
    public boolean hasUpgradeCallbacks(@Nonnull IDarkSteelUpgrade upgrade) {
        return upgrade == TravelUpgrade.INSTANCE;
    }

    @Override
    @Nonnull
    public IEquipmentData getEquipmentData() {
        return this.data;
    }

    @Override
    @Nonnull
    public ICapacitorKey getEnergyStorageKey(@Nonnull ItemStack stack) {
        return CapacitorKey.DARK_STEEL_SWORD_ENERGY_BUFFER;
    }

    @Override
    @Nonnull
    public ICapacitorKey getEnergyInputKey(@Nonnull ItemStack stack) {
        return CapacitorKey.DARK_STEEL_SWORD_ENERGY_INPUT;
    }

    @Override
    @Nonnull
    public ICapacitorKey getEnergyUseKey(@Nonnull ItemStack stack) {
        return CapacitorKey.DARK_STEEL_SWORD_ENERGY_USE;
    }

    @Override
    @Nonnull
    public ICapacitorKey getAbsorptionRatioKey(@Nonnull ItemStack stack) {
        return CapacitorKey.DARK_STEEL_SWORD_ABSORPTION_RATIO;
    }

    @Override
    public void extractInternal(@Nonnull ItemStack equipped, IValue<Integer> power) {
        EnergyUpgradeManager.extractEnergy(equipped, (IDarkSteelItem)this, power, false);
    }
}

