/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.farming.fertilizer;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.farm.IFertilizer;
import crazypants.enderio.api.farm.IFertilizerResult;
import crazypants.enderio.base.farming.fertilizer.AbstractFertilizer;
import crazypants.enderio.base.farming.fertilizer.FertilizerResult;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="enderio")
public final class NoFertilizer
extends AbstractFertilizer {
    private static IFertilizer NONE;

    @Nonnull
    public static IFertilizer getNone() {
        return (IFertilizer)NullHelper.notnull((Object)NONE, (String)"fertilizing before game has started error");
    }

    private NoFertilizer() {
        super(Prep.getEmpty());
        this.setRegistryName("enderio", "none");
    }

    @Override
    public IFertilizerResult apply(@Nonnull ItemStack stack, @Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos bc) {
        return new FertilizerResult(stack, false);
    }

    @Override
    public boolean matches(@Nonnull ItemStack stack) {
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerFertilizer(@Nonnull RegistryEvent.Register<IFertilizer> event) {
        NONE = new NoFertilizer();
        event.getRegistry().register((IForgeRegistryEntry)NONE);
    }

    @Override
    @Nonnull
    public NonNullList<ItemStack> getGuiItem() {
        return NNList.emptyList();
    }
}

