/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.AbstractCrafting;
import crazypants.enderio.base.config.recipes.xml.ItemConsumable;
import crazypants.enderio.base.config.recipes.xml.ItemFloatAmount;
import crazypants.enderio.base.integration.tic.TicProxy;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class Casting
extends AbstractCrafting {
    private Optional<ItemFloatAmount> input = this.empty();
    private Optional<ItemConsumable> cast = this.empty();

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        try {
            super.readResolve();
            if (!this.input.isPresent()) {
                throw new InvalidRecipeConfigException("Missing <input>");
            }
            this.valid = this.valid && this.input.get().isValid() && (!this.cast.isPresent() || this.cast.get().isValid());
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <casting>");
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        super.enforceValidity();
        this.input.get().enforceValidity();
    }

    @Override
    public boolean isActive() {
        return super.isActive();
    }

    @Override
    public void register(@Nonnull String recipeName) {
        if (this.isValid() && this.isActive()) {
            if (TicProxy.isLoaded()) {
                if (this.cast.isPresent()) {
                    TicProxy.registerTableCast(this.getOutput().getThing(), this.cast.get().getThing(), this.input.get().getThing(), this.input.get().amount, this.cast.get().getConsumed());
                } else {
                    TicProxy.registerTableCast(this.getOutput().getThing(), new Things(), this.input.get().getThing(), this.input.get().amount, false);
                }
            } else {
                Log.warn("TiC recipe is active, but TiC integration is not loaded");
            }
        }
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("input".equals(name) && !this.input.isPresent()) {
            this.input = this.of(factory.read(new ItemFloatAmount().setAllowDelaying(true), startElement));
            return true;
        }
        if ("cast".equals(name) && !this.cast.isPresent()) {
            this.cast = this.of(factory.read(new ItemConsumable().setAllowDelaying(true), startElement));
            return true;
        }
        return super.setElement(factory, name, startElement);
    }
}

