/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui.button;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.common.util.NNList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;

public class CycleButton<T extends Enum<T>>
extends IconButton {
    @Nonnull
    private final NNList<T> modes;
    @Nullable
    private T mode;

    public CycleButton(@Nonnull IGuiScreen gui, int id, int x, int y, @Nonnull Class<T> enumClass) {
        super(gui, id, x, y, null);
        this.modes = NNList.of(enumClass);
    }

    @Override
    public void onGuiInit() {
        super.onGuiInit();
        if (this.mode == null) {
            this.setMode((Enum)this.modes.get(0));
        }
    }

    @Override
    public boolean func_146116_c(@Nonnull Minecraft par1Minecraft, int par2, int par3) {
        boolean result = super.func_146116_c(par1Minecraft, par2, par3);
        if (result) {
            this.nextMode();
        }
        return result;
    }

    @Override
    public boolean mousePressedButton(@Nonnull Minecraft mc, int mouseX, int mouseY, int button) {
        boolean result;
        boolean bl = result = button == 1 && super.checkMousePress(mc, mouseX, mouseY);
        if (result) {
            this.prevMode();
        }
        return result;
    }

    private void nextMode() {
        this.setMode((Enum)this.modes.next(this.getMode()));
    }

    private void prevMode() {
        this.setMode((Enum)this.modes.prev(this.getMode()));
    }

    public void setMode(@Nonnull T newMode) {
        if (this.mode == newMode) {
            return;
        }
        this.mode = newMode;
        List<String> tooltip = ((ICycleEnum)newMode).getTooltipLines();
        this.setToolTip(tooltip.toArray(new String[tooltip.size()]));
        this.icon = ((ICycleEnum)newMode).getIcon();
    }

    @Nonnull
    public T getMode() {
        return (T)(this.mode != null ? this.mode : (Enum)this.modes.get(0));
    }

    public static interface ICycleEnum {
        @Nonnull
        public IWidgetIcon getIcon();

        @Nonnull
        public List<String> getTooltipLines();
    }
}

