/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbbackups;

import com.feed_the_beast.mods.ftbbackups.BackupUtils;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="ftbbackups")
@Config(modid="ftbbackups", category="")
public class FTBBackupsConfig {
    public static final General general = new General();

    public static boolean sync() {
        ConfigManager.sync((String)"ftbbackups", (Config.Type)Config.Type.INSTANCE);
        return true;
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("ftbbackups")) {
            FTBBackupsConfig.sync();
        }
    }

    public static class General {
        @Config.LangKey(value="addServer.resourcePack.enabled")
        @Config.Comment(value={"Enables backups."})
        public boolean enabled = true;
        @Config.Comment(value={"If set to true, no messages will be displayed in chat/status bar."})
        public boolean silent = false;
        @Config.RangeInt(min=0, max=32000)
        @Config.Comment(value={"The number of backup files to keep.", "More backups = more space used", "0 - Infinite"})
        public int backups_to_keep = 12;
        @Config.RangeDouble(min=0.05, max=600.0)
        @Config.Comment(value={"Timer in hours.", "1.0 - backups every hour", "6.0 - backups every 6 hours", "0.5 - backups every 30 minutes"})
        public double backup_timer = 2.0;
        @Config.RangeInt(min=0, max=9)
        @Config.Comment(value={"0 - Disabled (output = folders)", "1 - Best speed", "9 - Smallest file size"})
        public int compression_level = 1;
        @Config.Comment(value={"Absolute path to backups folder."})
        public String folder = "";
        @Config.Comment(value={"Prints (current size | total size) when backup is done."})
        public boolean display_file_size = true;
        @Config.Comment(value={"Add extra files that will be placed in backup _extra_/ folder."})
        public String[] extra_files = new String[0];
        @Config.Comment(value={"Maximum total size that is allowed in backups folder. Older backups will be deleted to free space for newer ones."})
        public String max_total_size = "50 GB";
        @Config.Comment(value={"Disables level saving while performing backup."})
        public boolean disable_level_saving = true;
        @Config.Comment(value={"Only create backups when players have been online."})
        public boolean only_if_players_online = true;
        @Config.Comment(value={"Create a backup when server is stopped."})
        public boolean force_on_shutdown = false;
        @Config.Comment(value={"Buffer size for writing files Don't change unless you know what you are doing."})
        @Config.RangeInt(min=256, max=65536)
        public int buffer_size = 4096;

        public long time() {
            return (long)(this.backup_timer * 3600000.0);
        }

        public long getMaxTotalSize() {
            String s = BackupUtils.removeAllWhitespace(this.max_total_size).toUpperCase();
            if (s.endsWith("TB")) {
                return Long.parseLong(s.substring(0, s.length() - 2)) * 0x10000000000L;
            }
            if (s.endsWith("GB")) {
                return Long.parseLong(s.substring(0, s.length() - 2)) * 0x40000000L;
            }
            if (s.endsWith("MB")) {
                return Long.parseLong(s.substring(0, s.length() - 2)) * 0x100000L;
            }
            if (s.endsWith("KB")) {
                return Long.parseLong(s.substring(0, s.length() - 2)) * 1024L;
            }
            return Long.parseLong(s);
        }
    }
}

