/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.guiadvanced.util;

import de.eydamos.backpack.misc.Constants;
import de.eydamos.guiadvanced.util.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.opengl.GL11;

public class Rectangle {
    protected int width;
    protected int height;
    protected int u = 0;
    protected int v = 0;
    protected int z = 0;
    protected int uMax = 1;
    protected int vMax = 1;
    protected ResourceLocation graphic = Constants.guiCombined;
    protected RenderHelper.BackgroundRepeat repeat = RenderHelper.BackgroundRepeat.NONE;

    public Rectangle(int width, int height) {
        this.width = width;
        this.height = height;
    }

    protected Minecraft getMinecraft() {
        return FMLClientHandler.instance().getClient();
    }

    public void setWidth(int value) {
        this.width = value;
    }

    public void setHeight(int value) {
        this.height = value;
    }

    public void setBackgroundPosition(int xOffset, int yOffset) {
        this.u = xOffset;
        this.v = yOffset;
    }

    public void setBackgroundSize(int sizeX, int sizeY) {
        this.uMax = sizeX;
        this.vMax = sizeY;
    }

    public void setBackgroundRepeat(RenderHelper.BackgroundRepeat backgroundRepeat) {
        this.repeat = backgroundRepeat;
    }

    public void setBackground(ResourceLocation resourceLocation) {
        this.graphic = resourceLocation;
    }

    public void draw(int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(this.graphic);
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (this.repeat == RenderHelper.BackgroundRepeat.NONE) {
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            this.addVertexWithUV(bufferbuilder, x, y + this.height, this.z, (float)this.u * f, (float)(this.v + this.height) * f1);
            this.addVertexWithUV(bufferbuilder, x + this.width, y + this.height, this.z, (float)(this.u + this.width) * f, (float)(this.v + this.height) * f1);
            this.addVertexWithUV(bufferbuilder, x + this.width, y, this.z, (float)(this.u + this.width) * f, (float)this.v * f1);
            this.addVertexWithUV(bufferbuilder, x, y, this.z, (float)this.u * f, (float)this.v * f1);
            tessellator.func_78381_a();
        } else if (this.repeat == RenderHelper.BackgroundRepeat.REPEAT) {
            int drawHeight = this.vMax = Math.min(this.height, this.vMax);
            int drawWidth = this.uMax = Math.min(this.width, this.uMax);
            for (int i = 0; i <= this.width; i += this.uMax) {
                for (int j = 0; j <= this.height; j += this.vMax) {
                    drawWidth = i + this.uMax > this.width ? this.width : i + this.uMax;
                    drawHeight = j + this.vMax > this.height ? this.height : j + this.vMax;
                    bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    this.addVertexWithUV(bufferbuilder, x + i, y + drawHeight, this.z, (float)this.u * f, (float)(this.v + this.vMax) * f1);
                    this.addVertexWithUV(bufferbuilder, x + drawWidth, y + drawHeight, this.z, (float)(this.u + this.uMax) * f, (float)(this.v + this.vMax) * f1);
                    this.addVertexWithUV(bufferbuilder, x + drawWidth, y, this.z, (float)(this.u + this.uMax) * f, (float)this.v * f1);
                    this.addVertexWithUV(bufferbuilder, x + i, y, this.z, (float)this.u * f, (float)this.v * f1);
                    tessellator.func_78381_a();
                }
            }
        } else if (this.repeat == RenderHelper.BackgroundRepeat.REPEAT_X) {
            int drawHeight = this.vMax = Math.min(this.height, this.vMax);
            for (int i = 0; i <= this.width; i += this.uMax) {
                int drawWidth = i + this.uMax > this.width ? this.width : i + this.uMax;
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                this.addVertexWithUV(bufferbuilder, x + i, y + drawHeight, this.z, (float)this.u * f, (float)(this.v + drawHeight) * f1);
                this.addVertexWithUV(bufferbuilder, x + drawWidth, y + drawHeight, this.z, (float)(this.u + this.uMax) * f, (float)(this.v + drawHeight) * f1);
                this.addVertexWithUV(bufferbuilder, x + drawWidth, y, this.z, (float)(this.u + this.uMax) * f, (float)this.v * f1);
                this.addVertexWithUV(bufferbuilder, x + i, y, this.z, (float)this.u * f, (float)this.v * f1);
                tessellator.func_78381_a();
            }
        } else if (this.repeat == RenderHelper.BackgroundRepeat.REPEAT_Y) {
            int drawWidth = this.uMax = Math.min(this.width, this.uMax);
            for (int i = 0; i <= this.height; i += this.vMax) {
                int drawHeight = i + this.vMax > this.height ? this.height : i + this.vMax;
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                this.addVertexWithUV(bufferbuilder, x, y + drawHeight, this.z, (float)this.u * f, (float)(this.v + this.vMax) * f1);
                this.addVertexWithUV(bufferbuilder, x + drawWidth, y + drawHeight, this.z, (float)(this.u + drawWidth) * f, (float)(this.v + this.vMax) * f1);
                this.addVertexWithUV(bufferbuilder, x + drawWidth, y + i, this.z, (float)(this.u + drawWidth) * f, (float)this.v * f1);
                this.addVertexWithUV(bufferbuilder, x, y + i, this.z, (float)this.u * f, (float)this.v * f1);
                tessellator.func_78381_a();
            }
        } else {
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            this.addVertexWithUV(bufferbuilder, x, y + this.height, this.z, (float)this.u * f, (float)this.vMax * f1);
            this.addVertexWithUV(bufferbuilder, x + this.width, y + this.height, this.z, (float)this.uMax * f, (float)this.vMax * f1);
            this.addVertexWithUV(bufferbuilder, x + this.width, y, this.z, (float)this.uMax * f, (float)this.v * f1);
            this.addVertexWithUV(bufferbuilder, x, y, this.z, (float)this.u * f, (float)this.v * f1);
            tessellator.func_78381_a();
        }
    }

    private void addVertexWithUV(BufferBuilder worldRenderer, int x, int y, int z, float u, float v) {
        worldRenderer.func_181662_b((double)x, (double)y, (double)z).func_187315_a((double)u, (double)v).func_181675_d();
    }
}

