/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.item;

import de.eydamos.backpack.Features;
import java.util.Hashtable;

public enum EFrame {
    WOOD(0, "wood", Features.BACKPACK_FRAME_WOOD),
    STONE(1, "stone", Features.BACKPACK_FRAME_STONE),
    IRON(2, "iron", Features.BACKPACK_FRAME_IRON);

    private static Hashtable<Integer, String> VARIANTS;
    private final int damage;
    private final String identifier;
    private final Features feature;

    private EFrame(int damage, String identifier, Features feature) {
        this.damage = damage;
        this.identifier = identifier;
        this.feature = feature;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getDamage() {
        return this.damage;
    }

    public boolean isEnabled() {
        return this.feature.isEnabled();
    }

    public static String getIdentifierByDamage(int damage) {
        for (EFrame frame : EFrame.values()) {
            if (frame.getDamage() != damage) continue;
            return frame.identifier;
        }
        return "";
    }

    public static Hashtable<Integer, String> getVariants() {
        return VARIANTS;
    }

    static {
        VARIANTS = new Hashtable();
        for (EFrame frame : EFrame.values()) {
            VARIANTS.put(frame.getDamage(), frame.getIdentifier());
        }
    }
}

