/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.init;

import de.eydamos.backpack.Features;
import java.util.Locale;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.StringUtils;

public class Configurations {
    public static Configuration config;
    public static boolean configExists;
    public static boolean OPEN_ONLY_EQUIPPED_BACKPACK;
    public static boolean RENDER_BACKPACK_MODEL;
    public static int MAX_BACKPACK_AMOUNT;

    public static boolean refreshConfig() {
        config.getCategory("general").setComment("General Backpack configuration");
        config.getCategory("features").setComment("Configuration to disable certain features");
        OPEN_ONLY_EQUIPPED_BACKPACK = config.get("general", "openOnlyEquippedBackpacks", false, Configurations.getOpenOnlyEquippedBackpacksComment()).getBoolean(false);
        RENDER_BACKPACK_MODEL = config.get("general", "renderBackpackModel", true, Configurations.getRenderBackpackModelComment()).getBoolean(true);
        MAX_BACKPACK_AMOUNT = config.get("general", "maxBackpackAmount", 0, Configurations.getMaxBackpackAmountComment(), 0, 36).getInt();
        if (config.hasChanged()) {
            config.save();
        }
        return true;
    }

    public static boolean featureEnabled(Features feature) {
        return config.get("features", Configurations.featureName(feature), true, feature.getConfigComment()).getBoolean(true) && Configurations.refreshConfig();
    }

    public static String featureName(Features feature) {
        String[] words = feature.name().toLowerCase(Locale.ENGLISH).split("_");
        if (words.length == 1) {
            return words[0];
        }
        StringBuilder featureName = new StringBuilder(words[0]);
        for (int i = 1; i < words.length; ++i) {
            featureName.append(StringUtils.capitalize((String)words[i]));
        }
        return featureName.toString();
    }

    private static String getOpenOnlyEquippedBackpacksComment() {
        return "If true you can only open a backpack that you have equipped on your back";
    }

    private static String getRenderBackpackModelComment() {
        return "If true the backpack 3D model will be rendered";
    }

    private static String getMaxBackpackAmountComment() {
        return "Number of backpacks a player can have in his inventory\nvalid: integers 0-36\n0 = unlimited\n";
    }
}

