/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.config;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftblib.events.RegisterRankConfigEvent;
import com.feed_the_beast.ftblib.events.RegisterRankConfigHandlerEvent;
import com.feed_the_beast.ftblib.lib.config.ConfigNull;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.DefaultRankConfigHandler;
import com.feed_the_beast.ftblib.lib.config.IRankConfigHandler;
import com.feed_the_beast.ftblib.lib.config.RankConfigValueInfo;
import com.feed_the_beast.ftblib.lib.util.misc.Node;
import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.server.permission.context.IContext;
import net.minecraftforge.server.permission.context.PlayerContext;

public class RankConfigAPI {
    private static IRankConfigHandler handler = null;

    private static void setHandler(IRankConfigHandler h) {
        Preconditions.checkNotNull((Object)h, (Object)"Permission handler can't be null!");
        FTBLib.LOGGER.warn("Replacing " + handler.getClass().getName() + " with " + h.getClass().getName());
        handler = h;
    }

    public static IRankConfigHandler getHandler() {
        if (handler == null) {
            handler = DefaultRankConfigHandler.INSTANCE;
            new RegisterRankConfigHandlerEvent(RankConfigAPI::setHandler).post();
            new RegisterRankConfigEvent(handler::registerRankConfig).post();
        }
        return handler;
    }

    public static ConfigValue get(MinecraftServer server, GameProfile profile, Node node, @Nullable IContext context) {
        Preconditions.checkNotNull((Object)profile, (Object)"GameProfile can't be null!");
        Preconditions.checkNotNull((Object)node, (Object)"Config node can't be null!");
        return RankConfigAPI.getHandler().getConfigValue(server, profile, node, context);
    }

    public static ConfigValue get(EntityPlayerMP player, Node node) {
        Preconditions.checkNotNull((Object)player, (Object)"Player can't be null!");
        Preconditions.checkNotNull((Object)node, (Object)"Config node can't be null!");
        return RankConfigAPI.get(player.field_71133_b, player.func_146103_bH(), node, (IContext)new PlayerContext((EntityPlayer)player));
    }

    public static ConfigValue getConfigValue(Node node, boolean op) {
        RankConfigValueInfo info = RankConfigAPI.getHandler().getInfo(node);
        return info == null ? ConfigNull.INSTANCE : (op ? info.defaultOPValue : info.defaultValue);
    }
}

