/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.lighting.LC;
import codechicken.lib.lighting.LightModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.render.pipeline.IVertexSource;
import codechicken.lib.render.pipeline.VertexAttribute;
import codechicken.lib.render.pipeline.attribute.AttributeKey;
import codechicken.lib.render.pipeline.attribute.ColourAttribute;
import codechicken.lib.render.pipeline.attribute.LightCoordAttribute;
import codechicken.lib.render.pipeline.attribute.LightingAttribute;
import codechicken.lib.render.pipeline.attribute.NormalAttribute;
import codechicken.lib.util.ArrayUtils;
import codechicken.lib.util.Copyable;
import codechicken.lib.util.VectorUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.TransformationList;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.Vertex5;
import codechicken.lib.vec.uv.UV;
import codechicken.lib.vec.uv.UVTransformation;
import codechicken.lib.vec.uv.UVTranslation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class CCModel
implements IVertexSource,
Copyable<CCModel> {
    public final int vertexMode;
    public final int vp;
    public Vertex5[] verts;
    public ArrayList<Object> attributes = new ArrayList();

    protected CCModel(int vertexMode) {
        if (vertexMode != 7 && vertexMode != 4) {
            throw new IllegalArgumentException("Models must be GL_QUADS or GL_TRIANGLES");
        }
        this.vertexMode = vertexMode;
        this.vp = vertexMode == 7 ? 4 : 3;
    }

    public Vector3[] normals() {
        return this.getAttributes(NormalAttribute.attributeKey);
    }

    @Override
    public Vertex5[] getVertices() {
        return this.verts;
    }

    @Override
    public <T> T getAttributes(AttributeKey<T> attr) {
        if (attr.attributeKeyIndex < this.attributes.size()) {
            return (T)this.attributes.get(attr.attributeKeyIndex);
        }
        return null;
    }

    @Override
    public boolean hasAttribute(AttributeKey<?> attr) {
        return attr.attributeKeyIndex < this.attributes.size() && this.attributes.get(attr.attributeKeyIndex) != null;
    }

    @Override
    public void prepareVertex(CCRenderState state) {
    }

    public <T> T getOrAllocate(AttributeKey<T> attr) {
        T array = this.getAttributes(attr);
        if (array == null) {
            while (this.attributes.size() <= attr.attributeKeyIndex) {
                this.attributes.add(null);
            }
            array = attr.newArray(this.verts.length);
            this.attributes.set(attr.attributeKeyIndex, array);
        }
        return array;
    }

    public CCModel generateBox(int i, double x1, double y1, double z1, double w, double h, double d, double tx, double ty, double tw, double th, double f) {
        double x2 = x1 + w;
        double y2 = y1 + h;
        double z2 = z1 + d;
        x1 /= f;
        x2 /= f;
        y1 /= f;
        y2 /= f;
        z1 /= f;
        double u1 = (tx + d + w) / tw;
        double v1 = (ty + d) / th;
        double u2 = (tx + d * 2.0 + w) / tw;
        double v2 = ty / th;
        this.verts[i++] = new Vertex5(x1, y1, z2 /= f, u1, v2);
        this.verts[i++] = new Vertex5(x1, y1, z1, u1, v1);
        this.verts[i++] = new Vertex5(x2, y1, z1, u2, v1);
        this.verts[i++] = new Vertex5(x2, y1, z2, u2, v2);
        u1 = (tx + d) / tw;
        v1 = (ty + d) / th;
        u2 = (tx + d + w) / tw;
        v2 = ty / th;
        this.verts[i++] = new Vertex5(x2, y2, z2, u2, v2);
        this.verts[i++] = new Vertex5(x2, y2, z1, u2, v1);
        this.verts[i++] = new Vertex5(x1, y2, z1, u1, v1);
        this.verts[i++] = new Vertex5(x1, y2, z2, u1, v2);
        u1 = (tx + d + w) / tw;
        v1 = (ty + d) / th;
        u2 = (tx + d) / tw;
        v2 = (ty + d + h) / th;
        this.verts[i++] = new Vertex5(x1, y2, z1, u2, v1);
        this.verts[i++] = new Vertex5(x2, y2, z1, u1, v1);
        this.verts[i++] = new Vertex5(x2, y1, z1, u1, v2);
        this.verts[i++] = new Vertex5(x1, y1, z1, u2, v2);
        u1 = (tx + d * 2.0 + w * 2.0) / tw;
        v1 = (ty + d) / th;
        u2 = (tx + d * 2.0 + w) / tw;
        v2 = (ty + d + h) / th;
        this.verts[i++] = new Vertex5(x1, y2, z2, u1, v1);
        this.verts[i++] = new Vertex5(x1, y1, z2, u1, v2);
        this.verts[i++] = new Vertex5(x2, y1, z2, u2, v2);
        this.verts[i++] = new Vertex5(x2, y2, z2, u2, v1);
        u1 = (tx + d) / tw;
        v1 = (ty + d) / th;
        u2 = tx / tw;
        v2 = (ty + d + h) / th;
        this.verts[i++] = new Vertex5(x1, y2, z2, u2, v1);
        this.verts[i++] = new Vertex5(x1, y2, z1, u1, v1);
        this.verts[i++] = new Vertex5(x1, y1, z1, u1, v2);
        this.verts[i++] = new Vertex5(x1, y1, z2, u2, v2);
        u1 = (tx + d * 2.0 + w) / tw;
        v1 = (ty + d) / th;
        u2 = (tx + d + w) / tw;
        v2 = (ty + d + h) / th;
        this.verts[i++] = new Vertex5(x2, y1, z2, u1, v2);
        this.verts[i++] = new Vertex5(x2, y1, z1, u2, v2);
        this.verts[i++] = new Vertex5(x2, y2, z1, u2, v1);
        this.verts[i++] = new Vertex5(x2, y2, z2, u1, v1);
        return this;
    }

    public CCModel generateBlock(int i, Cuboid6 bounds) {
        return this.generateBlock(i, bounds, 0);
    }

    public CCModel generateBlock(int i, Cuboid6 bounds, int mask) {
        return this.generateBlock(i, bounds.min.x, bounds.min.y, bounds.min.z, bounds.max.x, bounds.max.y, bounds.max.z, mask);
    }

    public CCModel generateBlock(int i, double x1, double y1, double z1, double x2, double y2, double z2) {
        return this.generateBlock(i, x1, y1, z1, x2, y2, z2, 0);
    }

    public CCModel generateBlock(int i, double x1, double y1, double z1, double x2, double y2, double z2, int mask) {
        double v2;
        double u2;
        double v1;
        double u1;
        if ((mask & 1) == 0) {
            u1 = x1;
            v1 = z1;
            u2 = x2;
            v2 = z2;
            this.verts[i++] = new Vertex5(x1, y1, z2, u1, v2, 0);
            this.verts[i++] = new Vertex5(x1, y1, z1, u1, v1, 0);
            this.verts[i++] = new Vertex5(x2, y1, z1, u2, v1, 0);
            this.verts[i++] = new Vertex5(x2, y1, z2, u2, v2, 0);
        }
        if ((mask & 2) == 0) {
            u1 = x1;
            v1 = z1;
            u2 = x2;
            v2 = z2;
            this.verts[i++] = new Vertex5(x2, y2, z2, u2, v2, 1);
            this.verts[i++] = new Vertex5(x2, y2, z1, u2, v1, 1);
            this.verts[i++] = new Vertex5(x1, y2, z1, u1, v1, 1);
            this.verts[i++] = new Vertex5(x1, y2, z2, u1, v2, 1);
        }
        if ((mask & 4) == 0) {
            u1 = 1.0 - x1;
            v1 = 1.0 - y2;
            u2 = 1.0 - x2;
            v2 = 1.0 - y1;
            this.verts[i++] = new Vertex5(x1, y1, z1, u1, v2, 2);
            this.verts[i++] = new Vertex5(x1, y2, z1, u1, v1, 2);
            this.verts[i++] = new Vertex5(x2, y2, z1, u2, v1, 2);
            this.verts[i++] = new Vertex5(x2, y1, z1, u2, v2, 2);
        }
        if ((mask & 8) == 0) {
            u1 = x1;
            v1 = 1.0 - y2;
            u2 = x2;
            v2 = 1.0 - y1;
            this.verts[i++] = new Vertex5(x2, y1, z2, u2, v2, 3);
            this.verts[i++] = new Vertex5(x2, y2, z2, u2, v1, 3);
            this.verts[i++] = new Vertex5(x1, y2, z2, u1, v1, 3);
            this.verts[i++] = new Vertex5(x1, y1, z2, u1, v2, 3);
        }
        if ((mask & 0x10) == 0) {
            u1 = z1;
            v1 = 1.0 - y2;
            u2 = z2;
            v2 = 1.0 - y1;
            this.verts[i++] = new Vertex5(x1, y1, z2, u2, v2, 4);
            this.verts[i++] = new Vertex5(x1, y2, z2, u2, v1, 4);
            this.verts[i++] = new Vertex5(x1, y2, z1, u1, v1, 4);
            this.verts[i++] = new Vertex5(x1, y1, z1, u1, v2, 4);
        }
        if ((mask & 0x20) == 0) {
            u1 = 1.0 - z1;
            v1 = 1.0 - y2;
            u2 = 1.0 - z2;
            v2 = 1.0 - y1;
            this.verts[i++] = new Vertex5(x2, y1, z1, u1, v2, 5);
            this.verts[i++] = new Vertex5(x2, y2, z1, u1, v1, 5);
            this.verts[i++] = new Vertex5(x2, y2, z2, u2, v1, 5);
            this.verts[i++] = new Vertex5(x2, y1, z2, u2, v2, 5);
        }
        return this;
    }

    public CCModel computeNormals() {
        return this.computeNormals(0, this.verts.length);
    }

    public CCModel computeNormals(int start, int length) {
        if (length % this.vp != 0 || start % this.vp != 0) {
            throw new IllegalArgumentException("Cannot generate normals across polygons");
        }
        Vector3[] normals = this.getOrAllocate(NormalAttribute.attributeKey);
        for (int k = 0; k < length; k += this.vp) {
            int i = k + start;
            Vector3 diff1 = this.verts[i + 1].vec.copy().subtract(this.verts[i].vec);
            Vector3 diff2 = this.verts[i + this.vp - 1].vec.copy().subtract(this.verts[i].vec);
            normals[i] = diff1.crossProduct(diff2).normalize();
            for (int d = 1; d < this.vp; ++d) {
                normals[i + d] = normals[i].copy();
            }
        }
        return this;
    }

    public CCModel computeLighting(LightModel light) {
        Vector3[] normals = this.normals();
        int[] colours = this.getAttributes(LightingAttribute.attributeKey);
        if (colours == null) {
            colours = this.getOrAllocate(LightingAttribute.attributeKey);
            Arrays.fill(colours, -1);
        }
        for (int k = 0; k < this.verts.length; ++k) {
            colours[k] = light.apply(colours[k], normals[k]);
        }
        return this;
    }

    public CCModel setColour(int c) {
        int[] colours = this.getOrAllocate(ColourAttribute.attributeKey);
        Arrays.fill(colours, c);
        return this;
    }

    public CCModel computeLightCoords() {
        LC[] lcs = this.getOrAllocate(LightCoordAttribute.attributeKey);
        Vector3[] normals = this.normals();
        for (int i = 0; i < this.verts.length; ++i) {
            lcs[i] = new LC().compute(this.verts[i].vec, normals[i]);
        }
        return this;
    }

    public CCModel smoothNormals() {
        ArrayList<PositionNormalEntry> map = new ArrayList<PositionNormalEntry>();
        Vector3[] normals = this.normals();
        block0: for (int k = 0; k < this.verts.length; ++k) {
            Vector3 vec = this.verts[k].vec;
            for (PositionNormalEntry e : map) {
                if (!e.positionEqual(vec)) continue;
                e.addNormal(normals[k]);
                continue block0;
            }
            map.add(new PositionNormalEntry(vec).addNormal(normals[k]));
        }
        for (PositionNormalEntry e : map) {
            if (e.normals.size() <= 1) continue;
            Vector3 new_n = new Vector3();
            for (Vector3 n : e.normals) {
                new_n.add(n);
            }
            new_n.normalize();
            for (Vector3 n : e.normals) {
                n.set(new_n);
            }
        }
        return this;
    }

    public CCModel apply(Transformation t) {
        for (Vertex5 vert : this.verts) {
            vert.apply(t);
        }
        Vector3[] normals = this.normals();
        if (normals != null) {
            for (Vector3 normal : normals) {
                t.applyN(normal);
            }
        }
        return this;
    }

    public CCModel apply(UVTransformation uvt) {
        for (Vertex5 vert : this.verts) {
            vert.apply(uvt);
        }
        return this;
    }

    public CCModel expand(int extraVerts) {
        int newLen = this.verts.length + extraVerts;
        this.verts = Arrays.copyOf(this.verts, newLen);
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (this.attributes.get(i) == null) continue;
            this.attributes.set(i, VertexAttribute.copyOf(AttributeKey.AttributeKeyRegistry.getAttributeKey(i), this.attributes.get(i), newLen));
        }
        return this;
    }

    public void render(CCRenderState state, double x, double y, double z, double u, double v) {
        this.render(state, new Vector3(x, y, z).translation(), new UVTranslation(u, v));
    }

    public void render(CCRenderState state, double x, double y, double z, UVTransformation u) {
        this.render(state, new Vector3(x, y, z).translation(), u);
    }

    public void render(CCRenderState state, Transformation t, double u, double v) {
        this.render(state, t, new UVTranslation(u, v));
    }

    public void render(CCRenderState state, IVertexOperation ... ops) {
        this.render(state, 0, this.verts.length, ops);
    }

    public void render(CCRenderState state, int start, int end, IVertexOperation ... ops) {
        state.setPipeline(this, start, end, ops);
        state.render();
    }

    public static CCModel quadModel(int numVerts) {
        return CCModel.newModel(7, numVerts);
    }

    public static CCModel triModel(int numVerts) {
        return CCModel.newModel(4, numVerts);
    }

    public static CCModel newModel(int vertexMode, int numVerts) {
        CCModel model = CCModel.newModel(vertexMode);
        model.verts = new Vertex5[numVerts];
        return model;
    }

    public static CCModel newModel(int vertexMode) {
        return new CCModel(vertexMode);
    }

    public static CCModel createModel(List<Vector3> verts, List<Vector3> uvs, List<Vector3> normals, int vertexMode, List<int[]> polys) {
        int vp;
        int n = vp = vertexMode == 7 ? 4 : 3;
        if (polys.size() < vp || polys.size() % vp != 0) {
            throw new IllegalArgumentException("Invalid number of vertices for model: " + polys.size());
        }
        boolean hasNormals = polys.get(0)[2] > 0;
        CCModel model = CCModel.newModel(vertexMode, polys.size());
        if (hasNormals) {
            model.getOrAllocate(NormalAttribute.attributeKey);
        }
        for (int i = 0; i < polys.size(); ++i) {
            int[] ai = polys.get(i);
            Vector3 vert = verts.get(ai[0] - 1).copy();
            Vector3 uv = ai[1] <= 0 ? new Vector3() : uvs.get(ai[1] - 1).copy();
            if (ai[2] > 0 != hasNormals) {
                throw new IllegalArgumentException("Normals are an all or nothing deal here.");
            }
            model.verts[i] = new Vertex5(vert, uv.x, uv.y);
            if (!hasNormals) continue;
            model.normals()[i] = normals.get(ai[2] - 1).copy();
        }
        return model;
    }

    public CCModel shrinkUVs(double d) {
        for (int k = 0; k < this.verts.length; k += this.vp) {
            int i;
            UV uv = new UV();
            for (i = 0; i < this.vp; ++i) {
                uv.add(this.verts[k + i].uv);
            }
            uv.multiply(1.0 / (double)this.vp);
            for (i = 0; i < this.vp; ++i) {
                Vertex5 vert = this.verts[k + i];
                vert.uv.u = vert.uv.u + (vert.uv.u < uv.u ? d : -d);
                vert.uv.v = vert.uv.v + (vert.uv.v < uv.v ? d : -d);
            }
        }
        return this;
    }

    public CCModel sidedCopy(int side1, int side2, Vector3 point) {
        return this.copy().apply(new TransformationList((Transformation)Rotation.sideRotations[side1].inverse(), Rotation.sideRotations[side2]).at(point));
    }

    public static void copy(CCModel src, int srcpos, CCModel dst, int destpos, int length) {
        for (int k = 0; k < length; ++k) {
            dst.verts[destpos + k] = src.verts[srcpos + k].copy();
        }
        for (int i = 0; i < src.attributes.size(); ++i) {
            if (src.attributes.get(i) == null) continue;
            ArrayUtils.arrayCopy(src.attributes.get(i), srcpos, dst.getOrAllocate(AttributeKey.AttributeKeyRegistry.getAttributeKey(i)), destpos, length);
        }
    }

    public static void generateSidedModels(CCModel[] models, int side, Vector3 point) {
        for (int s = 0; s < 6; ++s) {
            if (s == side) continue;
            models[s] = models[side].sidedCopy(side, s, point);
        }
    }

    public static void generateSidedModelsH(CCModel[] models, int side, Vector3 point) {
        for (int s = 2; s < 6; ++s) {
            if (s == side) continue;
            models[s] = models[side].sidedCopy(side, s, point);
        }
    }

    public CCModel backfacedCopy() {
        return CCModel.generateBackface(this, 0, this.copy(), 0, this.verts.length);
    }

    public static CCModel generateBackface(CCModel src, int srcpos, CCModel dst, int destpos, int length) {
        int vp = src.vp;
        if (srcpos % vp != 0 || destpos % vp != 0 || length % vp != 0) {
            throw new IllegalArgumentException("Vertices do not align with polygons");
        }
        int[][] o = new int[][]{{0, 0}, {1, vp - 1}, {2, vp - 2}, {3, vp - 3}};
        for (int i = 0; i < length; ++i) {
            int b = i / vp * vp;
            int d = i % vp;
            int di = destpos + b + o[d][1];
            int si = srcpos + b + o[d][0];
            dst.verts[di] = src.verts[si].copy();
            for (int a = 0; a < src.attributes.size(); ++a) {
                if (src.attributes.get(a) == null) continue;
                ArrayUtils.arrayCopy(src.attributes.get(a), si, dst.getOrAllocate(AttributeKey.AttributeKeyRegistry.getAttributeKey(a)), di, 1);
            }
            if (dst.normals() == null || dst.normals()[di] == null) continue;
            dst.normals()[di].negate();
        }
        return dst;
    }

    public CCModel generateSidedParts(int side, Vector3 point) {
        if (this.verts.length % (6 * this.vp) != 0) {
            throw new IllegalArgumentException("Invalid number of vertices for sided part generation");
        }
        int length = this.verts.length / 6;
        for (int s = 0; s < 6; ++s) {
            if (s == side) continue;
            this.generateSidedPart(side, s, point, length * side, length * s, length);
        }
        return this;
    }

    public CCModel generateSidedPartsH(int side, Vector3 point) {
        if (this.verts.length % (4 * this.vp) != 0) {
            throw new IllegalArgumentException("Invalid number of vertices for sided part generation");
        }
        int length = this.verts.length / 4;
        for (int s = 2; s < 6; ++s) {
            if (s == side) continue;
            this.generateSidedPart(side, s, point, length * (side - 2), length * (s - 2), length);
        }
        return this;
    }

    public CCModel generateSidedPart(int side1, int side2, Vector3 point, int srcpos, int destpos, int length) {
        return this.apply(new TransformationList((Transformation)Rotation.sideRotations[side1].inverse(), Rotation.sideRotations[side2]).at(point), srcpos, destpos, length);
    }

    public CCModel apply(Transformation t, int srcpos, int destpos, int length) {
        for (int k = 0; k < length; ++k) {
            this.verts[destpos + k] = this.verts[srcpos + k].copy();
            this.verts[destpos + k].vec.apply(t);
        }
        Vector3[] normals = this.normals();
        if (normals != null) {
            for (int k = 0; k < length; ++k) {
                normals[destpos + k] = normals[srcpos + k].copy();
                t.applyN(normals[destpos + k]);
            }
        }
        return this;
    }

    public static CCModel combine(Collection<CCModel> models) {
        if (models.isEmpty()) {
            return null;
        }
        int numVerts = 0;
        int vertexMode = -1;
        for (CCModel model : models) {
            if (vertexMode == -1) {
                vertexMode = model.vertexMode;
            }
            if (vertexMode != model.vertexMode) {
                throw new IllegalArgumentException("Cannot combine models with different vertex modes");
            }
            numVerts += model.verts.length;
        }
        CCModel c_model = CCModel.newModel(vertexMode, numVerts);
        int i = 0;
        for (CCModel model : models) {
            CCModel.copy(model, 0, c_model, i, model.verts.length);
            i += model.verts.length;
        }
        return c_model;
    }

    public CCModel twoFacedCopy() {
        CCModel model = CCModel.newModel(this.vertexMode, this.verts.length * 2);
        CCModel.copy(this, 0, model, 0, this.verts.length);
        return CCModel.generateBackface(model, 0, model, this.verts.length, this.verts.length);
    }

    @Override
    public CCModel copy() {
        CCModel model = CCModel.newModel(this.vertexMode, this.verts.length);
        CCModel.copy(this, 0, model, 0, this.verts.length);
        return model;
    }

    public Vector3 collapse() {
        Vector3 v = new Vector3();
        for (Vertex5 vert : this.verts) {
            v.add(vert.vec);
        }
        v.multiply(1.0 / (double)this.verts.length);
        return v;
    }

    public CCModel zOffset(Cuboid6 offsets) {
        block8: for (int k = 0; k < this.verts.length; ++k) {
            Vertex5 vert = this.verts[k];
            Vector3 normal = this.normals()[k];
            switch (VectorUtils.findSide(normal)) {
                case 0: {
                    vert.vec.y += offsets.min.y;
                    continue block8;
                }
                case 1: {
                    vert.vec.y += offsets.max.y;
                    continue block8;
                }
                case 2: {
                    vert.vec.z += offsets.min.z;
                    continue block8;
                }
                case 3: {
                    vert.vec.z += offsets.max.z;
                    continue block8;
                }
                case 4: {
                    vert.vec.x += offsets.min.x;
                    continue block8;
                }
                case 5: {
                    vert.vec.x += offsets.max.x;
                }
            }
        }
        return this;
    }

    public Cuboid6 bounds() {
        Vector3 vec1 = this.verts[0].vec;
        Cuboid6 c = new Cuboid6(vec1.copy(), vec1.copy());
        for (int i = 1; i < this.verts.length; ++i) {
            c.enclose(this.verts[i].vec);
        }
        return c;
    }

    private static class PositionNormalEntry {
        public Vector3 pos;
        public LinkedList<Vector3> normals = new LinkedList();

        public PositionNormalEntry(Vector3 position) {
            this.pos = position;
        }

        public boolean positionEqual(Vector3 v) {
            return this.pos.x == v.x && this.pos.y == v.y && this.pos.z == v.z;
        }

        public PositionNormalEntry addNormal(Vector3 normal) {
            this.normals.add(normal);
            return this;
        }
    }
}

