/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Multiset;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLLog;

public class DimensionManager {
    private static boolean hasInit = false;
    private static final Int2ObjectMap<oo> worlds = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectLinkedOpenHashMap());
    private static final Int2ObjectMap<Dimension> dimensions = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectLinkedOpenHashMap());
    private static final IntSet keepLoaded = IntSets.synchronize((IntSet)new IntOpenHashSet());
    private static final IntSet unloadQueue = IntSets.synchronize((IntSet)new IntLinkedOpenHashSet());
    private static final BitSet dimensionMap = new BitSet(1024);
    private static final ConcurrentMap<amu, amu> weakWorldMap = new MapMaker().weakKeys().weakValues().makeMap();
    private static final Multiset<Integer> leakedWorlds = HashMultiset.create();

    public static int[] getDimensions(ayn type) {
        int[] ret = new int[dimensions.size()];
        int x = 0;
        for (Int2ObjectMap.Entry ent : dimensions.int2ObjectEntrySet()) {
            if (((Dimension)ent.getValue()).type != type) continue;
            ret[x++] = ent.getIntKey();
        }
        return Arrays.copyOf(ret, x);
    }

    public static Map<ayn, IntSortedSet> getRegisteredDimensions() {
        IdentityHashMap<ayn, IntSortedSet> map = new IdentityHashMap<ayn, IntSortedSet>();
        for (Int2ObjectMap.Entry entry : dimensions.int2ObjectEntrySet()) {
            map.computeIfAbsent(((Dimension)entry.getValue()).type, k -> new IntRBTreeSet()).add(entry.getIntKey());
        }
        return map;
    }

    public static void init() {
        if (hasInit) {
            return;
        }
        hasInit = true;
        DimensionManager.registerDimension(0, ayn.a);
        DimensionManager.registerDimension(-1, ayn.b);
        DimensionManager.registerDimension(1, ayn.c);
    }

    public static void registerDimension(int id, ayn type) {
        ayn.a((int)type.a());
        if (dimensions.containsKey(id)) {
            throw new IllegalArgumentException(String.format("Failed to register dimension for id %d, One is already registered", id));
        }
        dimensions.put(id, (Object)new Dimension(type));
        if (id >= 0) {
            dimensionMap.set(id);
        }
    }

    public static void unregisterDimension(int id) {
        if (!dimensions.containsKey(id)) {
            throw new IllegalArgumentException(String.format("Failed to unregister dimension for id %d; No provider registered", id));
        }
        dimensions.remove(id);
    }

    public static boolean isDimensionRegistered(int dim) {
        return dimensions.containsKey(dim);
    }

    public static ayn getProviderType(int dim) {
        if (!dimensions.containsKey(dim)) {
            throw new IllegalArgumentException(String.format("Could not get provider type for dimension %d, does not exist", dim));
        }
        return ((Dimension)dimensions.get(dim)).type;
    }

    public static aym getProvider(int dim) {
        return DimensionManager.getWorld((int)dim).s;
    }

    public static Integer[] getIDs(boolean check) {
        if (check) {
            ArrayList allWorlds = Lists.newArrayList(weakWorldMap.keySet());
            allWorlds.removeAll((Collection<?>)worlds.values());
            ListIterator li = allWorlds.listIterator();
            while (li.hasNext()) {
                amu w = (amu)li.next();
                leakedWorlds.add((Object)System.identityHashCode(w));
            }
            for (amu w : allWorlds) {
                int leakCount = leakedWorlds.count((Object)System.identityHashCode(w));
                if (leakCount == 5) {
                    FMLLog.log.debug("The world {} ({}) may have leaked: first encounter (5 occurrences).\n", (Object)Integer.toHexString(System.identityHashCode(w)), (Object)w.V().j());
                    continue;
                }
                if (leakCount % 5 != 0) continue;
                FMLLog.log.debug("The world {} ({}) may have leaked: seen {} times.\n", (Object)Integer.toHexString(System.identityHashCode(w)), (Object)w.V().j(), (Object)leakCount);
            }
        }
        return DimensionManager.getIDs();
    }

    public static Integer[] getIDs() {
        return (Integer[])worlds.keySet().toArray((Object[])new Integer[0]);
    }

    public static void setWorld(int id, @Nullable oo world, MinecraftServer server) {
        if (world != null) {
            worlds.put(id, (Object)world);
            weakWorldMap.put((amu)world, (amu)world);
            server.worldTickTimes.put(id, new long[100]);
            FMLLog.log.info("Loading dimension {} ({}) ({})", (Object)id, (Object)world.V().j(), (Object)world.u());
        } else {
            worlds.remove(id);
            server.worldTickTimes.remove(id);
            FMLLog.log.info("Unloading dimension {}", (Object)id);
        }
        ArrayList<Object> tmp = new ArrayList<Object>();
        if (worlds.get(0) != null) {
            tmp.add(worlds.get(0));
        }
        if (worlds.get(-1) != null) {
            tmp.add(worlds.get(-1));
        }
        if (worlds.get(1) != null) {
            tmp.add(worlds.get(1));
        }
        for (Int2ObjectMap.Entry entry : worlds.int2ObjectEntrySet()) {
            int dim = entry.getIntKey();
            if (dim >= -1 && dim <= 1) continue;
            tmp.add(entry.getValue());
        }
        server.d = tmp.toArray(new oo[0]);
    }

    public static void initDimension(int dim) {
        oo overworld = DimensionManager.getWorld(0);
        if (overworld == null) {
            throw new RuntimeException("Cannot Hotload Dim: Overworld is not Loaded!");
        }
        try {
            DimensionManager.getProviderType(dim);
        }
        catch (Exception e) {
            FMLLog.log.error("Cannot Hotload Dim: {}", (Object)dim, (Object)e);
            return;
        }
        MinecraftServer mcServer = overworld.u();
        bfe savehandler = overworld.U();
        oo world = dim == 0 ? overworld : (oo)new ok(mcServer, savehandler, dim, overworld, mcServer.c).b();
        world.a((amw)new op(mcServer, world));
        MinecraftForge.EVENT_BUS.post(new WorldEvent.Load((amu)world));
        if (!mcServer.R()) {
            world.V().a(mcServer.n());
        }
        mcServer.a(mcServer.o());
    }

    public static oo getWorld(int id) {
        return DimensionManager.getWorld(id, false);
    }

    public static oo getWorld(int id, boolean resetUnloadDelay) {
        if (resetUnloadDelay && unloadQueue.contains(id)) {
            ((Dimension)dimensions.get(id)).ticksWaited = 0;
        }
        return (oo)worlds.get(id);
    }

    public static oo[] getWorlds() {
        return (oo[])worlds.values().toArray((Object[])new oo[0]);
    }

    public static Integer[] getStaticDimensionIDs() {
        return (Integer[])dimensions.keySet().toArray((Object[])new Integer[0]);
    }

    public static aym createProviderFor(int dim) {
        try {
            if (dimensions.containsKey(dim)) {
                aym ret = DimensionManager.getProviderType(dim).d();
                ret.setDimension(dim);
                return ret;
            }
            throw new RuntimeException(String.format("No WorldProvider bound for dimension %d", dim));
        }
        catch (Exception e) {
            FMLLog.log.error("An error occurred trying to create an instance of WorldProvider {} ({})", (Object)dim, (Object)DimensionManager.getProviderType(dim), (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static boolean keepDimensionLoaded(int dim, boolean keep) {
        return keep ? keepLoaded.add(dim) : keepLoaded.remove(dim);
    }

    private static boolean canUnloadWorld(oo world) {
        return ForgeChunkManager.getPersistentChunksFor((amu)world).isEmpty() && world.i.isEmpty() && !world.s.q().shouldLoadSpawn() && !keepLoaded.contains(world.s.getDimension());
    }

    public static void unloadWorld(int id) {
        oo world = (oo)worlds.get(id);
        if (world == null || !DimensionManager.canUnloadWorld(world)) {
            return;
        }
        if (unloadQueue.add(id)) {
            FMLLog.log.debug("Queueing dimension {} to unload", (Object)id);
        }
    }

    public static boolean isWorldQueuedToUnload(int id) {
        return unloadQueue.contains(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unloadWorlds(Hashtable<Integer, long[]> worldTickTimes) {
        IntIterator queueIterator = unloadQueue.iterator();
        while (queueIterator.hasNext()) {
            int id = queueIterator.nextInt();
            Dimension dimension = (Dimension)dimensions.get(id);
            if (dimension.ticksWaited < ForgeModContainer.dimensionUnloadQueueDelay) {
                dimension.ticksWaited++;
                continue;
            }
            oo w = (oo)worlds.get(id);
            queueIterator.remove();
            dimension.ticksWaited = 0;
            if (w == null || !DimensionManager.canUnloadWorld(w)) {
                FMLLog.log.debug("Aborting unload for dimension {} as status changed", (Object)id);
                continue;
            }
            try {
                w.a(true, null);
            }
            catch (amv e) {
                FMLLog.log.error("Caught an exception while saving all chunks:", (Throwable)e);
            }
            finally {
                MinecraftForge.EVENT_BUS.post(new WorldEvent.Unload((amu)w));
                w.s();
                DimensionManager.setWorld(id, null, w.u());
            }
        }
    }

    public static int getNextFreeDimId() {
        int next = 0;
        while (dimensions.containsKey(next = dimensionMap.nextClearBit(next))) {
            dimensionMap.set(next);
        }
        return next;
    }

    public static fy saveDimensionDataMap() {
        int[] data = new int[(dimensionMap.length() + 32 - 1) / 32];
        fy dimMap = new fy();
        for (int i2 = 0; i2 < data.length; ++i2) {
            int val = 0;
            for (int j = 0; j < 32; ++j) {
                val |= dimensionMap.get(i2 * 32 + j) ? 1 << j : 0;
            }
            data[i2] = val;
        }
        dimMap.a("DimensionArray", data);
        return dimMap;
    }

    public static void loadDimensionDataMap(@Nullable fy compoundTag) {
        dimensionMap.clear();
        if (compoundTag == null) {
            IntIterator iterator = dimensions.keySet().iterator();
            while (iterator.hasNext()) {
                int id = iterator.nextInt();
                if (id < 0) continue;
                dimensionMap.set(id);
            }
        } else {
            int[] intArray = compoundTag.n("DimensionArray");
            for (int i2 = 0; i2 < intArray.length; ++i2) {
                for (int j = 0; j < 32; ++j) {
                    dimensionMap.set(i2 * 32 + j, (intArray[i2] & 1 << j) != 0);
                }
            }
        }
    }

    @Nullable
    public static File getCurrentSaveRootDirectory() {
        if (DimensionManager.getWorld(0) != null) {
            return DimensionManager.getWorld(0).U().b();
        }
        return null;
    }

    static {
        DimensionManager.init();
    }

    private static class Dimension {
        private final ayn type;
        private int ticksWaited;

        private Dimension(ayn type) {
            this.type = type;
            this.ticksWaited = 0;
        }
    }
}

