/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.tweaks;

import com.enderio.core.common.tweaks.Tweak;
import com.enderio.core.common.util.Log;
import com.enderio.core.common.util.NNList;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSlab;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class SlabRecipesAutomatic
extends Tweak {
    public static final SlabRecipesAutomatic INSTANCE = new SlabRecipesAutomatic();

    SlabRecipesAutomatic() {
        super("slabToBlockRecipesAutomatic", "Adds recipes to turn any two slabs back into a full block by scanning existing recipes and guessing a lot");
    }

    @Override
    public void load() {
        SlabRecipesAutomatic.registerSlabToBlock();
    }

    @Override
    public boolean enabledByDefault() {
        return false;
    }

    private static void registerSlabToBlock() {
        block0: for (IRecipe recipe : ForgeRegistries.RECIPES) {
            ItemStack outputItem = recipe.func_77571_b();
            ResourceLocation outputItemName = outputItem.func_77973_b().getRegistryName();
            if (!(outputItem.func_77973_b() instanceof ItemSlab) && !(Block.func_149634_a((Item)outputItem.func_77973_b()) instanceof BlockSlab) || outputItemName == null || "minecraft".equals(outputItemName.func_110624_b())) continue;
            if (outputItem.func_190916_E() != 6) {
                Log.info("Rejected anti-slab recipe for " + outputItem.func_77946_l() + " because output size is not 6");
                continue;
            }
            NNList<ItemStack> stacks = new NNList<ItemStack>();
            for (Ingredient ingredient : recipe.func_192400_c()) {
                stacks.addAll(ingredient.func_193365_a());
            }
            ItemStack input = null;
            int count = 0;
            Iterator iterator = stacks.iterator();
            while (iterator.hasNext()) {
                ItemStack stack = (ItemStack)iterator.next();
                if (stack == null || stack.func_190926_b()) continue;
                if (input == null) {
                    input = stack;
                    ++count;
                    continue;
                }
                if (input.func_77973_b() == stack.func_77973_b() && input.func_77952_i() == stack.func_77952_i()) {
                    ++count;
                    continue;
                }
                Log.info("Rejected anti-slab recipe for " + outputItem.func_77946_l() + " because " + input + " is not " + stack);
                continue block0;
            }
            if (input != null && count == 3) {
                Ingredient ingredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{outputItem.func_77946_l().func_77979_a(1)});
                ResourceLocation inputItemName = input.func_77973_b().getRegistryName();
                ForgeRegistries.RECIPES.register(new ShapelessRecipes("", input, new NNList<Ingredient>(ingredient, ingredient)).setRegistryName(outputItemName.func_110623_a() + "_" + outputItem.func_77952_i() + "_to_" + (inputItemName != null ? inputItemName.func_110623_a() : "no_idea")));
                Log.info("Added anti-slab recipe for " + outputItem + " back to " + input);
                continue;
            }
            if (input == null) continue;
            Log.info("Rejected anti-slab recipe for " + outputItem + " back to " + input + " because count is " + count);
        }
    }
}

