/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.item;

import com.mojang.realmsclient.gui.ChatFormatting;
import de.eydamos.backpack.helper.BackpackHelper;
import de.eydamos.backpack.helper.GuiHelper;
import de.eydamos.backpack.init.BackpackItems;
import de.eydamos.backpack.init.Configurations;
import de.eydamos.backpack.item.EBackpack;
import de.eydamos.backpack.misc.Constants;
import de.eydamos.backpack.tier.TierFrame;
import de.eydamos.backpack.tier.TierLeather;
import de.eydamos.backpack.util.GeneralUtil;
import de.eydamos.backpack.util.NBTItemStackUtil;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ItemBackpack
extends Item {
    public ItemBackpack() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77637_a(Constants.tabBackpacks);
        this.setRegistryName("backpack");
        this.func_77655_b("backpack");
    }

    @SideOnly(value=Side.CLIENT)
    @ParametersAreNonnullByDefault
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (EBackpack backpack : EBackpack.values()) {
            if (!backpack.isEnabled()) continue;
            subItems.add((Object)new ItemStack(BackpackItems.backpack, 1, backpack.getDamage()));
        }
    }

    @MethodsReturnNonnullByDefault
    public String func_77667_c(ItemStack itemStack) {
        String name = super.func_77667_c(itemStack);
        name = name + '_' + EBackpack.getIdentifierByDamage(itemStack.func_77952_i());
        return name;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        TierFrame.addTooltip(itemStack, tooltip);
        TierLeather.addTooltip(itemStack, tooltip);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            String label = ChatFormatting.BLUE + I18n.func_135052_a((String)"tooltip.slots_used", (Object[])new Object[0]);
            String value = ChatFormatting.YELLOW.toString();
            value = value + BackpackHelper.getSlotsUsed(itemStack);
            value = value + " / ";
            value = value + BackpackHelper.getSlots(itemStack);
            value = value + ChatFormatting.RESET;
            tooltip.add(label.trim() + ' ' + value);
        } else {
            tooltip.add(I18n.func_135052_a((String)"tooltip.more_information", (Object[])new Object[0]));
        }
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!NBTItemStackUtil.hasTag(itemStack, "backpack-UID")) {
            if (player.field_71075_bZ.field_75098_d) {
                // empty if block
            }
            return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
        }
        if (!GeneralUtil.isServerSide(world)) {
            if (player.func_70093_af()) {
                GuiHelper.displayRenameGui(player);
            }
            return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
        }
        if (!player.func_70093_af() && !Configurations.OPEN_ONLY_EQUIPPED_BACKPACK) {
            GuiHelper.displayBackpack(player);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
    }
}

