/*
 * Decompiled with CFR 0.152.
 */
package com.raden93.veganlife.init;

import com.raden93.veganlife.init.VeganLifeBlocks;
import com.raden93.veganlife.init.VeganLifeItems;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;

public class VeganLifeOreDicts {
    public static void init() {
        OreDictionary.registerOre((String)"rosin", (Item)VeganLifeItems.rosin_item);
        OreDictionary.registerOre((String)"materialRosin", (Item)VeganLifeItems.rosin_item);
        OreDictionary.registerOre((String)"sheetPlastic", (Item)VeganLifeItems.bioplastic_item);
        OreDictionary.registerOre((String)"stickPlastic", (Item)VeganLifeItems.plastic_rod_item);
        OreDictionary.registerOre((String)"dyeWhite", (ItemStack)new ItemStack((Item)VeganLifeItems.vegetable_oil_ink_item, 1, 1));
        OreDictionary.registerOre((String)"dyeBlack", (ItemStack)new ItemStack((Item)VeganLifeItems.vegetable_oil_ink_item, 1, 0));
        OreDictionary.registerOre((String)"dustSulfur", (ItemStack)new ItemStack((Item)VeganLifeItems.sulfur_item));
        OreDictionary.registerOre((String)"dustSulphur", (ItemStack)new ItemStack((Item)VeganLifeItems.sulfur_item));
        OreDictionary.registerOre((String)"dustSaltpeter", (ItemStack)new ItemStack((Item)VeganLifeItems.saltpeter_item));
        OreDictionary.registerOre((String)"dustNiter", (ItemStack)new ItemStack((Item)VeganLifeItems.saltpeter_item));
        OreDictionary.registerOre((String)"dustNitre", (ItemStack)new ItemStack((Item)VeganLifeItems.saltpeter_item));
        OreDictionary.registerOre((String)"cropSunflower", (ItemStack)new ItemStack((Item)VeganLifeItems.sunflower_seeds_item));
        OreDictionary.registerOre((String)"itemWax", (ItemStack)new ItemStack((Item)VeganLifeItems.vegetable_wax_item));
        OreDictionary.registerOre((String)"leather", (Item)VeganLifeItems.burlap_item);
        OreDictionary.registerOre((String)"slimeball", (ItemStack)new ItemStack((Item)VeganLifeItems.resin_item));
        OreDictionary.registerOre((String)"feather", (Item)VeganLifeItems.faux_feather_item);
        OreDictionary.registerOre((String)"spiderEye", (ItemStack)new ItemStack(Items.field_151070_bp));
        OreDictionary.registerOre((String)"spiderEye", (ItemStack)new ItemStack((Item)VeganLifeItems.dolls_eye_item));
        OreDictionary.registerOre((String)"spiderEye", (ItemStack)new ItemStack((Item)VeganLifeItems.flase_morel_item));
        OreDictionary.registerOre((String)"ghastTear", (ItemStack)new ItemStack(Items.field_151073_bk));
        OreDictionary.registerOre((String)"ghastTear", (ItemStack)new ItemStack((Item)VeganLifeItems.proof_of_suffering_item));
        OreDictionary.registerOre((String)"rabbitFoot", (ItemStack)new ItemStack(Items.field_179556_br));
        OreDictionary.registerOre((String)"rabbitFoot", (ItemStack)new ItemStack((Item)VeganLifeItems.faux_rabbit_foot_item));
        VeganLifeOreDicts.registerOreDicsWoolForKapok();
        OreDictionary.registerOre((String)"cropJute", (ItemStack)new ItemStack((Item)VeganLifeItems.jute_stalk_item));
        OreDictionary.registerOre((String)"foodOliveoil", (ItemStack)new ItemStack((Item)VeganLifeItems.vegetable_oil_item));
        OreDictionary.registerOre((String)"globRosin", (ItemStack)new ItemStack((Item)VeganLifeItems.rosin_item));
        VeganLifeOreDicts.changeVanillaRecips();
    }

    private static void registerOreDicsWoolForKapok() {
        String[] oreDicNames = new String[]{"woolWhite", "woolOrange", "woolMagenta", "woolLight_blue", "woolYellow", "woolLime", "woolPink", "woolGray", "woolSilver", "woolCyan", "woolPurple", "woolBlue", "woolBrown", "woolGreen", "woolRed", "woolBlack"};
        for (int i = 0; i <= 15; ++i) {
            OreDictionary.registerOre((String)"wool", (ItemStack)new ItemStack((Block)VeganLifeBlocks.kapok_block, 1, i));
            OreDictionary.registerOre((String)"wool", (ItemStack)new ItemStack(Blocks.field_150325_L, 1, i));
            OreDictionary.registerOre((String)oreDicNames[i], (ItemStack)new ItemStack((Block)VeganLifeBlocks.kapok_block, 1, i));
            OreDictionary.registerOre((String)oreDicNames[i], (ItemStack)new ItemStack(Blocks.field_150325_L, 1, i));
        }
    }

    private static void changeVanillaRecips() {
        HashMap<ItemStack, String> replacements = new HashMap<ItemStack, String>();
        HashMap<ItemStack, String> parent = new HashMap<ItemStack, String>();
        replacements.put(new ItemStack(Items.field_151070_bp), "spiderEye");
        replacements.put(new ItemStack(Items.field_151073_bk), "ghastTear");
        replacements.put(new ItemStack(Items.field_179556_br), "rabbitFoot");
        for (EnumDyeColor color : EnumDyeColor.values()) {
            ItemStack woolDye = new ItemStack(Blocks.field_150325_L, 1, color.func_176765_a());
            replacements.put(woolDye, "wool" + color.func_176610_l().substring(0, 1).toUpperCase() + color.func_176610_l().substring(1));
            parent.put(woolDye, "wool");
        }
        ItemStack[] exclusions = new ItemStack[]{};
        FMLLog.log.info("Starts to replace vanilla recipe ingredients with ore ingredients.");
        int replaced = 0;
        for (IRecipe obj : CraftingManager.field_193380_a) {
            ItemStack output;
            String name = obj.getRegistryName().toString();
            if (obj.getClass() != ShapedRecipes.class && obj.getClass() != ShapelessRecipes.class || name.contains("wool") || !(output = obj.func_77571_b()).func_190926_b() && VeganLifeOreDicts.containsMatch(false, new ItemStack[]{output}, exclusions)) continue;
            NonNullList lst = obj.func_192400_c();
            for (int x = 0; x < lst.size(); ++x) {
                Ingredient ing = (Ingredient)lst.get(x);
                ItemStack[] ingredients = ing.func_193365_a();
                String oreName = null;
                boolean skip = false;
                for (ItemStack stack : ingredients) {
                    boolean matches = false;
                    for (Map.Entry ent : replacements.entrySet()) {
                        if (!OreDictionary.itemMatches((ItemStack)((ItemStack)ent.getKey()), (ItemStack)stack, (boolean)true)) continue;
                        matches = true;
                        if (oreName != null && !oreName.equals(ent.getValue())) {
                            String parentValue = (String)parent.get(ent.getKey());
                            if (parentValue != null && !parentValue.equals("")) {
                                oreName = parentValue;
                                continue;
                            }
                            FMLLog.log.info("Invalid recipe \"" + name + "\" found with multiple oredict ingredients in the same ingredient... ");
                            skip = true;
                            break;
                        }
                        if (oreName != null) continue;
                        oreName = (String)ent.getValue();
                        break;
                    }
                    if (!matches && oreName != null) {
                        skip = true;
                    }
                    if (skip) break;
                }
                if (skip || oreName == null) continue;
                lst.set(x, (Object)new OreIngredient(oreName));
                ++replaced;
            }
        }
        FMLLog.log.info("Replaced {} ore ingredients", (Object)replaced);
    }

    private static boolean containsMatch(boolean strict, ItemStack[] inputs, ItemStack ... targets) {
        for (ItemStack input : inputs) {
            for (ItemStack target : targets) {
                if (!OreDictionary.itemMatches((ItemStack)target, (ItemStack)input, (boolean)strict)) continue;
                return true;
            }
        }
        return false;
    }
}

