/*
 * Decompiled with CFR 0.152.
 */
package com.raden93.veganlife.init;

import com.raden93.veganlife.config.VeganConfig;
import com.raden93.veganlife.init.VeganLifeItems;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class VeganLifeDropChanger {
    private HashMap<Item, ItemStack> newDropsPerBlock = new HashMap();
    private HashMap<ItemStack, Double> dropRatePerItem = new HashMap();
    private HashMap<ItemStack, Integer> dropsPerItem = new HashMap();
    public static final double KAPOK_TUFT_DROP_RATE = VeganConfig.OTHER_CONSTANTS.DROPCHANCE_KAPOK_FROM_JUNGLE;
    public static final double RESIN_DROP_RATE = VeganConfig.OTHER_CONSTANTS.DROPCHANCE_RESIN_FROM_SPRUCE;
    public static final double SULFUR_DROP_RATE = VeganConfig.OTHER_CONSTANTS.DROPCHANCE_SULFUR_FROM_NEATHERRACK;
    public static final double SALTPETER_DROP_RATE = VeganConfig.OTHER_CONSTANTS.DROPCHANCE_SALTPETER_FROM_SANDSTONE;
    public static final double BONES_DROP_RATE = VeganConfig.OTHER_CONSTANTS.DROPCHANCE_BONE_FROM_STONE;
    public static final double FRAGMENT_OF_SUFFERING_DROP_RATE = VeganConfig.OTHER_CONSTANTS.DROPCHANCE_FRAGMENT_FROM_SOULSAND;
    public static final double FALSE_MOREL_DROP_RATE = VeganConfig.OTHER_CONSTANTS.DROPCHANCE_FALSE_MOREL_FROM_MYCELIUM;
    public static final double DOLLS_EYE_DROP_RATE = VeganConfig.OTHER_CONSTANTS.DROPCHANCE_DOLLS_EYE_FROM_GRAS;

    public VeganLifeDropChanger() {
        this.addNewDrops(new ItemStack((Item)VeganLifeItems.sulfur_item), new ItemStack(Blocks.field_150424_aL), SULFUR_DROP_RATE, 1);
        this.addNewDrops(new ItemStack((Item)VeganLifeItems.saltpeter_item), new ItemStack(Blocks.field_150322_A), SALTPETER_DROP_RATE, 1);
        this.addNewDrops(new ItemStack((Item)VeganLifeItems.fragment_of_suffering_item), new ItemStack(Blocks.field_150425_aM), FRAGMENT_OF_SUFFERING_DROP_RATE, 2);
        this.addNewDrops(new ItemStack((Item)VeganLifeItems.flase_morel_item), new ItemStack((Block)Blocks.field_150391_bh), FALSE_MOREL_DROP_RATE, 1);
    }

    private void addNewDrops(ItemStack newDrop, ItemStack dropsFrom, double dropRate, int dropsRange) {
        this.newDropsPerBlock.put(dropsFrom.func_77973_b(), newDrop);
        this.dropRatePerItem.put(newDrop, dropRate);
        this.dropsPerItem.put(newDrop, dropsRange);
    }

    @SubscribeEvent
    public void onHarvestBlock(BlockEvent.HarvestDropsEvent event) {
        IBlockState state = event.getState();
        Block block = state.func_177230_c();
        Random random = new Random();
        List drops = event.getDrops();
        if (!this.userUseShears(event)) {
            this.dropJuteFromFerns(block, state, random, drops);
            this.dropKapokFromJungle(block, state, random, drops);
            this.dropsSunflowerSeedsFromSunflowsers(block, state, random, drops);
        }
        this.dropsResinFromSpruceWood(block, state, random, drops);
        this.dropsBonesFromStone(block, state, random, drops);
        this.dropsDollsEyeFromGras(event.getWorld(), event.getPos(), block, state, random, drops);
        this.addDropForItem(block, random, drops);
    }

    private void dropJuteFromFerns(Block block, IBlockState state, Random random, List<ItemStack> drops) {
        if (block == Blocks.field_150398_cm && state.func_177229_b((IProperty)BlockDoublePlant.field_176493_a) == BlockDoublePlant.EnumPlantType.FERN) {
            int randomValue = VeganConfig.JUTE_CONSTANTS.JUTE_STALK_RANDOM_DROPS > 0 ? random.nextInt(VeganConfig.JUTE_CONSTANTS.JUTE_STALK_RANDOM_DROPS) : 0;
            drops.add(new ItemStack((Item)VeganLifeItems.jute_stalk_item, randomValue + VeganConfig.JUTE_CONSTANTS.JUTE_STALK_BASE_DROPS));
        }
    }

    private void dropKapokFromJungle(Block block, IBlockState state, Random random, List<ItemStack> drops) {
        if (block == Blocks.field_150362_t && state.func_177229_b((IProperty)BlockOldLeaf.field_176239_P) == BlockPlanks.EnumType.JUNGLE && random.nextDouble() < KAPOK_TUFT_DROP_RATE) {
            drops.add(new ItemStack((Item)VeganLifeItems.kapok_tuft_item, 1));
        }
    }

    private void dropsResinFromSpruceWood(Block block, IBlockState state, Random random, List<ItemStack> drops) {
        if (block == Blocks.field_150364_r && state.func_177229_b((IProperty)BlockOldLog.field_176301_b) == BlockPlanks.EnumType.SPRUCE && random.nextDouble() < RESIN_DROP_RATE) {
            drops.add(new ItemStack((Item)VeganLifeItems.resin_item));
        }
    }

    private void dropsBonesFromStone(Block block, IBlockState state, Random random, List<ItemStack> drops) {
        if (block == Blocks.field_150348_b && state.func_177229_b((IProperty)BlockStone.field_176247_a) == BlockStone.EnumType.STONE && random.nextDouble() < BONES_DROP_RATE) {
            drops.add(new ItemStack(Items.field_151103_aS));
        }
    }

    private void addDropForItem(Block block, Random random, List<ItemStack> drops) {
        ItemStack dropedItem = this.newDropsPerBlock.get(new ItemStack(block).func_77973_b());
        if (dropedItem != null && random.nextDouble() < this.dropRatePerItem.get(dropedItem)) {
            dropedItem.func_190920_e(random.nextInt(this.dropsPerItem.get(dropedItem)) + 1);
            drops.add(dropedItem);
        }
    }

    private void dropsDollsEyeFromGras(World world, BlockPos pos, Block block, IBlockState state, Random random, List<ItemStack> drops) {
        Biome biome;
        if (block.equals(Blocks.field_150329_H) && state.func_177229_b((IProperty)BlockTallGrass.field_176497_a) == BlockTallGrass.EnumType.GRASS && BiomeDictionary.hasType((Biome)(biome = world.func_180494_b(pos)), (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS) && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE) && random.nextDouble() < DOLLS_EYE_DROP_RATE) {
            drops.add(new ItemStack((Item)VeganLifeItems.dolls_eye_item, 1));
        }
    }

    private void dropsSunflowerSeedsFromSunflowsers(Block block, IBlockState state, Random random, List<ItemStack> drops) {
        if (block == Blocks.field_150398_cm && state.func_177229_b((IProperty)BlockDoublePlant.field_176493_a) == BlockDoublePlant.EnumPlantType.SUNFLOWER) {
            drops.add(new ItemStack((Item)VeganLifeItems.sunflower_seeds_item, 1));
        }
    }

    private boolean userUseShears(BlockEvent.HarvestDropsEvent event) {
        return event.getHarvester() != null && event.getHarvester().func_184614_ca() != null && event.getHarvester().func_184614_ca().func_77973_b() instanceof ItemShears;
    }
}

