/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.api.enums.BOPGems;
import biomesoplenty.api.enums.BOPPlants;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.common.biome.BOPBiome;
import biomesoplenty.common.biome.overworld.BOPOverworldBiome;
import biomesoplenty.common.world.generator.GeneratorDoubleFlora;
import biomesoplenty.common.world.generator.GeneratorFlora;
import biomesoplenty.common.world.generator.GeneratorGrass;
import biomesoplenty.common.world.generator.GeneratorOreSingle;
import biomesoplenty.common.world.generator.GeneratorWeighted;
import biomesoplenty.common.world.generator.tree.GeneratorBigTree;
import biomesoplenty.common.world.generator.tree.GeneratorBush;
import biomesoplenty.common.world.generator.tree.GeneratorRedwoodTree;
import com.google.common.base.CaseFormat;
import java.util.Random;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public class BiomeGenRedwoodForest
extends BOPOverworldBiome {
    public IBlockState usualTopBlock;
    public IBlockState alternateTopBlock;
    public ForestType type;

    public BiomeGenRedwoodForest(ForestType type) {
        super(type.name().toLowerCase(), new BOPBiome.PropsBuilder(CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, type.toString())).withGuiColour(7187004).withTemperature(Float.valueOf(0.7f)).withRainfall(Float.valueOf(0.7f)));
        GeneratorWeighted treeGenerator;
        this.type = type;
        this.terrainSettings.avgHeight(70.0).heightVariation(4.0, 10.0);
        this.usualTopBlock = this.field_76752_A = Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL);
        this.alternateTopBlock = this.field_76752_A;
        this.canSpawnInBiome = false;
        this.canGenerateVillages = false;
        this.canGenerateRivers = false;
        if (type == ForestType.REDWOOD_FOREST) {
            this.addWeight(BOPClimates.WARM_TEMPERATE, 7);
            treeGenerator = new GeneratorWeighted(15.0f);
            this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
            treeGenerator.add("redwood", 6, ((GeneratorRedwoodTree.Builder)((GeneratorRedwoodTree.Builder)((GeneratorRedwoodTree.Builder)((GeneratorRedwoodTree.Builder)new GeneratorRedwoodTree.Builder().log(BOPWoods.REDWOOD)).leaves(BOPTrees.REDWOOD)).minHeight(45)).maxHeight(60)).trunkWidth(3).create());
            treeGenerator.add("redwood_medium", 4, ((GeneratorRedwoodTree.Builder)((GeneratorRedwoodTree.Builder)((GeneratorRedwoodTree.Builder)((GeneratorRedwoodTree.Builder)new GeneratorRedwoodTree.Builder().log(BOPWoods.REDWOOD)).leaves(BOPTrees.REDWOOD)).minHeight(25)).maxHeight(40)).trunkWidth(2).create());
            treeGenerator.add("redwood_small", 2, ((GeneratorRedwoodTree.Builder)((GeneratorRedwoodTree.Builder)((GeneratorRedwoodTree.Builder)((GeneratorRedwoodTree.Builder)new GeneratorRedwoodTree.Builder().log(BOPWoods.REDWOOD)).leaves(BOPTrees.REDWOOD)).minHeight(10)).maxHeight(30)).trunkWidth(1).create());
            treeGenerator.add("oak_bush", 1, ((GeneratorBush.Builder)((GeneratorBush.Builder)new GeneratorBush.Builder().amountPerChunk(3.0f)).maxHeight(2)).create());
            treeGenerator.add("oak_tree", 1, ((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)new GeneratorBigTree.Builder().amountPerChunk(1.0f)).minHeight(4)).maxHeight(10)).foliageHeight(1).create());
            this.addGenerator("double_fern", GeneratorStage.FLOWERS, ((GeneratorDoubleFlora.Builder)new GeneratorDoubleFlora.Builder().amountPerChunk(5.0f)).with(BlockDoublePlant.EnumPlantType.FERN).create());
        }
        if (type == ForestType.REDWOOD_FOREST_EDGE) {
            this.hasBiomeEssence = false;
            this.alternateTopBlock = Blocks.field_150349_c.func_176223_P();
            treeGenerator = new GeneratorWeighted(8.0f);
            this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
            treeGenerator.add("redwood_small", 6, ((GeneratorRedwoodTree.Builder)((GeneratorRedwoodTree.Builder)((GeneratorRedwoodTree.Builder)((GeneratorRedwoodTree.Builder)new GeneratorRedwoodTree.Builder().log(BOPWoods.REDWOOD)).leaves(BOPTrees.REDWOOD)).minHeight(10)).maxHeight(30)).trunkWidth(1).create());
            treeGenerator.add("redwood_medium", 1, ((GeneratorRedwoodTree.Builder)((GeneratorRedwoodTree.Builder)((GeneratorRedwoodTree.Builder)((GeneratorRedwoodTree.Builder)new GeneratorRedwoodTree.Builder().log(BOPWoods.REDWOOD)).leaves(BOPTrees.REDWOOD)).minHeight(25)).maxHeight(40)).trunkWidth(2).create());
            treeGenerator.add("oak_bush", 2, ((GeneratorBush.Builder)((GeneratorBush.Builder)new GeneratorBush.Builder().amountPerChunk(3.0f)).maxHeight(2)).create());
            treeGenerator.add("oak_tree", 1, ((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)new GeneratorBigTree.Builder().amountPerChunk(1.0f)).minHeight(4)).maxHeight(10)).foliageHeight(1).create());
        }
        this.addGenerator("dead_leaf_piles", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.1f)).placeOn(BlockQueries.fertile)).with(BOPPlants.DEADLEAFPILE)).create());
        this.addGenerator("leaf_piles", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.2f)).placeOn(BlockQueries.fertile)).with(BOPPlants.LEAFPILE)).generationAttempts(64)).create());
        this.addGenerator("sprouts", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.25f)).with(BOPPlants.SPROUT)).create());
        this.addGenerator("brown_mushrooms", GeneratorStage.SHROOM, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.2f)).generationAttempts(16)).with(Blocks.field_150338_P.func_176223_P())).create());
        this.addGenerator("red_mushrooms", GeneratorStage.SHROOM, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.1f)).generationAttempts(16)).with(Blocks.field_150337_Q.func_176223_P())).create());
        GeneratorWeighted grassGenerator = new GeneratorWeighted(4.0f);
        this.addGenerator("grass", GeneratorStage.GRASS, grassGenerator);
        grassGenerator.add("fern", 8, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BlockTallGrass.EnumType.FERN)).create());
        grassGenerator.add("tallgrass", 2, ((GeneratorGrass.Builder)((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BlockTallGrass.EnumType.GRASS)).generationAttempts(128)).create());
        this.addGenerator("amber", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(BOPGems.AMBER)).create());
    }

    @Override
    public void configure(IConfigObj conf) {
        super.configure(conf);
        this.usualTopBlock = this.field_76752_A;
        this.alternateTopBlock = conf.getBlockState("alternateTopBlock", this.alternateTopBlock);
    }

    @Override
    public void func_180622_a(World world, Random rand, ChunkPrimer primer, int x, int z, double noise) {
        this.field_76752_A = noise + rand.nextDouble() * 3.0 > 1.5 ? this.alternateTopBlock : this.usualTopBlock;
        super.func_180622_a(world, rand, primer, x, z, noise);
    }

    public static enum ForestType {
        REDWOOD_FOREST,
        REDWOOD_FOREST_EDGE;

    }
}

