/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.autoplant;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod(modid="autoplant", version="1.12-1.0.0", name="AutoPlant", acceptedMinecraftVersions="[1.12]")
public class AutoPlant {
    public static final String MODID = "autoplant";
    public static final String VERSION = "1.12-1.0.0";
    public static final String NAME = "AutoPlant";
    public static int despawntime;
    public static String[] blockBlackList;
    private static String[] defaultBlackList;
    private static int chanceToPlant;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        despawntime = config.getInt("despawnTime", "general", 1000, 0, Integer.MAX_VALUE, "How long a plant should take to despawn (and attempt to plant) Default Minecraft is 6000");
        blockBlackList = config.getStringList("blacklist", "general", defaultBlackList, "blocks that should not be placed");
        chanceToPlant = config.getInt("chanceToPlant", "general", 100, 0, 100, "Percentage chance to plant");
        config.save();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void itemDecay(ItemExpireEvent event) {
        this.plant(event.getEntityItem());
    }

    @SubscribeEvent
    public void itemToss(ItemTossEvent event) {
        if (this.getPlantable(event.getEntityItem().func_92059_d()) != null && !this.isStackBlacklisted(event.getEntityItem().func_92059_d())) {
            event.getEntityItem().lifespan = despawntime;
        }
    }

    public void plant(EntityItem entityItem) {
        this.plant(entityItem.func_92059_d(), entityItem.func_180425_c(), entityItem.field_70170_p);
    }

    public void plant(ItemStack stack, BlockPos plantPosition, World world) {
        IBlockState state;
        IPlantable plantable = this.getPlantable(stack);
        if (plantable != null && this.canPlace(state = this.getPlant(stack, world, plantPosition), plantPosition, world, plantable)) {
            world.func_175656_a(plantPosition, state);
            state.func_177230_c().func_180633_a(world, plantPosition, state, null, stack);
        }
    }

    public boolean canPlace(IBlockState state, BlockPos pos, World world, IPlantable plantable) {
        boolean flag1 = true;
        boolean flag2 = state.func_177230_c().func_176196_c(world, pos);
        boolean flag3 = world.func_175623_d(pos);
        boolean flag4 = !this.isBlockBlacklisted(state.func_177230_c());
        boolean flag5 = chanceToPlant == 100 || world.field_73012_v.nextInt(100) <= chanceToPlant;
        return flag1 && flag2 && flag3 && flag4 && flag5;
    }

    public IBlockState getPlant(ItemStack stack, World world, BlockPos pos) {
        if (stack.func_77973_b() instanceof ItemBlock) {
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            return block.func_176203_a(stack.func_77973_b().getMetadata(stack));
        }
        if (stack.func_77973_b() instanceof IPlantable) {
            IPlantable plantable = (IPlantable)stack.func_77973_b();
            return plantable.getPlant((IBlockAccess)world, pos);
        }
        return null;
    }

    @Nullable
    public IPlantable getPlantable(ItemStack stack) {
        Block blk;
        Item item = stack.func_77973_b();
        IPlantable plantable = null;
        if (item instanceof ItemBlock && this.isPlantableBlock(blk = Block.func_149634_a((Item)item))) {
            plantable = (IPlantable)blk;
        }
        if (item instanceof IPlantable) {
            plantable = (IPlantable)item;
        }
        return plantable;
    }

    public boolean isPlantableBlock(Block block) {
        return block instanceof IPlantable;
    }

    public boolean isStackBlacklisted(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemBlock) {
            return this.isBlockBlacklisted(Block.func_149634_a((Item)stack.func_77973_b()));
        }
        return false;
    }

    public boolean isBlockBlacklisted(Block block) {
        for (String id : blockBlackList) {
            if (!id.equalsIgnoreCase(block.getRegistryName().toString())) continue;
            return true;
        }
        return false;
    }

    static {
        defaultBlackList = new String[]{"minecraft:waterlily", "minecraft:vine"};
    }
}

