/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.transceiver;

import com.enderio.core.common.fluid.FluidWrapper;
import com.enderio.core.common.fluid.IFluidWrapper;
import com.enderio.core.common.util.FluidUtil;
import crazypants.enderio.base.machine.baselegacy.AbstractPoweredTaskEntity;
import crazypants.enderio.base.machine.baselegacy.SlotDefinition;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.base.machine.task.ContinuousTask;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.power.PowerDistributor;
import crazypants.enderio.base.transceiver.Channel;
import crazypants.enderio.base.transceiver.ChannelList;
import crazypants.enderio.base.transceiver.ChannelType;
import crazypants.enderio.base.transceiver.IChanneledMachine;
import crazypants.enderio.base.transceiver.ServerChannelRegister;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.machine.transceiver.PacketSendRecieveChannelList;
import crazypants.enderio.machines.machine.transceiver.TransceiverRegistry;
import crazypants.enderio.machines.network.PacketHandler;
import crazypants.enderio.util.Prep;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileTransceiver
extends AbstractPoweredTaskEntity
implements IPaintable.IPaintableTileEntity,
IChanneledMachine {
    private static final float MIN_POWER_TO_SEND = 0.5f;
    @Store
    private final ChannelList sendChannels = new ChannelList();
    @Store
    private final ChannelList recieveChannels = new ChannelList();
    private boolean sendChannelsDirty = false;
    private boolean recieveChannelsDirty = false;
    private boolean registered = false;
    private EnumMap<EnumFacing, IFluidHandler> neighbourFluidHandlers = null;
    private PowerDistributor powerDistributor;
    private boolean inFluidFill = false;
    private boolean inGetTankInfo = false;
    @Store
    private boolean bufferStacks = true;

    public TileTransceiver() {
        super(new SlotDefinition(8, 8, 1), CapacitorKey.TRANSCEIVER_POWER_INTAKE, CapacitorKey.TRANSCEIVER_POWER_BUFFER, CapacitorKey.TRANSCEIVER_POWER_USE);
        this.currentTask = new ContinuousTask(this.getPowerUsePerTick());
        this.addICap(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facingIn -> new FluidCap((EnumFacing)facingIn));
    }

    public boolean isRedstoneChecksPassed() {
        return this.redstoneCheckPassed;
    }

    @Override
    protected boolean processTasks(boolean redstoneChecksPassed) {
        boolean res = super.processTasks(redstoneChecksPassed);
        if (!redstoneChecksPassed) {
            return res;
        }
        this.processPower();
        this.processItems();
        return res;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @Override
    public void doUpdate() {
        if (!this.registered && !this.field_145850_b.field_72995_K) {
            TransceiverRegistry.INSTANCE.register(this);
            this.registered = true;
            this.removeUnregsiteredChannels(this.sendChannels);
            this.removeUnregsiteredChannels(this.recieveChannels);
        }
        super.doUpdate();
        if (!this.field_145850_b.field_72995_K) {
            if (this.sendChannelsDirty) {
                PacketHandler.sendToAllAround((IMessage)new PacketSendRecieveChannelList(this, true), (TileEntity)this);
                this.sendChannelsDirty = false;
            }
            if (this.recieveChannelsDirty) {
                PacketHandler.sendToAllAround((IMessage)new PacketSendRecieveChannelList(this, false), (TileEntity)this);
                this.recieveChannelsDirty = false;
            }
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.registered && !this.field_145850_b.field_72995_K) {
            TransceiverRegistry.INSTANCE.dergister(this);
            this.registered = false;
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.registered && !this.field_145850_b.field_72995_K) {
            TransceiverRegistry.INSTANCE.dergister(this);
            this.registered = false;
        }
    }

    private void removeUnregsiteredChannels(ChannelList chans) {
        ArrayList<Channel> toRemove = new ArrayList<Channel>();
        for (Set set : chans.values()) {
            for (Channel channel : set) {
                if (ServerChannelRegister.instance.getChannelsForType(channel.getType()).contains(channel)) continue;
                toRemove.add(channel);
            }
        }
        for (Channel channel : toRemove) {
            this.removeChannel(channel, chans);
        }
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return "transceiver";
    }

    @Override
    public boolean isActive() {
        return this.hasPower();
    }

    @Override
    @Nonnull
    public Set<Channel> getSendChannels(@Nonnull ChannelType type) {
        return (Set)this.sendChannels.get((Object)type);
    }

    @Override
    @Nonnull
    public Set<Channel> getRecieveChannels(@Nonnull ChannelType type) {
        return (Set)this.recieveChannels.get((Object)type);
    }

    public void addSendChanel(Channel channel) {
        this.addChannel(channel, this.sendChannels);
    }

    public void addRecieveChanel(Channel channel) {
        this.addChannel(channel, this.recieveChannels);
    }

    public void removeSendChanel(Channel channel) {
        this.removeChannel(channel, this.sendChannels);
    }

    public void removeRecieveChanel(Channel channel) {
        this.removeChannel(channel, this.recieveChannels);
    }

    private void addChannel(Channel channel, ChannelList channels) {
        if (channels.add(channel)) {
            if (channels == this.sendChannels) {
                this.sendChannelsDirty = true;
            } else {
                this.recieveChannelsDirty = true;
            }
        }
    }

    private void removeChannel(Channel channel, ChannelList channnels) {
        if (channel == null) {
            return;
        }
        Set chans = (Set)channnels.get((Object)channel.getType());
        if (chans.remove(channel)) {
            if (channnels == this.sendChannels) {
                this.sendChannelsDirty = true;
            } else {
                this.recieveChannelsDirty = true;
            }
        }
    }

    @Override
    protected void onAfterNbtRead() {
        super.onAfterNbtRead();
        this.currentTask = new ContinuousTask(this.getPowerUsePerTick());
    }

    static void readChannels(NBTTagCompound nbtRoot, ChannelList channels, @Nonnull String key) {
        channels.clear();
        if (!nbtRoot.func_74764_b(key)) {
            return;
        }
        NBTTagList tags = (NBTTagList)nbtRoot.func_74781_a(key);
        for (int i = 0; i < tags.func_74745_c(); ++i) {
            channels.add(Channel.readFromNBT(tags.func_150305_b(i)));
        }
    }

    @Nonnull
    static NBTTagList createTagList(ChannelList channels) {
        NBTTagList res = new NBTTagList();
        for (Set chan : channels.values()) {
            for (Channel channel : chan) {
                NBTTagCompound chanTag = new NBTTagCompound();
                channel.writeToNBT(chanTag);
                res.func_74742_a((NBTBase)chanTag);
            }
        }
        return res;
    }

    void setSendChannels(ChannelList channels) {
        this.sendChannels.clear();
        this.sendChannels.putAll(channels);
    }

    void setRecieveChannels(ChannelList channels) {
        this.recieveChannels.clear();
        this.recieveChannels.putAll(channels);
    }

    ChannelList getSendChannels() {
        return this.sendChannels;
    }

    ChannelList getReceiveChannels() {
        return this.recieveChannels;
    }

    private void processPower() {
        Set<Channel> sendTo = this.getSendChannels(ChannelType.POWER);
        int canSend = this.getMaxSendableEnergy();
        if (canSend > 0 && !sendTo.isEmpty()) {
            Iterator<Channel> iter = sendTo.iterator();
            while (canSend > 0 && iter.hasNext()) {
                TransceiverRegistry.INSTANCE.sendPower(this, canSend, iter.next());
                canSend = this.getMaxSendableEnergy();
            }
        }
        if ((canSend = this.getMaxSendableEnergy()) > 0 && !this.getRecieveChannels(ChannelType.POWER).isEmpty()) {
            if (this.powerDistributor == null) {
                this.powerDistributor = new PowerDistributor(this.getLocation());
            }
            int used = this.powerDistributor.transmitEnergy(this.field_145850_b, canSend);
            this.usePower(used);
        }
    }

    private int getMaxSendableEnergy() {
        return this.getEnergyStored() - (int)(0.5f * (float)this.getMaxEnergyStored());
    }

    @Override
    public void onNeighborBlockChange(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos posIn, @Nonnull Block blockIn, @Nonnull BlockPos fromPos) {
        super.onNeighborBlockChange(state, worldIn, posIn, blockIn, fromPos);
        if (this.powerDistributor != null) {
            this.powerDistributor.neighboursChanged();
        }
        this.neighbourFluidHandlers = null;
    }

    private boolean hasRecieveChannel(@Nonnull Set<Channel> channels, @Nonnull ChannelType type) {
        boolean hasChannel = false;
        for (Channel chan : channels) {
            if (!this.getRecieveChannels(type).contains(chan)) continue;
            hasChannel = true;
            break;
        }
        return hasChannel;
    }

    public boolean canReceive(@Nonnull Set<Channel> channels, @Nonnull Fluid fluid) {
        if (this.inFluidFill) {
            return false;
        }
        if (!this.hasRecieveChannel(channels, ChannelType.FLUID)) {
            return false;
        }
        FluidStack offer = new FluidStack(fluid, 1);
        Map neighbours = FluidWrapper.wrapNeighbours((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c);
        for (Map.Entry entry : neighbours.entrySet()) {
            IoMode mode = this.getIoMode((EnumFacing)entry.getKey());
            if (!mode.canOutput() || ((IFluidWrapper)entry.getValue()).offer(offer) <= 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (this.inFluidFill) {
            return 0;
        }
        try {
            this.inFluidFill = true;
            if (this.getSendChannels(ChannelType.FLUID).isEmpty() || !this.redstoneCheckPassed || !this.getIoMode(from).canRecieveInput()) {
                int n = 0;
                return n;
            }
            int n = TransceiverRegistry.INSTANCE.fill(this, this.getSendChannels(ChannelType.FLUID), resource, doFill);
            return n;
        }
        finally {
            this.inFluidFill = false;
        }
    }

    public int recieveFluid(@Nonnull Set<Channel> channels, @Nonnull FluidStack resource, boolean doFill) {
        if (this.inFluidFill) {
            return 0;
        }
        if (!this.hasRecieveChannel(channels, ChannelType.FLUID) || !this.redstoneCheckPassed) {
            return 0;
        }
        Map neighbours = FluidWrapper.wrapNeighbours((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c);
        for (Map.Entry entry : neighbours.entrySet()) {
            int res;
            IoMode mode = this.getIoMode((EnumFacing)entry.getKey());
            if (!mode.canOutput() || (res = doFill ? ((IFluidWrapper)entry.getValue()).fill(resource) : ((IFluidWrapper)entry.getValue()).offer(resource)) <= 0) continue;
            return res;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRecieveTankInfo(@Nonnull List<IFluidTankProperties> infos, @Nonnull Set<Channel> channels) {
        if (this.inGetTankInfo) {
            return;
        }
        try {
            this.inGetTankInfo = true;
            if (!this.hasRecieveChannel(channels, ChannelType.FLUID)) {
                return;
            }
            Map<EnumFacing, IFluidHandler> fluidHandlers = this.getNeighbouringFluidHandlers();
            for (Map.Entry<EnumFacing, IFluidHandler> entry : fluidHandlers.entrySet()) {
                IFluidTankProperties[] tanks = entry.getValue().getTankProperties();
                if (tanks == null) continue;
                for (IFluidTankProperties info : tanks) {
                    infos.add(info);
                }
            }
        }
        finally {
            this.inGetTankInfo = false;
        }
    }

    Map<EnumFacing, IFluidHandler> getNeighbouringFluidHandlers() {
        if (this.neighbourFluidHandlers == null) {
            this.neighbourFluidHandlers = FluidUtil.getNeighbouringFluidHandlers((World)this.field_145850_b, (BlockPos)this.func_174877_v());
        }
        return this.neighbourFluidHandlers;
    }

    @Override
    public int getInventoryStackLimit() {
        return this.bufferStacks ? 64 : 1;
    }

    public boolean isBufferStacks() {
        return this.bufferStacks;
    }

    public void setBufferStacks(boolean bufferStacks) {
        this.bufferStacks = bufferStacks;
    }

    private void processItems() {
        Set<Channel> sendItemChannels = this.getSendChannels(ChannelType.ITEM);
        if (!sendItemChannels.isEmpty()) {
            for (int i = this.slotDefinition.minInputSlot; i <= this.slotDefinition.maxInputSlot; ++i) {
                ItemStack toSend = this.getStackInSlot(i);
                if (!Prep.isValid(toSend)) continue;
                TransceiverRegistry.INSTANCE.sendItem(this, sendItemChannels, i, toSend);
            }
        }
    }

    @Override
    public boolean isMachineItemValidForSlot(int slot, @Nonnull ItemStack itemstack) {
        return !itemstack.func_190926_b();
    }

    @Override
    public int usePower(int wantToUse) {
        return super.usePower(wantToUse);
    }

    private class FluidCap
    implements IFluidHandler {
        final EnumFacing capFacing;

        FluidCap(EnumFacing facing) {
            this.capFacing = facing;
        }

        public int fill(FluidStack resource, boolean doFill) {
            return TileTransceiver.this.fill(this.capFacing, resource, doFill);
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }

        public IFluidTankProperties[] getTankProperties() {
            if (TileTransceiver.this.inGetTankInfo) {
                return new IFluidTankProperties[0];
            }
            try {
                TileTransceiver.this.inGetTankInfo = true;
                IFluidTankProperties[] iFluidTankPropertiesArray = TransceiverRegistry.INSTANCE.getTankInfoForChannels(TileTransceiver.this, TileTransceiver.this.getSendChannels(ChannelType.FLUID));
                return iFluidTankPropertiesArray;
            }
            finally {
                TileTransceiver.this.inGetTankInfo = false;
            }
        }
    }
}

