/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.crafter;

import com.enderio.core.common.inventory.EnderInventory;
import com.enderio.core.common.inventory.Filters;
import com.enderio.core.common.inventory.InventorySlot;
import com.enderio.core.common.util.ItemUtil;
import com.google.common.base.Predicate;
import com.mojang.authlib.GameProfile;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.base.capacitor.DefaultCapacitorData;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.machine.base.te.AbstractCapabilityMachineEntity;
import crazypants.enderio.base.machine.fakeplayer.FakePlayerEIO;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.machine.crafter.DummyCraftingGrid;
import crazypants.enderio.util.Prep;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

@Storable
public class TileCrafter
extends AbstractCapabilityMachineEntity
implements IPaintable.IPaintableTileEntity {
    @Nonnull
    public static final String OUTPUT_SLOT = "OUTPUT";
    @Nonnull
    public static final String INPUT_SLOT = "INPUT";
    public static final int BASE_TICK_RATE = 10;
    @Store
    DummyCraftingGrid craftingGrid = new DummyCraftingGrid();
    @Store
    private boolean bufferStacks = true;
    private long ticksSinceLastCraft = 0L;
    private FakePlayerEIO playerInst;
    private static final UUID uuid = UUID.fromString("9b381cae-3c95-4a64-b958-1e25b0a4c790");
    private static final GameProfile DUMMY_PROFILE = new GameProfile(uuid, "[EioCrafter]");

    public TileCrafter() {
        this(CapacitorKey.CRAFTER_POWER_INTAKE, CapacitorKey.CRAFTER_POWER_BUFFER, CapacitorKey.CRAFTER_POWER_USE);
    }

    public TileCrafter(@Nonnull ICapacitorKey maxEnergyRecieved, @Nonnull ICapacitorKey maxEnergyStored, @Nonnull ICapacitorKey maxEnergyUsed) {
        super(maxEnergyRecieved, maxEnergyStored, maxEnergyUsed);
        for (int i = 0; i < 9; ++i) {
            PredicateItemStackMatch predicate = new PredicateItemStackMatch(i);
            this.getInventory().add(EnderInventory.Type.INPUT, INPUT_SLOT + i, new InventorySlot((Predicate)predicate, Filters.ALWAYS_TRUE){

                public int getMaxStackSize() {
                    return TileCrafter.this.bufferStacks ? 64 : 1;
                }
            });
        }
        this.getInventory().add(EnderInventory.Type.OUTPUT, OUTPUT_SLOT, new InventorySlot(Filters.ALWAYS_TRUE, Filters.ALWAYS_TRUE));
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    protected boolean processTasks(boolean redstoneCheck) {
        ++this.ticksSinceLastCraft;
        if (this.isOutputQueued()) {
            this.ticksSinceLastCraft = 0L;
        } else if (this.ticksSinceLastCraft > (long)this.getTicksPerCraft()) {
            if (!this.craftingGrid.hasValidRecipe()) {
                for (int i = 0; i < 9; ++i) {
                    ItemStack stack = this.getInventory().getSlot(INPUT_SLOT + i).get();
                    if (!Prep.isValid(stack)) continue;
                    this.addToOutputQueue(stack);
                    this.getInventory().getSlot(INPUT_SLOT + i).clear();
                }
            } else if (redstoneCheck && this.getEnergy().canUseEnergy(CapacitorKey.CRAFTER_POWER_CRAFT) && this.canMergeOutput() && this.canCraft() && this.craftRecipe()) {
                this.ticksSinceLastCraft = 0L;
                this.getEnergy().useEnergy(CapacitorKey.CRAFTER_POWER_CRAFT);
            }
        }
        if (redstoneCheck) {
            this.getEnergy().useEnergy();
        }
        return super.processTasks(redstoneCheck);
    }

    protected int getGuiEnergyUse() {
        return this.getEnergy().getMaxUsage(CapacitorKey.CRAFTER_POWER_CRAFT);
    }

    public int getTicksPerCraft() {
        int impulseHopperSpeedScaled = CapacitorKey.CRAFTER_SPEED.get(this.getCapacitorData());
        if (impulseHopperSpeedScaled > 0) {
            return 10 / impulseHopperSpeedScaled;
        }
        return 10;
    }

    private boolean canCraft() {
        int[] used = new int[9];
        int found = 0;
        int required = 0;
        block0: for (int j = 0; j < 9; ++j) {
            ItemStack req = this.craftingGrid.func_70301_a(j);
            if (req.func_190926_b()) continue;
            ++required;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.getInventory().getSlot(INPUT_SLOT + i).get();
                if (stack.func_190916_E() <= used[i] || !stack.func_185136_b(req)) continue;
                ++found;
                int n = i;
                used[n] = used[n] + 1;
                continue block0;
            }
        }
        return found == required;
    }

    private boolean craftRecipe() {
        InventoryCrafting inv = new InventoryCrafting(new Container(){

            public boolean func_75145_c(@Nonnull EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        block0: for (int j = 0; j < 9; ++j) {
            ItemStack req = this.craftingGrid.func_70301_a(j);
            if (req.func_190926_b()) {
                inv.func_70299_a(j, req);
                continue;
            }
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.getInventory().getSlot(INPUT_SLOT + i).get();
                if (!stack.func_185136_b(req)) continue;
                inv.func_70299_a(j, stack.func_77979_a(1));
                continue block0;
            }
        }
        IRecipe recipe = CraftingManager.func_192413_b((InventoryCrafting)inv, (World)this.field_145850_b);
        if (recipe == null) {
            for (int j = 0; j < 9; ++j) {
                if (inv.func_70301_a(j).func_190926_b()) continue;
                this.addToOutputQueue(inv.func_70301_a(j));
            }
            return false;
        }
        ForgeHooks.setCraftingPlayer((EntityPlayer)this.getFakePlayer());
        ItemStack output = recipe.func_77572_b(inv);
        output.func_77980_a(this.field_145850_b, (EntityPlayer)this.getFakePlayer(), 1);
        NonNullList remaining = CraftingManager.func_180303_b((InventoryCrafting)inv, (World)this.field_145850_b);
        ForgeHooks.setCraftingPlayer(null);
        for (int j = 0; j < 9; ++j) {
            inv.func_70301_a(j).func_190918_g(1);
            if (inv.func_70301_a(j).func_190926_b()) continue;
            this.addToOutputQueue(inv.func_70301_a(j));
        }
        for (ItemStack stack : remaining) {
            if (stack.func_190926_b()) continue;
            this.addToOutputQueue(stack.func_77946_l());
        }
        if (!this.mergeOutput(output)) {
            this.addToOutputQueue(output);
        }
        return true;
    }

    @Nonnull
    private FakePlayerEIO getFakePlayer() {
        return this.playerInst != null ? this.playerInst : (this.playerInst = new FakePlayerEIO(this.field_145850_b, this.getLocation(), DUMMY_PROFILE).setOwner(this.getOwner()));
    }

    private boolean canMergeOutput() {
        ItemStack oldOutput = this.getInventory().getSlot(OUTPUT_SLOT).get();
        if (oldOutput.func_190926_b()) {
            return true;
        }
        ItemStack output = this.craftingGrid.getOutput();
        if (!ItemUtil.areStackMergable((ItemStack)oldOutput, (ItemStack)output)) {
            return false;
        }
        return output.func_77976_d() >= oldOutput.func_190916_E() + output.func_190916_E();
    }

    public boolean isBufferStacks() {
        return this.bufferStacks;
    }

    public void setBufferStacks(boolean bufferStacks) {
        if (!bufferStacks && this.bufferStacks) {
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.getInventory().getSlot(INPUT_SLOT + i).getCopy();
                if (stack.func_190916_E() <= 1) continue;
                this.addToOutputQueue(stack.func_77979_a(stack.func_190916_E() - 1));
                this.getInventory().getSlot(INPUT_SLOT + i).set(stack);
            }
        }
        this.bufferStacks = bufferStacks;
    }

    public void updateCraftingOutput() {
        InventoryCrafting inv = new InventoryCrafting(new Container(){

            public boolean func_75145_c(@Nonnull EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            inv.func_70299_a(i, this.craftingGrid.func_70301_a(i));
        }
        ItemStack matches = ItemStack.field_190927_a;
        IRecipe recipe = CraftingManager.func_192413_b((InventoryCrafting)inv, (World)this.field_145850_b);
        if (recipe != null && Prep.isInvalid(matches = recipe.func_77571_b())) {
            ForgeHooks.setCraftingPlayer((EntityPlayer)this.getFakePlayer());
            matches = recipe.func_77572_b(inv);
            ForgeHooks.setCraftingPlayer(null);
        }
        this.craftingGrid.func_70299_a(9, matches);
        this.func_70296_d();
    }

    private class PredicateItemStackMatch
    extends Filters.PredicateItemStack {
        private final int slot;

        PredicateItemStackMatch(int slot) {
            this.slot = slot;
        }

        public boolean doApply(@Nonnull ItemStack input) {
            return input.func_185136_b(TileCrafter.this.craftingGrid.func_70301_a(this.slot));
        }
    }

    public static class Simple
    extends TileCrafter {
        public Simple() {
            super(CapacitorKey.SIMPLE_CRAFTER_POWER_INTAKE, CapacitorKey.SIMPLE_CRAFTER_POWER_BUFFER, CapacitorKey.SIMPLE_CRAFTER_POWER_USE);
            this.getInventory().getSlot("cap").set(new ItemStack(ModObject.itemBasicCapacitor.getItemNN(), 1, DefaultCapacitorData.ENDER_CAPACITOR.ordinal()));
        }

        @Override
        public int getTicksPerCraft() {
            return 20;
        }
    }
}

