/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.power.forge.tile;

import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.config.config.DiagnosticsConfig;
import crazypants.enderio.base.power.forge.tile.ILegacyPoweredTile;
import crazypants.enderio.base.power.forge.tile.InternalPoweredTileWrapper;
import java.util.EnumMap;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.energy.IEnergyStorage;

public class InternalRecieverTileWrapper
extends InternalPoweredTileWrapper {
    @Nonnull
    public static final WeakHashMap<ILegacyPoweredTile.Receiver, EnumMap<EnumFacing, IEnergyStorage>> CACHE = new WeakHashMap();
    @Nonnull
    protected final ILegacyPoweredTile.Receiver tile;

    @Nullable
    public static IEnergyStorage get(@Nonnull ILegacyPoweredTile.Receiver tile, @Nullable EnumFacing facing) {
        if (facing != null && tile.canConnectEnergy(facing)) {
            EnumMap sideMap = CACHE.computeIfAbsent(tile, theTile -> new EnumMap(EnumFacing.class));
            IEnergyStorage energyStorage = (IEnergyStorage)sideMap.get(facing);
            if (energyStorage == null) {
                energyStorage = InternalRecieverTileWrapper.getInternal(tile, facing);
                sideMap.put(facing, energyStorage);
            }
            return energyStorage;
        }
        return null;
    }

    @Nonnull
    private static IEnergyStorage getInternal(@Nonnull ILegacyPoweredTile.Receiver tile, @Nonnull EnumFacing facing) {
        switch ((DiagnosticsConfig.Protection)((Object)DiagnosticsConfig.protectEnergyOverflow.get())) {
            case NONE: {
                return new InternalRecieverTileWrapper(tile, facing);
            }
            case SOFT: {
                return new LimitingRecieverTileCapabilityProvider(tile, facing);
            }
        }
        return new ValidatingRecieverTileCapabilityProvider(tile, facing);
    }

    public InternalRecieverTileWrapper(@Nonnull ILegacyPoweredTile.Receiver tile, @Nonnull EnumFacing facing) {
        super(tile, facing);
        this.tile = tile;
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.tile.receiveEnergy(this.from, maxReceive, simulate);
    }

    @Override
    public boolean canReceive() {
        return true;
    }

    public static class LimitingRecieverTileCapabilityProvider
    extends InternalRecieverTileWrapper {
        private long lastTick = -1L;
        private int recv = 0;

        public LimitingRecieverTileCapabilityProvider(@Nonnull ILegacyPoweredTile.Receiver tile, @Nonnull EnumFacing facing) {
            super(tile, facing);
        }

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            int max;
            int receivedEnergy;
            long serverTickCount = EnderIO.proxy.getServerTickCount();
            if (serverTickCount != this.lastTick) {
                this.lastTick = serverTickCount;
                this.recv = 0;
            }
            int n = receivedEnergy = (max = Math.min(maxReceive, this.tile.getMaxEnergyRecieved(this.from) - this.recv)) > 0 ? super.receiveEnergy(max, simulate) : 0;
            if (!simulate) {
                this.recv += receivedEnergy;
            }
            return receivedEnergy;
        }
    }

    public static class ValidatingRecieverTileCapabilityProvider
    extends InternalRecieverTileWrapper {
        private long lastTick = -1L;
        private int recv = 0;
        private int cooldown = 0;

        public ValidatingRecieverTileCapabilityProvider(@Nonnull ILegacyPoweredTile.Receiver tile, @Nonnull EnumFacing facing) {
            super(tile, facing);
        }

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            long serverTickCount = EnderIO.proxy.getServerTickCount();
            if (serverTickCount != this.lastTick) {
                this.lastTick = serverTickCount;
                this.recv = 0;
            }
            int maxEnergyRecieved = this.tile.getMaxEnergyRecieved(this.from);
            int receivedEnergy = super.receiveEnergy(Math.max(0, Math.min(maxReceive, maxEnergyRecieved - this.recv)), simulate);
            if (!simulate) {
                if (this.recv == 0) {
                    this.recv += receivedEnergy;
                } else {
                    this.recv += maxReceive;
                    if (this.recv > maxEnergyRecieved) {
                        if (this.cooldown <= 0) {
                            BlockPos pos = this.tile.getLocation().func_177972_a(this.from);
                            ((TileEntity)this.tile).func_145831_w().func_72876_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 1.0f, this.recv / 2 > maxEnergyRecieved);
                            this.cooldown = 30;
                        } else {
                            --this.cooldown;
                        }
                    }
                }
            }
            return receivedEnergy;
        }
    }
}

