/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.material.upgrades;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.handler.darksteel.UpgradeRegistry;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.render.IHaveRenderers;
import crazypants.enderio.util.NbtValue;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.util.Strings;

public final class ItemUpgrades
extends Item
implements IHaveRenderers,
IAdvancedTooltipProvider {
    @Nonnull
    private static final String INVENTORY = "inventory";

    public static ItemUpgrades create(@Nonnull IModObject modObject, @Nullable Block block) {
        return new ItemUpgrades(modObject);
    }

    private ItemUpgrades(@Nonnull IModObject modObject) {
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        modObject.apply(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers(@Nonnull IModObject modObject) {
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(modObject.getRegistryName(), INVENTORY)});
        UpgradeRegistry.getUpgrades().apply(upgrade -> {
            ResourceLocation registryName = upgrade.getRegistryName();
            if (registryName != null) {
                ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{this.getMRL(modObject.getRegistryName(), registryName)});
            }
        });
        ModelLoader.setCustomMeshDefinition((Item)this, this::getMRL);
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    protected ModelResourceLocation getMRL(@Nonnull ItemStack stack) {
        ResourceLocation registryName;
        IDarkSteelUpgrade upgrade = ItemUpgrades.getUpgrade(stack);
        if (upgrade != null && (registryName = upgrade.getRegistryName()) != null) {
            return this.getMRL(this.getRegistryName(), registryName);
        }
        return new ModelResourceLocation((ResourceLocation)NullHelper.first((Object)this.getRegistryName(), (Supplier[])new Supplier[0]), INVENTORY);
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    protected ModelResourceLocation getMRL(ResourceLocation base, @Nonnull ResourceLocation registryName) {
        return new ModelResourceLocation(new ResourceLocation(registryName.func_110624_b(), base.func_110623_a()), "upgrade=" + registryName.func_110623_a());
    }

    public static IDarkSteelUpgrade getUpgrade(@Nonnull ItemStack stack) {
        String string;
        if (stack.func_77952_i() == 1 && !Strings.isBlank((String)(string = NbtValue.DSU.getString(stack)))) {
            return UpgradeRegistry.getUpgrade(new ResourceLocation(string));
        }
        return null;
    }

    @Nonnull
    public String func_77667_c(@Nonnull ItemStack stack) {
        IDarkSteelUpgrade upgrade = ItemUpgrades.getUpgrade(stack);
        if (upgrade != null) {
            return upgrade.getUnlocalizedName();
        }
        return this.func_77658_a();
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        IDarkSteelUpgrade upgrade = ItemUpgrades.getUpgrade(stack);
        if (upgrade != null) {
            return I18n.func_74837_a((String)(this.func_77658_a() + ".with"), (Object[])new Object[]{super.func_77653_i(stack)}).trim();
        }
        return super.func_77653_i(stack);
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            list.add((Object)new ItemStack((Item)this));
            UpgradeRegistry.getUpgrades().apply(upgrade -> {
                ResourceLocation registryName = upgrade.getRegistryName();
                if (registryName != null) {
                    list.add((Object)NbtValue.DSU.setString(new ItemStack((Item)this, 1, 1), registryName.toString()));
                }
            });
        }
    }

    @Nonnull
    public ItemStack withUpgrade(@Nonnull IDarkSteelUpgrade upgrade) {
        ResourceLocation registryName = upgrade.getRegistryName();
        if (registryName != null) {
            return ItemUpgrades.setEnabled(NbtValue.DSU.setString(new ItemStack((Item)this, 1, 1), registryName.toString()), true);
        }
        return new ItemStack((Item)this);
    }

    public static boolean isEnabled(@Nonnull ItemStack stack) {
        return true;
    }

    @Nonnull
    public static ItemStack setEnabled(@Nonnull ItemStack stack, boolean value) {
        return stack;
    }

    public boolean func_77636_d(@Nonnull ItemStack stack) {
        return NbtValue.ENABLED.getBoolean(stack) || super.func_77636_d(stack);
    }

    public void addCommonEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        SpecialTooltipHandler.addCommonTooltipFromResources(list, (String)itemstack.func_77977_a());
    }

    public void addBasicEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        SpecialTooltipHandler.addBasicTooltipFromResources(list, (String)itemstack.func_77977_a());
    }

    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        IDarkSteelUpgrade upgrade = ItemUpgrades.getUpgrade(itemstack);
        if (upgrade != null) {
            list.add(Lang.DSU_TOOLTIP_MAIN.get());
            NNList sublist = new NNList();
            SpecialTooltipHandler.addDetailedTooltipFromResources((List)sublist, (String)upgrade.getUnlocalizedName());
            sublist.apply(line -> {
                if (!line.contains("$")) {
                    list.add(Lang.DSU_TOOLTIP_LINE.get(line));
                }
            });
            List<IDarkSteelUpgrade> dependencies = upgrade.getDependencies();
            if (!dependencies.isEmpty()) {
                list.add(Lang.DSU_TOOLTIP_DEPS.get());
                dependencies.forEach(dependency -> list.add(Lang.DSU_TOOLTIP_LINE.get(EnderIO.lang.localizeExact(dependency.getUnlocalizedName() + ".name"))));
            }
            List<Supplier<String>> classes = upgrade.getItemClassesForTooltip();
            list.add(Lang.DSU_TOOLTIP_CLAS.get());
            if (classes.isEmpty()) {
                list.add(Lang.DSU_TOOLTIP_LINE.get(Lang.DSU_CLASS_EVERYTHING.get()));
            } else {
                classes.forEach(itemclass -> list.add(Lang.DSU_TOOLTIP_LINE.get(itemclass.get())));
            }
        } else {
            SpecialTooltipHandler.addDetailedTooltipFromResources(list, (String)this.func_77658_a());
        }
    }
}

