/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel.upgrade.storage;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.base.config.config.DarkSteelConfig;
import crazypants.enderio.base.handler.darksteel.AbstractUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import crazypants.enderio.base.lang.Lang;
import info.loenwind.autoconfig.factory.IValue;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="enderio")
public class StorageUpgrade
extends AbstractUpgrade {
    @Nonnull
    private static final String UPGRADE_NAME = "inv";
    @Nonnull
    public static final StorageUpgrade INSTANCE = new StorageUpgrade(0);
    @Nonnull
    public static final StorageUpgrade INSTANCE2 = new StorageUpgrade(1);
    @Nonnull
    public static final StorageUpgrade INSTANCE3 = new StorageUpgrade(2);
    @Nonnull
    protected static final EntityEquipmentSlot[] ARMOR = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};

    @SubscribeEvent
    public static void registerDarkSteelUpgrades(@Nonnull RegistryEvent.Register<IDarkSteelUpgrade> event) {
        event.getRegistry().register((IForgeRegistryEntry)INSTANCE);
        event.getRegistry().register((IForgeRegistryEntry)INSTANCE2);
        event.getRegistry().register((IForgeRegistryEntry)INSTANCE3);
    }

    public StorageUpgrade(int level) {
        super(UPGRADE_NAME, level, "enderio.darksteel.upgrade.inv." + level, (IValue<Integer>)((IValue)DarkSteelConfig.inventoryUpgradeCost.get(level)));
    }

    @Override
    public boolean canAddToItem(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
        return (item.isForSlot(EntityEquipmentSlot.FEET) || item.isForSlot(EntityEquipmentSlot.LEGS) || item.isForSlot(EntityEquipmentSlot.CHEST) || item.isForSlot(EntityEquipmentSlot.HEAD)) && EnergyUpgradeManager.itemHasAnyPowerUpgrade(stack) && this.getUpgradeVariantLevel(stack) == this.variant - 1;
    }

    @Override
    @Nonnull
    public List<IDarkSteelUpgrade> getDependencies() {
        switch (this.variant) {
            case 1: {
                return new NNList((Object[])new IDarkSteelUpgrade[]{(IDarkSteelUpgrade)EnergyUpgrade.UPGRADES.get(0), INSTANCE});
            }
            case 2: {
                return new NNList((Object[])new IDarkSteelUpgrade[]{(IDarkSteelUpgrade)EnergyUpgrade.UPGRADES.get(0), INSTANCE2});
            }
        }
        return new NNList((Object[])new IDarkSteelUpgrade[]{(IDarkSteelUpgrade)EnergyUpgrade.UPGRADES.get(0)});
    }

    @Override
    @Nonnull
    public List<Supplier<String>> getItemClassesForTooltip() {
        Object[] objectArray = new Supplier[1];
        objectArray[0] = Lang.DSU_CLASS_ARMOR::get;
        return new NNList(objectArray);
    }

    @Override
    public boolean canOtherBeRemoved(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item, @Nonnull IDarkSteelUpgrade other) {
        return !EnergyUpgradeManager.isLowestPowerUpgrade(other);
    }

    protected static int slots(@Nonnull EntityEquipmentSlot slot, int level) {
        return level < 0 ? 0 : StorageUpgrade.cols(slot) * (Integer)((IValue)DarkSteelConfig.inventoryUpgradeRows.get(level)).get();
    }

    protected static int cols(@Nonnull EntityEquipmentSlot slot) {
        return ((DarkSteelConfig.COLS)((Object)((IValue)DarkSteelConfig.inventoryUpgradeCols.get((int)slot.func_188454_b())).get())).cols;
    }
}

