/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel.upgrade.storage;

import com.enderio.core.common.ContainerEnderCap;
import crazypants.enderio.base.item.darksteel.upgrade.storage.StorageCap;
import crazypants.enderio.base.item.darksteel.upgrade.storage.StorageCombinedCap;
import crazypants.enderio.base.item.darksteel.upgrade.storage.StorageRemoteExec;
import crazypants.enderio.base.item.darksteel.upgrade.storage.StorageUpgrade;
import java.awt.Point;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class StorageContainer
extends ContainerEnderCap<StorageCombinedCap, TileEntity>
implements StorageRemoteExec.Container {
    private static final int X0 = 8;
    private static final int Y0 = 10;
    @Nonnull
    private final StorageCap feet;
    @Nonnull
    private final StorageCap legs;
    @Nonnull
    private final StorageCap body;
    @Nonnull
    private final StorageCap head;
    @Nonnull
    protected EntityEquipmentSlot activeTab = EntityEquipmentSlot.CHEST;
    private int guid = 0;

    public StorageContainer(@Nonnull InventoryPlayer playerInv, @Nonnull StorageCap feet, @Nonnull StorageCap legs, @Nonnull StorageCap body, @Nonnull StorageCap head) {
        super(playerInv, (IItemHandler)new StorageCombinedCap(feet, legs, body, head), null);
        this.feet = feet;
        this.legs = legs;
        this.body = body;
        this.head = head;
    }

    protected void addSlots() {
        int xoff = 0;
        int x = 0;
        int y = 0;
        EntityEquipmentSlot last = null;
        for (int i = 0; i < ((StorageCombinedCap)this.getItemHandler()).getSlots(); ++i) {
            EntityEquipmentSlot current = ((StorageCombinedCap)this.getItemHandler()).getHandlerFromSlot(i).getEquipmentSlot();
            if (current != last) {
                xoff = (9 - StorageUpgrade.cols(current)) / 2;
                x = 0;
                y = 0;
                last = current;
            }
            this.func_75146_a((Slot)new SlotItemHandler(this.getItemHandler(), i, 8 + 18 * (x + xoff), 10 + 18 * y){

                public boolean func_111238_b() {
                    return StorageContainer.this.activeTab == ((StorageCombinedCap)this.getItemHandler()).getHandlerFromSlot(this.getSlotIndex()).getEquipmentSlot();
                }

                public boolean func_75214_a(@Nonnull ItemStack stack) {
                    return this.func_111238_b() && super.func_75214_a(stack);
                }
            });
            if (++x < StorageUpgrade.cols(current)) continue;
            x = 0;
            ++y;
        }
    }

    @Nonnull
    public Point getPlayerInventoryOffset() {
        Point p = super.getPlayerInventoryOffset();
        p.translate(8, 70);
        return p;
    }

    public void func_75134_a(@Nonnull EntityPlayer playerIn) {
        this.feet.onContentsChanged(0);
        this.legs.onContentsChanged(0);
        this.body.onContentsChanged(0);
        this.head.onContentsChanged(0);
        super.func_75134_a(playerIn);
    }

    @Override
    public void setGuiID(int id) {
        this.guid = id;
    }

    @Override
    public int getGuiID() {
        return this.guid;
    }

    @Override
    public IMessage setTab(@Nonnull EntityEquipmentSlot tab) {
        this.activeTab = tab;
        return null;
    }

    public boolean func_75145_c(@Nonnull EntityPlayer player) {
        return this.feet.isStillConnectedToPlayer() && this.legs.isStillConnectedToPlayer() && this.body.isStillConnectedToPlayer() && this.head.isStillConnectedToPlayer();
    }
}

