/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel.upgrade.elytra;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.api.upgrades.IHasPlayerRenderer;
import crazypants.enderio.api.upgrades.IRenderUpgrade;
import crazypants.enderio.base.config.config.DarkSteelConfig;
import crazypants.enderio.base.handler.darksteel.AbstractUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.elytra.ElytraUpgradeLayer;
import crazypants.enderio.base.item.darksteel.upgrade.glider.GliderUpgrade;
import crazypants.enderio.base.lang.Lang;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="enderio")
public class ElytraUpgrade
extends AbstractUpgrade
implements IHasPlayerRenderer {
    @Nonnull
    private static String UPGRADE_NAME = "elytra";
    @Nonnull
    public static final ElytraUpgrade INSTANCE = new ElytraUpgrade();

    @SubscribeEvent
    public static void registerDarkSteelUpgrades(@Nonnull RegistryEvent.Register<IDarkSteelUpgrade> event) {
        event.getRegistry().register((IForgeRegistryEntry)INSTANCE);
    }

    public ElytraUpgrade() {
        super(UPGRADE_NAME, "enderio.darksteel.upgrade.elytra", DarkSteelConfig.elytraCost);
    }

    @Override
    public boolean canAddToItem(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
        return item.isForSlot(EntityEquipmentSlot.CHEST) && item.hasUpgradeCallbacks(this) && !this.hasUpgrade(stack, item) && !GliderUpgrade.INSTANCE.hasUpgrade(stack, item);
    }

    @Override
    @Nonnull
    public List<Supplier<String>> getItemClassesForTooltip() {
        Object[] objectArray = new Supplier[1];
        objectArray[0] = Lang.DSU_CLASS_ARMOR_CHEST::get;
        return new NNList(objectArray);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IRenderUpgrade getRender() {
        return ElytraUpgradeLayer.instance;
    }
}

