/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.handler.darksteel;

import crazypants.enderio.base.Log;
import crazypants.enderio.base.handler.darksteel.UpgradeRenderDispatcher;
import crazypants.enderio.base.item.darksteel.upgrade.elytra.CapeFilterLayer;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerCape;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="enderio", value={Side.CLIENT})
@SideOnly(value=Side.CLIENT)
public final class UpgradeRenderManager {
    private static final Map<RenderPlayer, Object> injected = new WeakHashMap<RenderPlayer, Object>();

    private UpgradeRenderManager() {
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onPlayerRenderPre(RenderPlayerEvent.Pre event) {
        RenderPlayer renderer = event.getRenderer();
        if (renderer != null && !injected.containsKey(renderer)) {
            UpgradeRenderManager.replaceCapeLayer(renderer);
            renderer.func_177094_a((LayerRenderer)new UpgradeRenderDispatcher(renderer));
            injected.put(renderer, null);
        }
    }

    private static void replaceCapeLayer(@Nonnull RenderPlayer renderLivingBase) {
        try {
            List value = (List)ReflectionHelper.getPrivateValue(RenderLivingBase.class, (Object)renderLivingBase, (String[])new String[]{"layerRenderers", "field_177097_h"});
            if (value != null) {
                LayerRenderer capeLayer = null;
                for (LayerRenderer layerRenderer : value) {
                    if (!(layerRenderer instanceof LayerCape) || layerRenderer instanceof CapeFilterLayer) continue;
                    capeLayer = layerRenderer;
                    break;
                }
                if (capeLayer != null) {
                    renderLivingBase.func_177094_a((LayerRenderer)new CapeFilterLayer(capeLayer));
                    value.remove(capeLayer);
                }
            }
        }
        catch (ReflectionHelper.UnableToAccessFieldException e) {
            Log.warn("Unable to access RenderLivingBase.layerRenderers, reason: " + (Object)((Object)e));
        }
    }
}

