/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.handler.darksteel;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.material.upgrades.ItemUpgrades;
import crazypants.enderio.util.NbtValue;
import info.loenwind.autoconfig.factory.IValue;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractUpgrade
extends IForgeRegistryEntry.Impl<IDarkSteelUpgrade>
implements IAdvancedTooltipProvider,
IDarkSteelUpgrade {
    @Nonnull
    public static final String KEY_UPGRADE_PREFIX = "enderio.darksteel.upgrade.";
    @Nonnull
    private static final String KEY_VARIANT = "level";
    protected final int variant;
    protected final IValue<Integer> levelCost;
    @Nonnull
    protected final String id;
    @Nonnull
    protected final String unlocName;

    @Deprecated
    protected AbstractUpgrade(@Nonnull String id, @Nonnull String unlocName, int levelCost) {
        this(id, 0, unlocName, levelCost);
    }

    @Deprecated
    protected AbstractUpgrade(@Nonnull String id, int variant, @Nonnull String unlocName, int levelCost) {
        this("enderio", id, variant, unlocName, levelCost);
    }

    @Deprecated
    protected AbstractUpgrade(@Nonnull String domain, @Nonnull String id, int variant, @Nonnull String unlocName, final int levelCost) {
        this(domain, id, variant, unlocName, new IValue<Integer>(){

            @Nonnull
            public Integer get() {
                return levelCost;
            }
        });
    }

    protected AbstractUpgrade(@Nonnull String id, @Nonnull String unlocName, IValue<Integer> levelCost) {
        this(id, 0, unlocName, levelCost);
    }

    protected AbstractUpgrade(@Nonnull String domain, @Nonnull String id, @Nonnull String unlocName, IValue<Integer> levelCost) {
        this(domain, id, 0, unlocName, levelCost);
    }

    protected AbstractUpgrade(@Nonnull String id, int variant, @Nonnull String unlocName, IValue<Integer> levelCost) {
        this("enderio", id, variant, unlocName, levelCost);
    }

    protected AbstractUpgrade(@Nonnull String domain, @Nonnull String id, int variant, @Nonnull String unlocName, IValue<Integer> levelCost) {
        this.id = KEY_UPGRADE_PREFIX + id;
        this.unlocName = unlocName;
        this.levelCost = levelCost;
        this.variant = variant;
        this.setRegistryName(domain, id + (variant != 0 ? Integer.valueOf(variant) : ""));
    }

    @Override
    @Nonnull
    public final ItemStack getUpgradeItem() {
        return ((ItemUpgrades)ModObject.itemDarkSteelUpgrade.getItemNN()).withUpgrade(this);
    }

    @Override
    public final boolean isUpgradeItem(@Nonnull ItemStack stack) {
        return ItemUpgrades.getUpgrade(stack) == this && ItemUpgrades.isEnabled(stack);
    }

    @Override
    @Nonnull
    public final String getUpgradeItemName() {
        return IDarkSteelUpgrade.super.getUpgradeItemName();
    }

    @SideOnly(value=Side.CLIENT)
    public void addCommonEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        SpecialTooltipHandler.addCommonTooltipFromResources(list, (String)this.getUnlocalizedName());
    }

    @SideOnly(value=Side.CLIENT)
    public void addBasicEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        list.add(TextFormatting.DARK_AQUA + this.getDisplayName());
    }

    @SideOnly(value=Side.CLIENT)
    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        list.add(TextFormatting.DARK_AQUA + this.getDisplayName());
        SpecialTooltipHandler.addDetailedTooltipFromResources(list, (String)this.getUnlocalizedName());
    }

    @Nonnull
    public String getDisplayName() {
        return EnderIO.lang.localizeExact(this.getUnlocalizedName() + ".name");
    }

    @Override
    public int getLevelCost() {
        return (Integer)this.levelCost.get();
    }

    @Override
    @Nonnull
    public String getUnlocalizedName() {
        return this.unlocName;
    }

    @Override
    public final boolean hasUpgrade(@Nonnull ItemStack stack) {
        return IDarkSteelUpgrade.super.hasUpgrade(stack);
    }

    @Override
    public boolean hasUpgrade(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
        NBTTagCompound tagCompound = NbtValue.getReadOnlyRoot(stack);
        return tagCompound.func_74764_b(this.id) && tagCompound.func_74775_l(this.id).func_74762_e(KEY_VARIANT) == this.variant;
    }

    public boolean hasAnyUpgradeVariant(@Nonnull ItemStack stack) {
        NBTTagCompound tagCompound = NbtValue.getReadOnlyRoot(stack);
        return tagCompound.func_74764_b(this.id) && tagCompound.func_74775_l(this.id).func_74764_b(KEY_VARIANT);
    }

    public int getUpgradeVariantLevel(@Nonnull ItemStack stack) {
        NBTTagCompound tagCompound = NbtValue.getReadOnlyRoot(stack);
        return tagCompound.func_74764_b(this.id) && tagCompound.func_74775_l(this.id).func_74764_b(KEY_VARIANT) ? tagCompound.func_74775_l(this.id).func_74762_e(KEY_VARIANT) : -1;
    }

    @Override
    public void addToItem(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
        this.getOrCreateUpgradeNBT(stack).func_74768_a(KEY_VARIANT, this.variant);
    }

    protected int getMinVariant() {
        return 0;
    }

    @Override
    @Nonnull
    public Pair<ItemStack, Integer> removeFromItem(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
        if (this.variant > this.getMinVariant()) {
            this.getOrCreateUpgradeNBT(stack).func_74768_a(KEY_VARIANT, this.variant - 1);
        } else {
            NBTTagCompound tagCompound = NbtValue.getOrCreateRoot(stack);
            if (tagCompound.func_74764_b(this.id)) {
                tagCompound.func_82580_o(this.id);
            }
            if (tagCompound.func_82582_d()) {
                stack.func_77982_d(null);
            }
        }
        return Pair.of((Object)this.getUpgradeItem(), (Object)this.getLevelCost());
    }

    @Nonnull
    public NBTTagCompound getOrCreateUpgradeNBT(@Nonnull ItemStack stack) {
        NBTTagCompound tagCompound = NbtValue.getOrCreateRoot(stack);
        if (!tagCompound.func_74764_b(this.id)) {
            tagCompound.func_74782_a(this.id, (NBTBase)new NBTTagCompound());
        }
        return tagCompound.func_74775_l(this.id);
    }
}

