/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.filter.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.client.gui.button.ColorButton;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.common.util.DyeColor;
import crazypants.enderio.base.filter.IFilter;
import crazypants.enderio.base.filter.gui.AbstractFilterGui;
import crazypants.enderio.base.filter.gui.ContainerFilter;
import crazypants.enderio.base.filter.gui.FilterGuiUtil;
import crazypants.enderio.base.filter.redstone.LogicOutputSignalFilter;
import crazypants.enderio.base.lang.Lang;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;

public class RedstoneSignalLogicGui
extends AbstractFilterGui {
    private static final int ID_COLOR = FilterGuiUtil.nextButtonId();
    @Nonnull
    private final LogicOutputSignalFilter filter;
    private int xOffset;
    private int yOffset;
    @Nonnull
    private final List<ColorButton> colorButtons;

    public RedstoneSignalLogicGui(@Nonnull InventoryPlayer playerInv, @Nonnull ContainerFilter filterContainer, TileEntity te, @Nonnull IFilter filterIn) {
        super(playerInv, filterContainer, te, filterIn);
        this.filter = (LogicOutputSignalFilter)filterIn;
        this.xOffset = 13;
        this.yOffset = 34;
        this.colorButtons = new ArrayList<ColorButton>(this.filter.getNumColors());
        int x = this.xOffset;
        int y = this.yOffset;
        for (int i = 0; i < this.filter.getNumColors(); ++i) {
            ColorButton colorB = new ColorButton((IGuiScreen)this, ID_COLOR + i, x, y);
            colorB.setToolTipHeading(Lang.GUI_REDSTONE_FILTER_SIGNAL_COLOR.get());
            DyeColor color = this.filter.getColor(i);
            colorB.setColorIndex(color.ordinal());
            this.colorButtons.add(colorB);
            y += 20;
        }
    }

    @Override
    protected void func_146284_a(@Nonnull GuiButton button) throws IOException {
        super.func_146284_a(button);
        for (int i = 0; i < this.filter.getNumColors(); ++i) {
            if (button.field_146127_k != ID_COLOR + i) continue;
            this.filter.setColor(i, DyeColor.values()[this.colorButtons.get(i).getColorIndex()]);
        }
        this.sendFilterChange();
    }

    @Override
    public void updateButtons() {
        super.updateButtons();
        for (int i = 0; i < this.filter.getNumColors(); ++i) {
            this.colorButtons.get(i).onGuiInit();
        }
    }

    @Override
    public void renderCustomOptions(int top, float par1, int par2, int par3) {
        FontRenderer fr = this.getFontRenderer();
        for (int i = 0; i < this.filter.getNumColors(); ++i) {
            fr.func_78276_b(Lang.GUI_REDSTONE_FILTER_INPUT_SIGNAL.get() + " " + (i + 1), this.getGuiLeft() + this.xOffset + 20, this.getGuiTop() + this.yOffset + 4 + 20 * i, ColorUtil.getRGB((Color)Color.darkGray));
        }
        super.renderCustomOptions(top, par1, par2, par3);
    }

    @Override
    @Nonnull
    protected String getUnlocalisedNameForHeading() {
        return this.filter.getHeading();
    }
}

