/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.conduit;

import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.base.conduit.registry.ConduitRegistry;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketOpenConduitUI
extends MessageTileEntity<TileEntity> {
    @Nonnull
    private EnumFacing dir = EnumFacing.DOWN;

    public PacketOpenConduitUI() {
    }

    public PacketOpenConduitUI(@Nonnull TileEntity tile, @Nonnull EnumFacing dir) {
        super(tile);
        this.dir = dir;
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeShort(this.dir.ordinal());
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        short ord = buf.readShort();
        if (ord >= 0 && ord < EnumFacing.values().length) {
            this.dir = EnumFacing.values()[ord];
        }
    }

    public static class Handler
    implements IMessageHandler<PacketOpenConduitUI, IMessage> {
        public IMessage onMessage(PacketOpenConduitUI message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            ConduitRegistry.getConduitModObjectNN().openGui(player.field_70170_p, message.getPos(), (EntityPlayer)player, message.dir, message.dir.ordinal());
            return null;
        }
    }
}

