/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.utils;

import com.mojang.authlib.GameProfile;
import ganymedes01.headcrumbs.Headcrumbs;
import ganymedes01.headcrumbs.entity.EntityHuman;
import ganymedes01.headcrumbs.libs.SkullTypes;
import ganymedes01.headcrumbs.utils.helpers.HeadDropHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.event.LootTableLoadEvent;

public class HeadUtils {
    public static final String OWNER_TAG = "SkullOwner";
    public static final String MODEL_TAG = "SkullModel";
    private static final List<ResourceLocation> overworldLoot = Arrays.asList(LootTableList.field_186422_d, LootTableList.field_186424_f, LootTableList.field_186429_k, LootTableList.field_186430_l, LootTableList.field_186431_m);
    private static final List<ResourceLocation> specialLoot = Arrays.asList(LootTableList.field_186425_g, LootTableList.field_186426_h, LootTableList.field_186427_i, LootTableList.field_186428_j, LootTableList.field_186421_c);

    public static void onRegisterLootTable(LootTableLoadEvent event) {
        if (Headcrumbs.addPlayerHeadsAsDungeonLoot) {
            LootPool main = event.getTable().getPool("main");
            if (main == null) {
                return;
            }
            int weight = -1;
            if (specialLoot.contains(event.getName())) {
                weight = Headcrumbs.headsDungeonLootWeight + 1;
            } else if (overworldLoot.contains(event.getName())) {
                weight = Headcrumbs.headsDungeonLootWeight;
            }
            if (weight > 0) {
                main.addEntry((LootEntry)new LootEntryItem(Items.field_151144_bL, weight, 0, new LootFunction[]{new HeadLootFunction()}, new LootCondition[0], "headcrumbs:player_heads0"));
                main.addEntry((LootEntry)new LootEntryItem(Items.field_151144_bL, weight, 0, new LootFunction[]{new HeadLootFunction()}, new LootCondition[0], "headcrumbs:player_heads1"));
                main.addEntry((LootEntry)new LootEntryItem(Items.field_151144_bL, weight, 0, new LootFunction[]{new HeadLootFunction()}, new LootCondition[0], "headcrumbs:player_heads2"));
            }
        }
    }

    public static ItemStack getHeadfromEntity(EntityLivingBase target) {
        if (target.func_70631_g_()) {
            return null;
        }
        if (target instanceof EntityHuman) {
            return HeadUtils.createHeadFor(((EntityHuman)target).getProfile());
        }
        if (target instanceof EntityPlayer) {
            return HeadUtils.createHeadFor((EntityPlayer)target);
        }
        return HeadDropHelper.getHead((Entity)target);
    }

    public static ItemStack createHeadFor(String username) {
        return HeadUtils.createHeadFor(new GameProfile(null, username));
    }

    public static ItemStack createHeadFor(EntityPlayer player) {
        return HeadUtils.createHeadFor(player.func_146103_bH());
    }

    public static ItemStack createHeadFor(GameProfile profile) {
        ItemStack stack = new ItemStack(Items.field_151144_bL, 1, 3);
        stack.func_77982_d(new NBTTagCompound());
        NBTTagCompound profileData = new NBTTagCompound();
        NBTUtil.func_180708_a((NBTTagCompound)profileData, (GameProfile)profile);
        stack.func_77978_p().func_74782_a(OWNER_TAG, (NBTBase)profileData);
        return stack;
    }

    public static GameProfile getGameProfile(ItemStack stack) {
        GameProfile profile = null;
        try {
            if (stack.func_77942_o()) {
                NBTTagCompound nbt = stack.func_77978_p();
                if (nbt.func_150297_b(OWNER_TAG, 10)) {
                    profile = NBTUtil.func_152459_a((NBTTagCompound)nbt.func_74775_l(OWNER_TAG));
                } else if (nbt.func_150297_b(OWNER_TAG, 8)) {
                    profile = new GameProfile(null, nbt.func_74779_i(OWNER_TAG));
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return profile;
    }

    public static String getName(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt.func_150297_b(OWNER_TAG, 10)) {
                GameProfile profile = NBTUtil.func_152459_a((NBTTagCompound)nbt.func_74775_l(OWNER_TAG));
                if (profile != null) {
                    return profile.getName();
                }
            } else if (nbt.func_150297_b(OWNER_TAG, 8)) {
                return nbt.func_74779_i(OWNER_TAG);
            }
        }
        return null;
    }

    public static SkullTypes getModel(ItemStack stack) {
        return stack.func_77942_o() ? HeadUtils.getModel(stack.func_77978_p().func_74779_i(MODEL_TAG)) : SkullTypes.blaze;
    }

    public static SkullTypes getModel(String str) {
        try {
            return SkullTypes.valueOf(str);
        }
        catch (Exception e) {
            return SkullTypes.blaze;
        }
    }

    private static class HeadLootFunction
    extends LootFunction {
        private static List<String> allNames = null;

        protected HeadLootFunction() {
            super(null);
        }

        public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
            if (allNames == null || allNames.isEmpty()) {
                allNames = Headcrumbs.getAllNames();
            }
            String name = allNames.get(rand.nextInt(allNames.size()));
            allNames.remove(name);
            return HeadUtils.createHeadFor(name);
        }
    }
}

