/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.jei.manual;

import com.buuz135.industrial.api.book.CategoryEntry;
import com.buuz135.industrial.api.book.IPage;
import com.buuz135.industrial.api.book.button.TextureButton;
import com.buuz135.industrial.api.book.gui.GUIBookPage;
import com.buuz135.industrial.api.book.page.PageText;
import com.buuz135.industrial.book.GUIBookMain;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ManualWrapper
implements IRecipeWrapper {
    private final TextureButton button = new TextureButton(-135, 0, 105, 18, 18, GUIBookMain.BOOK_EXTRAS, 1, 38, "Open Manual Entry");
    private final CategoryEntry entry;
    private PageText text;
    private int extraLines;

    @SideOnly(value=Side.CLIENT)
    public ManualWrapper(CategoryEntry entry) {
        this.entry = entry;
        this.extraLines = 0;
        int index = 0;
        for (IPage page : entry.getPages()) {
            if (!(page instanceof PageText)) continue;
            this.text = (PageText)page;
            break;
        }
        while (index != -1) {
            index = this.text.getText().indexOf("\n", index);
            if (index == -1) continue;
            ++this.extraLines;
            index += "\n".length();
        }
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInput(ItemStack.class, (Object)this.entry.getDisplay());
        ingredients.setOutput(ItemStack.class, (Object)this.entry.getDisplay());
    }

    @SideOnly(value=Side.CLIENT)
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.button.func_191745_a(minecraft, mouseX, mouseY, 0.0f);
        int y = 20;
        minecraft.field_71466_p.func_78276_b(TextFormatting.DARK_AQUA + this.entry.getName(), 0, y, 0xFFFFFF);
        minecraft.field_71466_p.func_78279_b((TextFormatting.DARK_GRAY + this.text.getText().substring(0, Math.min(200 - this.extraLines * 10, this.text.getText().length())) + (this.text.getText().length() > 200 - this.extraLines * 10 ? "..." : "")).replaceAll(TextFormatting.GOLD.toString(), TextFormatting.DARK_AQUA.toString()), 0, y + minecraft.field_71466_p.field_78288_b + 4, 160, 0xFFFFFF);
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        if (this.button.func_146115_a()) {
            return Arrays.asList(this.button.field_146126_j);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        if (this.button.func_146116_c(minecraft, mouseX, mouseY)) {
            this.button.func_146113_a(minecraft.func_147118_V());
            minecraft.func_147108_a((GuiScreen)new GUIBookPage(null, null, this.entry));
            return true;
        }
        return false;
    }

    public CategoryEntry getEntry() {
        return this.entry;
    }
}

