/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.fluid;

import com.buuz135.industrial.fluid.IFCustomFluid;
import com.buuz135.industrial.utils.ItemStackUtils;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class IFOreFluid
extends IFCustomFluid {
    public static HashMap<String, Integer> CACHED_COLORS = new HashMap();

    public IFOreFluid(String type) {
        super("if.ore_fluid_" + type, 300, new ResourceLocation("industrialforegoing", "blocks/fluids/ore_fluid_" + type + "_still"), new ResourceLocation("industrialforegoing", "blocks/fluids/ore_fluid_" + type + "_flow"));
    }

    public static String getOre(FluidStack stack) {
        return stack.tag != null && stack.tag.func_74764_b("Ore") ? stack.tag.func_74779_i("Ore") : null;
    }

    public int getColor(FluidStack stack) {
        String ore = IFOreFluid.getOre(stack);
        if (ore != null) {
            if (CACHED_COLORS.containsKey(ore)) {
                return CACHED_COLORS.get(ore);
            }
            String dust = "dust" + ore.replaceAll("ore", "");
            if (OreDictionary.doesOreNameExist((String)dust)) {
                int color = ItemStackUtils.getColor((ItemStack)OreDictionary.getOres((String)ore).get(0));
                CACHED_COLORS.put(ore, color);
                return color;
            }
        }
        return super.getColor(stack);
    }

    public FluidStack getWithOre(String ore, int amount) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("Ore", ore);
        return new FluidStack((Fluid)this, amount, compound);
    }

    public String getLocalizedName(FluidStack stack) {
        String ore = IFOreFluid.getOre(stack);
        if (ore != null && OreDictionary.getOres((String)ore).size() > 0) {
            return super.getLocalizedName(stack) + " (" + ((ItemStack)OreDictionary.getOres((String)ore).get(0)).func_82833_r() + ")";
        }
        return super.getLocalizedName(stack);
    }
}

