/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.entities.vehicles;

import com.mjr.extraplanets.api.block.IPowerDock;
import com.mjr.extraplanets.api.prefabs.entity.EntityPoweredVehicleBase;
import com.mjr.extraplanets.items.ExtraPlanets_Items;
import com.mjr.extraplanets.tileEntities.blocks.TileEntityPoweredChargingPad;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityVenusRover
extends EntityPoweredVehicleBase {
    public EntityVenusRover(World world) {
        super(world);
        this.invertControls = true;
    }

    public EntityVenusRover(World world, float f, float g, float h, int itemDamage) {
        super(world, f, g, h, itemDamage);
        this.invertControls = true;
    }

    @Override
    public String getInventoryName() {
        return "VenusRover";
    }

    @Override
    public List<ItemStack> getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ItemStack vehicle = new ItemStack(ExtraPlanets_Items.VENUS_ROVER, 1, this.roverType);
        vehicle.func_77982_d(new NBTTagCompound());
        vehicle.func_77978_p().func_74776_a("currentPowerCapacity", 0.0f);
        items.add(vehicle);
        for (ItemStack item : this.stacks) {
            if (item == null) continue;
            items.add(item);
        }
        return items;
    }

    @Override
    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(ExtraPlanets_Items.VENUS_ROVER, 1, this.roverType);
    }

    @Override
    public void setPad(IPowerDock pad) {
        this.landingPad = pad;
    }

    @Override
    public IPowerDock getLandingPad() {
        return this.landingPad;
    }

    @Override
    public boolean isDockValid(IPowerDock dock) {
        return dock instanceof TileEntityPoweredChargingPad;
    }

    @Override
    public void featureUpdate() {
    }

    @Override
    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            double offsetX = Math.cos((double)this.field_70177_z / 57.29577951308232 + 114.8) * -0.5;
            double offsetZ = Math.sin((double)this.field_70177_z / 57.29577951308232 + 114.8) * -0.5;
            passenger.func_70107_b(this.field_70165_t + offsetX - (double)0.1f, this.field_70163_u + 0.5 + passenger.func_70033_W(), this.field_70161_v + offsetZ + 1.0);
        }
    }
}

