/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import forestry.api.core.ForestryAPI;
import forestry.api.modules.ForestryModule;
import forestry.api.recipes.RecipeManagers;
import forestry.core.fluids.Fluids;
import forestry.farming.FarmRegistry;
import forestry.farming.logic.farmables.FarmableBasicAgricraft;
import forestry.modules.ModuleHelper;
import forestry.plugins.CompatPlugin;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

@ForestryModule(containerID="forestry", moduleID="AgriCraft", name="AgriCraft", author="Nirek", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.agricraft.description")
public class PluginAgriCraft
extends CompatPlugin {
    public PluginAgriCraft() {
        super("AgriCraft", "agricraft");
    }

    @Override
    public void registerRecipes() {
        int seedAmount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.seed");
        Item seedItem = this.getItem("agri_seed");
        if (seedItem != null) {
            Block cropBlock;
            FluidStack fluid = Fluids.SEED_OIL.getFluid(seedAmount);
            if (fluid != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack(seedItem), fluid);
            }
            if ((cropBlock = this.getBlock("crop")) != null && ModuleHelper.isEnabled("farming")) {
                FarmRegistry registry = FarmRegistry.getInstance();
                registry.registerFarmables("farmCrops", new FarmableBasicAgricraft(cropBlock, seedItem));
            }
        }
    }
}

