/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic.crops;

import forestry.core.network.packets.PacketFXSignal;
import forestry.core.utils.NetworkUtil;
import forestry.farming.logic.crops.Crop;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class CropBasicAgriCraft
extends Crop {
    @Nullable
    private static Method growthStageMethod;
    @Nullable
    private static Method dropsMethod;
    private static boolean searchedMethod;
    private final IBlockState blockState;

    public CropBasicAgriCraft(World world, IBlockState blockState, BlockPos position) {
        super(world, position);
        this.blockState = blockState;
    }

    private void replant(World world, BlockPos pos, TileEntity tileEntity) {
        this.findMethods();
        if (growthStageMethod != null) {
            try {
                growthStageMethod.invoke((Object)tileEntity, 0);
                PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.VisualFXType.BLOCK_BREAK, PacketFXSignal.SoundFXType.BLOCK_BREAK, pos, this.blockState);
                NetworkUtil.sendNetworkPacket(packet, pos, world);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    private void findMethods() {
        if (!searchedMethod) {
            Method growthStage = null;
            Method drops = null;
            try {
                Class<?> tileClass = Class.forName("com.infinityraider.agricraft.tiles.TileEntityCrop");
                growthStage = ReflectionHelper.findMethod(tileClass, (String)"setGrowthStage", null, (Class[])new Class[]{Integer.TYPE});
                drops = ReflectionHelper.findMethod(tileClass, (String)"getDrops", null, (Class[])new Class[]{Consumer.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE});
            }
            catch (ClassNotFoundException | ReflectionHelper.UnableToFindMethodException throwable) {
                // empty catch block
            }
            growthStageMethod = growthStage;
            dropsMethod = drops;
            searchedMethod = true;
        }
    }

    private void addDrops(World world, BlockPos pos, TileEntity tileEntity, Consumer<ItemStack> addToList) {
        this.findMethods();
        if (dropsMethod != null) {
            try {
                dropsMethod.invoke((Object)tileEntity, addToList, false, false, true);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    @Override
    protected boolean isCrop(World world, BlockPos pos) {
        return world.func_180495_p(pos) == this.blockState;
    }

    @Override
    protected NonNullList<ItemStack> harvestBlock(World world, BlockPos pos) {
        NonNullList harvest = NonNullList.func_191196_a();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null) {
            return harvest;
        }
        this.addDrops(world, pos, tileEntity, arg_0 -> harvest.add(arg_0));
        this.replant(world, pos, tileEntity);
        return harvest;
    }

    public String toString() {
        return String.format("CropBasicAgriCraft [ position: [ %s ]; block: %s ]", this.position.toString(), this.blockState);
    }

    static {
        searchedMethod = false;
    }
}

