/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.core.IErrorLogic;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.MoistenerFuel;
import forestry.api.recipes.IMoistenerRecipe;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FilteredTank;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.network.PacketBufferForestry;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.IRenderableTile;
import forestry.core.tiles.TileBase;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.factory.gui.ContainerMoistener;
import forestry.factory.gui.GuiMoistener;
import forestry.factory.inventory.InventoryMoistener;
import forestry.factory.recipes.MoistenerRecipeManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileMoistener
extends TileBase
implements ISidedInventory,
ILiquidTankTile,
IRenderableTile {
    private final FilteredTank resourceTank;
    private final TankManager tankManager;
    @Nullable
    private IMoistenerRecipe currentRecipe;
    private int burnTime = 0;
    private int totalTime = 0;
    private int productionTime = 0;
    private int timePerItem = 0;
    @Nullable
    private ItemStack currentProduct;
    @Nullable
    private ItemStack pendingProduct;

    public TileMoistener() {
        this.setInternalInventory(new InventoryMoistener(this));
        this.resourceTank = new FilteredTank(10000).setFilters(FluidRegistry.WATER);
        this.tankManager = new TankManager(this, this.resourceTank);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        NBTTagCompound nbttagcompoundP;
        nbttagcompound = super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("BurnTime", this.burnTime);
        nbttagcompound.func_74768_a("TotalTime", this.totalTime);
        nbttagcompound.func_74768_a("ProductionTime", this.productionTime);
        this.tankManager.writeToNBT(nbttagcompound);
        if (this.pendingProduct != null) {
            nbttagcompoundP = new NBTTagCompound();
            this.pendingProduct.func_77955_b(nbttagcompoundP);
            nbttagcompound.func_74782_a("PendingProduct", (NBTBase)nbttagcompoundP);
        }
        if (this.currentProduct != null) {
            nbttagcompoundP = new NBTTagCompound();
            this.currentProduct.func_77955_b(nbttagcompoundP);
            nbttagcompound.func_74782_a("CurrentProduct", (NBTBase)nbttagcompoundP);
        }
        return nbttagcompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        NBTTagCompound nbttagcompoundP;
        super.func_145839_a(nbttagcompound);
        this.burnTime = nbttagcompound.func_74762_e("BurnTime");
        this.totalTime = nbttagcompound.func_74762_e("TotalTime");
        this.productionTime = nbttagcompound.func_74762_e("ProductionTime");
        this.tankManager.readFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("PendingProduct")) {
            nbttagcompoundP = nbttagcompound.func_74775_l("PendingProduct");
            this.pendingProduct = new ItemStack(nbttagcompoundP);
        }
        if (nbttagcompound.func_74764_b("CurrentProduct")) {
            nbttagcompoundP = nbttagcompound.func_74775_l("CurrentProduct");
            this.currentProduct = new ItemStack(nbttagcompoundP);
        }
        this.checkRecipe();
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readData(PacketBufferForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readData(data);
    }

    @Override
    public void updateServerSide() {
        boolean gloomy;
        if (this.updateOnInterval(20)) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)this, 10);
        }
        int lightvalue = this.field_145850_b.func_175671_l(this.func_174877_v().func_177984_a());
        IErrorLogic errorLogic = this.getErrorLogic();
        if (errorLogic.setCondition(!(gloomy = lightvalue <= 11), EnumErrorCode.NOT_DARK)) {
            return;
        }
        int speed = lightvalue >= 9 ? 1 : (lightvalue >= 7 ? 2 : (lightvalue >= 5 ? 3 : 4));
        if (this.burnTime > 0 && this.pendingProduct == null) {
            boolean hasLiquid = this.resourceTank.getFluidAmount() > 0;
            if (errorLogic.setCondition(!hasLiquid, EnumErrorCode.NO_RESOURCE_LIQUID)) {
                return;
            }
            this.checkRecipe();
            if (this.currentRecipe == null) {
                return;
            }
            this.resourceTank.drain(1, true);
            this.burnTime -= speed;
            this.productionTime -= speed;
            if (this.productionTime <= 0) {
                this.pendingProduct = this.currentProduct;
                this.func_70298_a(11, 1);
                this.resetRecipe();
                this.tryAddPending();
            }
        } else if (this.pendingProduct != null) {
            this.tryAddPending();
        } else if (this.rotateWorkingSlot()) {
            this.checkRecipe();
            if (this.func_70301_a(9).func_190926_b()) {
                return;
            }
            if (FuelManager.moistenerResource.containsKey(this.func_70301_a(9))) {
                MoistenerFuel res = FuelManager.moistenerResource.get(this.func_70301_a(9));
                this.burnTime = this.totalTime = res.getMoistenerValue();
            }
        } else {
            this.rotateReservoir();
        }
        errorLogic.setCondition(this.currentRecipe == null, EnumErrorCode.NO_RECIPE);
    }

    private boolean tryAddPending() {
        if (this.pendingProduct == null) {
            return false;
        }
        boolean added = InventoryUtil.tryAddStack((IInventory)this, this.pendingProduct, 10, 1, true);
        this.getErrorLogic().setCondition(!added, EnumErrorCode.NO_SPACE_INVENTORY);
        if (added) {
            this.pendingProduct = null;
        }
        return added;
    }

    public void checkRecipe() {
        IMoistenerRecipe sameRec = MoistenerRecipeManager.findMatchingRecipe(this.getInternalInventory().func_70301_a(11));
        if (this.currentRecipe != sameRec) {
            this.currentRecipe = sameRec;
            this.resetRecipe();
        }
        this.getErrorLogic().setCondition(this.currentRecipe == null, EnumErrorCode.NO_RECIPE);
    }

    private void resetRecipe() {
        if (this.currentRecipe == null) {
            this.currentProduct = null;
            this.productionTime = 0;
            this.timePerItem = 0;
        } else {
            this.currentProduct = this.currentRecipe.getProduct();
            this.productionTime = this.currentRecipe.getTimePerItem();
            this.timePerItem = this.currentRecipe.getTimePerItem();
        }
    }

    private int getFreeSlot(ItemStack deposit, int startSlot, int endSlot, boolean emptyOnly) {
        int slot = -1;
        for (int i = startSlot; i < endSlot; ++i) {
            ItemStack slotStack = this.func_70301_a(i);
            if (slotStack.func_190926_b()) {
                if (slot >= 0) continue;
                slot = i;
                continue;
            }
            if (emptyOnly || !slotStack.func_77969_a(deposit) || slotStack.func_190916_E() >= slotStack.func_77976_d()) continue;
            slot = i;
        }
        return slot;
    }

    private int getFreeStashSlot(ItemStack deposit, boolean emptyOnly) {
        return this.getFreeSlot(deposit, 0, 6, emptyOnly);
    }

    private int getFreeReservoirSlot(ItemStack deposit) {
        return this.getFreeSlot(deposit, 6, 9, false);
    }

    private int getNextResourceSlot(int startSlot, int endSlot) {
        int stage = -1;
        int resourceSlot = -1;
        IInventoryAdapter inventory = this.getInternalInventory();
        for (int i = startSlot; i < endSlot; ++i) {
            ItemStack slotStack = inventory.func_70301_a(i);
            if (slotStack.func_190926_b() || !FuelManager.moistenerResource.containsKey(slotStack)) continue;
            MoistenerFuel res = FuelManager.moistenerResource.get(slotStack);
            if (stage >= 0 && res.getStage() >= stage) continue;
            stage = res.getStage();
            resourceSlot = i;
        }
        return resourceSlot;
    }

    private boolean rotateWorkingSlot() {
        IErrorLogic errorLogic = this.getErrorLogic();
        if (!this.func_70301_a(9).func_190926_b()) {
            ItemStack deposit;
            if (FuelManager.moistenerResource.containsKey(this.func_70301_a(9))) {
                MoistenerFuel res = FuelManager.moistenerResource.get(this.func_70301_a(9));
                deposit = res.getProduct().func_77946_l();
            } else {
                deposit = this.func_70301_a(9).func_77946_l();
            }
            int targetSlot = this.getFreeReservoirSlot(deposit);
            if (errorLogic.setCondition(targetSlot < 0, EnumErrorCode.NO_SPACE_INVENTORY)) {
                return false;
            }
            if (this.func_70301_a(targetSlot).func_190926_b()) {
                this.func_70299_a(targetSlot, deposit);
            } else {
                this.func_70301_a(targetSlot).func_190917_f(1);
            }
            this.func_70298_a(9, 1);
        }
        if (!this.func_70301_a(9).func_190926_b()) {
            return true;
        }
        int resourceSlot = this.getNextResourceSlot(6, 9);
        if (errorLogic.setCondition(resourceSlot < 0, EnumErrorCode.NO_RESOURCE)) {
            return false;
        }
        this.func_70299_a(9, this.func_70298_a(resourceSlot, 1));
        return true;
    }

    private void rotateReservoir() {
        int targetSlot;
        int resourceSlot;
        ArrayList<Integer> slotsToShift = new ArrayList<Integer>();
        for (int i = 6; i < 9; ++i) {
            if (this.func_70301_a(i).func_190926_b() || FuelManager.moistenerResource.containsKey(this.func_70301_a(i))) continue;
            slotsToShift.add(i);
        }
        int shiftedSlots = 0;
        Iterator iterator = slotsToShift.iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            ItemStack slotStack = this.func_70301_a(slot);
            int targetSlot2 = this.getFreeStashSlot(slotStack, true);
            if (targetSlot2 < 0) continue;
            this.func_70299_a(targetSlot2, slotStack);
            this.func_70299_a(slot, ItemStack.field_190927_a);
            ++shiftedSlots;
        }
        for (int i = 0; i < (!slotsToShift.isEmpty() ? shiftedSlots : 2) && (resourceSlot = this.getNextResourceSlot(0, 6)) >= 0 && (targetSlot = this.getFreeReservoirSlot(this.func_70301_a(resourceSlot))) >= 0; ++i) {
            if (this.func_70301_a(targetSlot).func_190926_b()) {
                this.func_70299_a(targetSlot, this.func_70301_a(resourceSlot));
                this.func_70299_a(resourceSlot, ItemStack.field_190927_a);
                continue;
            }
            ItemStackUtil.mergeStacks(this.func_70301_a(resourceSlot), this.func_70301_a(targetSlot));
        }
    }

    public boolean isWorking() {
        return this.burnTime > 0 && this.resourceTank.getFluidAmount() > 0;
    }

    public boolean hasFuelMin(float percentage) {
        int max = 0;
        int avail = 0;
        IInventoryAdapter inventory = this.getInternalInventory();
        for (int i = 0; i < 6; ++i) {
            MoistenerFuel res;
            if (inventory.func_70301_a(i).func_190926_b()) {
                max += 64;
                continue;
            }
            if (!FuelManager.moistenerResource.containsKey(inventory.func_70301_a(i)) || !(res = FuelManager.moistenerResource.get(inventory.func_70301_a(i))).getItem().func_77969_a(inventory.func_70301_a(i))) continue;
            max += 64;
            avail += inventory.func_70301_a(i).func_190916_E();
        }
        return (float)avail / (float)max > percentage;
    }

    public boolean hasResourcesMin(float percentage) {
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.func_70301_a(11).func_190926_b()) {
            return false;
        }
        return (float)inventory.func_70301_a(11).func_190916_E() / (float)inventory.func_70301_a(11).func_77976_d() > percentage;
    }

    public boolean isProducing() {
        return this.productionTime > 0;
    }

    public int getProductionProgressScaled(int i) {
        if (this.timePerItem == 0) {
            return 0;
        }
        return this.productionTime * i / this.timePerItem;
    }

    public int getConsumptionProgressScaled(int i) {
        if (this.totalTime == 0) {
            return 0;
        }
        return this.burnTime * i / this.totalTime;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.getFluidAmount() * i / 10000;
    }

    @Override
    public TankRenderInfo getResourceTankInfo() {
        return new TankRenderInfo((IFluidTank)this.resourceTank);
    }

    @Override
    public TankRenderInfo getProductTankInfo() {
        return TankRenderInfo.EMPTY;
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.burnTime = j;
                break;
            }
            case 1: {
                this.totalTime = j;
                break;
            }
            case 2: {
                this.productionTime = j;
                break;
            }
            case 3: {
                this.timePerItem = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, IContainerListener iCrafting) {
        iCrafting.func_71112_a(container, 0, this.burnTime);
        iCrafting.func_71112_a(container, 1, this.totalTime);
        iCrafting.func_71112_a(container, 2, this.productionTime);
        iCrafting.func_71112_a(container, 3, this.timePerItem);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(EntityPlayer player, int data) {
        return new GuiMoistener(player.field_71071_by, this);
    }

    @Override
    public Container getContainer(EntityPlayer player, int data) {
        return new ContainerMoistener(player.field_71071_by, this);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tankManager);
        }
        return super.getCapability(capability, facing);
    }
}

