/*
 * Decompiled with CFR 0.152.
 */
package forestry.cultivation.inventory;

import forestry.api.core.ForestryAPI;
import forestry.api.farming.FarmDirection;
import forestry.api.farming.IFarmLogic;
import forestry.api.farming.IFarmable;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.inventory.InventoryAdapterRestricted;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.SlotUtil;
import forestry.cultivation.tiles.TilePlanter;
import forestry.farming.FarmHelper;
import forestry.farming.multiblock.IFarmInventoryInternal;
import java.util.Stack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class InventoryPlanter
extends InventoryAdapterRestricted
implements IFarmInventoryInternal {
    public static final int SLOT_RESOURCES_1 = 0;
    public static final int SLOT_RESOURCES_COUNT = 4;
    public static final int SLOT_GERMLINGS_1 = 4;
    public static final int SLOT_GERMLINGS_COUNT = 4;
    public static final int SLOT_PRODUCTION_1 = 8;
    public static final int SLOT_PRODUCTION_COUNT = 4;
    public static final int SLOT_FERTILIZER = 12;
    public static final int SLOT_FERTILIZER_COUNT = 1;
    public static final int SLOT_CAN = 13;
    public static final int SLOT_CAN_COUNT = 1;
    public static final int SLOT_COUNT = 14;
    private static final int FERTILIZER_MODIFIER = ForestryAPI.activeMode.getIntegerSetting("farms.fertilizer.modifier");
    private final TilePlanter housing;
    private final IInventory resourcesInventory;
    private final IInventory germlingsInventory;
    private final IInventory productInventory;
    private final IInventory fertilizerInventory;

    public InventoryPlanter(TilePlanter housing) {
        super(14, "Items");
        this.housing = housing;
        this.resourcesInventory = new InventoryMapper((IInventory)this, 0, 4);
        this.germlingsInventory = new InventoryMapper((IInventory)this, 4, 4);
        this.productInventory = new InventoryMapper((IInventory)this, 8, 4);
        this.fertilizerInventory = new InventoryMapper((IInventory)this, 12, 1);
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        if (SlotUtil.isSlotInRange(slotIndex, 12, 1)) {
            return this.acceptsAsFertilizer(itemStack);
        }
        if (SlotUtil.isSlotInRange(slotIndex, 4, 4)) {
            return this.acceptsAsGermling(itemStack);
        }
        if (SlotUtil.isSlotInRange(slotIndex, 0, 4)) {
            return this.acceptsAsResource(itemStack);
        }
        if (SlotUtil.isSlotInRange(slotIndex, 13, 1)) {
            FluidStack fluid = FluidUtil.getFluidContained((ItemStack)itemStack);
            return fluid != null && this.housing.getTankManager().canFillFluidType(fluid);
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slotIndex, ItemStack stack, EnumFacing side) {
        return SlotUtil.isSlotInRange(slotIndex, 8, 4);
    }

    @Override
    public boolean hasResources(NonNullList<ItemStack> resources) {
        return InventoryUtil.contains(this.resourcesInventory, resources);
    }

    @Override
    public void removeResources(NonNullList<ItemStack> resources) {
        InventoryUtil.removeSets(this.resourcesInventory, 1, resources, null, false, true, false, true);
    }

    @Override
    public boolean acceptsAsGermling(ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            return false;
        }
        IFarmLogic logic = this.housing.getFarmLogic();
        return logic.isAcceptedGermling(itemstack);
    }

    @Override
    public boolean acceptsAsResource(ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            return false;
        }
        IFarmLogic logic = this.housing.getFarmLogic();
        return logic.isAcceptedResource(itemstack);
    }

    @Override
    public boolean acceptsAsFertilizer(ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            return false;
        }
        return ForestryAPI.farmRegistry.getFertilizeValue(itemstack) > 0;
    }

    @Override
    public IInventory getProductInventory() {
        return this.productInventory;
    }

    @Override
    public IInventory getGermlingsInventory() {
        return this.germlingsInventory;
    }

    @Override
    public IInventory getResourcesInventory() {
        return this.resourcesInventory;
    }

    @Override
    public IInventory getFertilizerInventory() {
        return this.fertilizerInventory;
    }

    public void drainCan(TankManager tankManager) {
        FluidHelper.drainContainers(tankManager, (IInventory)this, 13);
    }

    public boolean plantGermling(IFarmable germling, EntityPlayer player, BlockPos pos) {
        for (FarmDirection direction : FarmDirection.values()) {
            if (!this.plantGermling(germling, player, pos, direction)) continue;
            return true;
        }
        return false;
    }

    public boolean plantGermling(IFarmable germling, EntityPlayer player, BlockPos pos, FarmDirection direction) {
        int index = FarmHelper.getReversedLayoutDirection(direction).ordinal();
        ItemStack germlingStack = this.germlingsInventory.func_70301_a(index);
        if (germlingStack.func_190926_b() || !germling.isGermling(germlingStack)) {
            return false;
        }
        if (germling.plantSaplingAt(player, germlingStack, player.field_70170_p, pos)) {
            this.germlingsInventory.func_70298_a(index, 1);
            return true;
        }
        return false;
    }

    public void addProduce(ItemStack produce) {
        int added = InventoryUtil.addStack(this.productInventory, produce, true);
        produce.func_190918_g(added);
    }

    public void stowHarvest(Iterable<ItemStack> harvested, Stack<ItemStack> pendingProduce) {
        for (ItemStack harvest : harvested) {
            int added = InventoryUtil.addStack(this.productInventory, harvest, true);
            harvest.func_190918_g(added);
            if (harvest.func_190926_b()) continue;
            pendingProduce.push(harvest);
        }
    }

    public boolean tryAddPendingProduce(Stack<ItemStack> pendingProduce) {
        ItemStack next;
        IInventory productInventory = this.getProductInventory();
        boolean added = InventoryUtil.tryAddStack(productInventory, next = pendingProduce.peek(), true, true);
        if (added) {
            pendingProduce.pop();
        }
        return added;
    }

    @Override
    public int getFertilizerValue() {
        ItemStack fertilizerStack = this.func_70301_a(12);
        if (fertilizerStack.func_190926_b()) {
            return 0;
        }
        int fertilizerValue = ForestryAPI.farmRegistry.getFertilizeValue(fertilizerStack);
        if (fertilizerValue > 0) {
            return fertilizerValue * FERTILIZER_MODIFIER;
        }
        return 0;
    }

    @Override
    public boolean useFertilizer() {
        ItemStack fertilizer = this.func_70301_a(12);
        if (this.acceptsAsFertilizer(fertilizer)) {
            this.func_70298_a(12, 1);
            return true;
        }
        return false;
    }
}

