/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import com.google.common.collect.ImmutableSet;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.core.IErrorSource;
import forestry.api.core.IErrorState;
import forestry.core.circuits.CircuitRecipe;
import forestry.core.circuits.CircuitRegistry;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.circuits.SolderManager;
import forestry.core.errors.EnumErrorCode;
import forestry.core.inventory.ItemInventory;
import forestry.core.utils.datastructures.RevolvingList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemInventorySolderingIron
extends ItemInventory
implements IErrorSource {
    private final RevolvingList<ICircuitLayout> layouts = new RevolvingList<ICircuitLayout>(ChipsetManager.circuitRegistry.getRegisteredLayouts().values());
    private static final short inputCircuitBoardSlot = 0;
    private static final short finishedCircuitBoardSlot = 1;
    private static final short ingredientSlot1 = 2;
    private static final short ingredientSlotCount = 4;

    public ItemInventorySolderingIron(EntityPlayer player, ItemStack itemStack) {
        super(player, 6, itemStack);
        this.layouts.setCurrent(ChipsetManager.circuitRegistry.getDefaultLayout());
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public ICircuitLayout getLayout() {
        return this.layouts.getCurrent();
    }

    public void setLayout(ICircuitLayout layout) {
        this.layouts.setCurrent(layout);
    }

    public void advanceLayout() {
        this.layouts.rotateRight();
    }

    public void regressLayout() {
        this.layouts.rotateLeft();
    }

    private ICircuit[] getCircuits(boolean doConsume) {
        ICircuit[] circuits = new ICircuit[4];
        for (int i = 0; i < 4; i = (int)((short)(i + 1))) {
            CircuitRecipe recipe;
            ItemStack ingredient = this.func_70301_a(2 + i);
            if (ingredient.func_190926_b() || (recipe = SolderManager.getMatchingRecipe(this.layouts.getCurrent(), ingredient)) == null) continue;
            if (doConsume) {
                this.func_70298_a(2 + i, recipe.getResource().func_190916_E());
            }
            circuits[i] = recipe.getCircuit();
        }
        return circuits;
    }

    @Override
    public void onSlotClick(int slotIndex, EntityPlayer player) {
        if (this.layouts.getCurrent() == CircuitRegistry.DUMMY_LAYOUT) {
            return;
        }
        ItemStack inputCircuitBoard = this.func_70301_a(0);
        if (inputCircuitBoard.func_190926_b() || inputCircuitBoard.func_190916_E() > 1) {
            return;
        }
        if (!this.func_70301_a(1).func_190926_b()) {
            return;
        }
        if (!ChipsetManager.circuitRegistry.isChipset(inputCircuitBoard)) {
            return;
        }
        if (inputCircuitBoard.func_77952_i() < 0 || inputCircuitBoard.func_77952_i() >= EnumCircuitBoardType.values().length) {
            return;
        }
        EnumCircuitBoardType type = EnumCircuitBoardType.values()[inputCircuitBoard.func_77952_i()];
        if (this.getCircuitCount() != type.getSockets()) {
            return;
        }
        ICircuit[] circuits = this.getCircuits(true);
        ItemStack outputCircuitBoard = ItemCircuitBoard.createCircuitboard(type, this.layouts.getCurrent(), circuits);
        this.func_70299_a(1, outputCircuitBoard);
        this.func_70299_a(0, ItemStack.field_190927_a);
    }

    private int getCircuitCount() {
        ICircuit[] circuits = this.getCircuits(false);
        int count = 0;
        for (ICircuit circuit : circuits) {
            if (circuit == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public ImmutableSet<IErrorState> getErrorStates() {
        ItemStack blankCircuitBoard;
        ImmutableSet.Builder errorStates = ImmutableSet.builder();
        if (this.layouts.getCurrent() == CircuitRegistry.DUMMY_LAYOUT) {
            errorStates.add((Object)EnumErrorCode.NO_CIRCUIT_LAYOUT);
        }
        if ((blankCircuitBoard = this.func_70301_a(0)).func_190926_b()) {
            errorStates.add((Object)EnumErrorCode.NO_CIRCUIT_BOARD);
        } else {
            EnumCircuitBoardType type = EnumCircuitBoardType.values()[blankCircuitBoard.func_77952_i()];
            int circuitCount = 0;
            for (int i = 0; i < type.getSockets(); i = (int)((short)(i + 1))) {
                if (this.func_70301_a(2 + i).func_190926_b()) continue;
                ++circuitCount;
            }
            if (circuitCount != type.getSockets()) {
                errorStates.add((Object)EnumErrorCode.CIRCUIT_MISMATCH);
            } else {
                int count = this.getCircuitCount();
                if (count != type.getSockets()) {
                    errorStates.add((Object)EnumErrorCode.NO_CIRCUIT_LAYOUT);
                }
            }
        }
        return errorStates.build();
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        if (slotIndex == 0) {
            return item instanceof ItemCircuitBoard;
        }
        if (slotIndex >= 2 && slotIndex < 6) {
            CircuitRecipe recipe = SolderManager.getMatchingRecipe(this.layouts.getCurrent(), itemStack);
            return recipe != null;
        }
        return false;
    }
}

