/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.tiles.TileNaturalistChest;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.oredict.OreDictionary;

public class InventoryNaturalistChest
extends InventoryAdapterTile<TileNaturalistChest> {
    public static final int treeSaplingId = OreDictionary.getOreID((String)"treeSapling");
    private final ISpeciesRoot speciesRoot;

    public InventoryNaturalistChest(TileNaturalistChest tile, ISpeciesRoot speciesRoot) {
        super(tile, 125, "Items");
        this.speciesRoot = speciesRoot;
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemstack) {
        int[] oreIds;
        if (itemstack.func_190926_b()) {
            return false;
        }
        if (this.speciesRoot.isMember(itemstack)) {
            return true;
        }
        if (this.speciesRoot != TreeManager.treeRoot) {
            return false;
        }
        for (int oreId : oreIds = OreDictionary.getOreIDs((ItemStack)itemstack)) {
            if (oreId != treeSaplingId) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slotIndex, ItemStack stack, EnumFacing side) {
        return true;
    }
}

