/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.widgets;

import forestry.core.gui.Drawable;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import net.minecraft.client.renderer.GlStateManager;

public class WidgetSlider
extends Widget {
    private final Drawable texture;
    private int xOffset;
    private int yOffset;

    public WidgetSlider(WidgetManager manager, int xPos, int yPos, Drawable texture) {
        super(manager, xPos, yPos);
        this.texture = texture;
        this.width = texture.uWidth;
        this.height = texture.vHeight;
    }

    public void setOffset(int xOffset, int yOffset) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    @Override
    public void draw(int startX, int startY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.texture.draw(startX + this.xPos + this.xOffset, startY + this.yPos + this.yOffset);
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        int xPos = this.xPos + this.xOffset;
        int yPos = this.yPos + this.yOffset;
        return mouseX >= xPos && mouseX <= xPos + this.width && mouseY >= yPos && mouseY <= yPos + this.height;
    }
}

